/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mteenoughitems.jei.immersiveengineering;

import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDevice1;
import io.bluebeaker.mteenoughitems.jei.generic.GenericRecipeCategory;
import io.bluebeaker.mteenoughitems.utils.ModChecker;
import io.bluebeaker.mteenoughitems.utils.RenderUtils;
import io.bluebeaker.mteenoughitems.utils.StringUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

public class MineralDepositCategory
extends GenericRecipeCategory<Wrapper> {
    public static final String UID = "mteenoughitems.immersiveengineering.mineral_deposit";
    public static final int MARGIN_X = 4;

    public MineralDepositCategory(IGuiHelper guiHelper) {
        super(guiHelper, 170, 50);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((Block)IEContent.blockMetalDevice1, 1, BlockTypes_MetalDevice1.SAMPLE_DRILL.getMeta()));
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, Wrapper wrapper, IIngredients iIngredients) {
        IGuiItemStackGroup guiItemStackGroup = recipeLayout.getItemStacks();
        for (int i = 0; i < wrapper.mineralMix.oreOutput.size(); ++i) {
            this.addItemSlot(guiItemStackGroup, i, 4 + 18 * (i % 9), 24 + 18 * (i / 9));
            guiItemStackGroup.set(i, (ItemStack)wrapper.mineralMix.oreOutput.get(i));
        }
        guiItemStackGroup.addTooltipCallback((ITooltipCallback)new TooltipCallback(wrapper));
    }

    @Override
    public String getTranslationKey() {
        return "category.mteenoughitems.immersiveengineering.mineral_deposit.name";
    }

    public String getUid() {
        return UID;
    }

    public String getModName() {
        return ModChecker.ImmersiveEngineering.name;
    }

    public static List<Wrapper> getRecipes(IJeiHelpers jeiHelpers) {
        ArrayList<Wrapper> recipes = new ArrayList<Wrapper>();
        for (Map.Entry entry : ExcavatorHandler.mineralList.entrySet()) {
            ExcavatorHandler.MineralMix mix = (ExcavatorHandler.MineralMix)entry.getKey();
            int weight = (Integer)entry.getValue();
            recipes.add(new Wrapper(mix, weight));
        }
        return recipes;
    }

    public static String getOreName(String name) {
        String formatted = I18n.func_135052_a((String)("desc.immersiveengineering.info.mineral." + name), (Object[])new Object[0]);
        if (formatted.equals("desc.immersiveengineering.info.mineral." + name)) {
            return name;
        }
        return formatted;
    }

    public static class TooltipCallback
    implements ITooltipCallback<ItemStack> {
        public final Wrapper wrapper;

        public TooltipCallback(Wrapper wrapper) {
            this.wrapper = wrapper;
        }

        public void onTooltip(int i, boolean b, ItemStack stack, List<String> list) {
            float[] chances = this.wrapper.mineralMix.recalculatedChances;
            if (i >= chances.length) {
                return;
            }
            list.add(String.format("%.2f%%", Float.valueOf(chances[i] * 100.0f)));
            list.add(I18n.func_135052_a((String)"category.mteenoughitems.immersiveengineering.mineral_deposit.count", (Object[])new Object[]{String.format("%.1f", Float.valueOf(chances[i] * (float)ExcavatorHandler.mineralVeinCapacity))}));
        }
    }

    public static class Wrapper
    implements IRecipeWrapper {
        public final ExcavatorHandler.MineralMix mineralMix;
        public final int weight;

        public Wrapper(ExcavatorHandler.MineralMix mineralMix, int weight) {
            this.mineralMix = mineralMix;
            this.weight = weight;
        }

        public void getIngredients(IIngredients iIngredients) {
            iIngredients.setOutputs(VanillaTypes.ITEM, (List)this.mineralMix.oreOutput);
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            int y = 2;
            RenderUtils.drawTextAlignedLeft(MineralDepositCategory.getOreName(this.mineralMix.name), 4, y, Color.gray.getRGB());
            RenderUtils.drawTextAlignedRight(I18n.func_135052_a((String)"category.mteenoughitems.immersiveengineering.mineral_deposit.weight", (Object[])new Object[]{this.weight}), recipeWidth - 4, y, Color.gray.getRGB());
            y = y + minecraft.field_71466_p.field_78288_b + 1;
            RenderUtils.drawTextAlignedLeft(this.getDimListStr(), 4, y, Color.gray.getRGB());
        }

        public String getDimListStr() {
            String str = "";
            if (this.mineralMix.dimensionWhitelist.length > 0) {
                str = I18n.func_135052_a((String)"category.mteenoughitems.immersiveengineering.mineral_deposit.whitelist", (Object[])new Object[]{StringUtils.join(Arrays.stream(this.mineralMix.dimensionWhitelist).boxed(), ",")});
            } else if (this.mineralMix.dimensionBlacklist.length > 0) {
                str = I18n.func_135052_a((String)"category.mteenoughitems.immersiveengineering.mineral_deposit.blacklist", (Object[])new Object[]{StringUtils.join(Arrays.stream(this.mineralMix.dimensionBlacklist).boxed(), ",")});
            }
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            if (fontRenderer.func_78256_a(str) > 162) {
                str = fontRenderer.func_78269_a(str, 162 - fontRenderer.func_78256_a("...")) + "...";
            }
            return str;
        }

        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            if (mouseY >= 2 && mouseY <= 11 && mouseX >= 4 && mouseX < 166 && mouseX <= 4 + Minecraft.func_71410_x().field_71466_p.func_78256_a(MineralDepositCategory.getOreName(this.mineralMix.name))) {
                return Collections.singletonList(this.mineralMix.name);
            }
            if (mouseY >= 12 && mouseY <= 21 && mouseX >= 4 && mouseX <= 166) {
                int[] dimList;
                if (this.mineralMix.dimensionWhitelist.length > 0) {
                    dimList = this.mineralMix.dimensionWhitelist;
                } else if (this.mineralMix.dimensionBlacklist.length > 0) {
                    dimList = this.mineralMix.dimensionBlacklist;
                } else {
                    return Collections.emptyList();
                }
                if (mouseX > 4 + Minecraft.func_71410_x().field_71466_p.func_78256_a(this.getDimListStr())) {
                    return Collections.emptyList();
                }
                ArrayList<String> lines = new ArrayList<String>();
                for (int i : dimList) {
                    lines.add(StringUtils.getDimensionName(i));
                }
                return lines;
            }
            return Collections.emptyList();
        }
    }
}

