/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mteenoughitems.jei.plugins;

import io.bluebeaker.mteenoughitems.MTEEnoughItemsConfig;
import io.bluebeaker.mteenoughitems.jei.plugins.IPlugin;
import io.bluebeaker.mteenoughitems.jei.railcraft.BlastFurnaceFuelCategory;
import io.bluebeaker.mteenoughitems.jei.railcraft.BoilerCategory;
import io.bluebeaker.mteenoughitems.jei.railcraft.FluidFireboxCategory;
import io.bluebeaker.mteenoughitems.jei.railcraft.WorldSpikeFuelCategory;
import io.bluebeaker.mteenoughitems.jei.utils.RegistryUtils;
import io.bluebeaker.mteenoughitems.utils.ItemUtils;
import io.bluebeaker.mteenoughitems.utils.ModChecker;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mods.railcraft.client.gui.GuiBlastFurnace;
import mods.railcraft.client.gui.GuiBoilerFluid;
import mods.railcraft.client.gui.GuiBoilerSolid;
import mods.railcraft.client.gui.GuiWorldspike;

public class RailcraftPlugin
implements IPlugin {
    @Override
    public String getName() {
        return "Railcraft";
    }

    @Override
    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        if (MTEEnoughItemsConfig.railcraft.fluid_firebox) {
            registry.addRecipeCategories(new IRecipeCategory[]{new FluidFireboxCategory(guiHelper)});
        }
        if (MTEEnoughItemsConfig.railcraft.boiler) {
            registry.addRecipeCategories(new IRecipeCategory[]{new BoilerCategory(guiHelper)});
        }
        if (MTEEnoughItemsConfig.railcraft.blast_furnace_fuel) {
            registry.addRecipeCategories(new IRecipeCategory[]{new BlastFurnaceFuelCategory(guiHelper)});
        }
        if (MTEEnoughItemsConfig.railcraft.worldspike_fuel) {
            registry.addRecipeCategories(new IRecipeCategory[]{new WorldSpikeFuelCategory(guiHelper)});
        }
    }

    @Override
    public void register(IModRegistry registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        registry.addRecipeClickArea(GuiBlastFurnace.class, 56, 36, 14, 14, new String[]{"mteenoughitems.railcraft.blast_furnace_fuel"});
        registry.addRecipeClickArea(GuiWorldspike.class, 90, 23, 32, 18, new String[]{"mteenoughitems.railcraft.worldspike_fuel"});
        registry.addRecipeClickArea(GuiBoilerFluid.class, 62, 38, 14, 14, new String[]{"mteenoughitems.railcraft.fluid_firebox", "mteenoughitems.railcraft.boiler"});
        registry.addRecipeClickArea(GuiBoilerSolid.class, 62, 22, 14, 14, new String[]{"mteenoughitems.railcraft.boiler"});
        for (int i = 1; i <= 3; ++i) {
            RegistryUtils.tryAddItemCatalyst(registry, ItemUtils.getItemstack(ModChecker.Railcraft.name, "worldspike", i), "mteenoughitems.railcraft.worldspike_fuel");
        }
        RegistryUtils.tryAddItemCatalyst(registry, ItemUtils.getItemstack(ModChecker.Railcraft.name, "blast_furnace"), "mteenoughitems.railcraft.blast_furnace_fuel");
        RegistryUtils.tryAddItemCatalyst(registry, ItemUtils.getItemstack(ModChecker.Railcraft.name, "boiler_firebox_solid"), "mteenoughitems.railcraft.boiler");
        RegistryUtils.tryAddItemCatalyst(registry, ItemUtils.getItemstack(ModChecker.Railcraft.name, "locomotive_steam_solid"), "mteenoughitems.railcraft.boiler");
        RegistryUtils.tryAddItemCatalyst(registry, ItemUtils.getItemstack(ModChecker.Railcraft.name, "boiler_firebox_fluid"), "mteenoughitems.railcraft.fluid_firebox", "mteenoughitems.railcraft.boiler");
        RegistryUtils.tryAddItemCatalyst(registry, ItemUtils.getItemstack(ModChecker.Railcraft.name, "boiler_tank_pressure_high"), "mteenoughitems.railcraft.fluid_firebox", "mteenoughitems.railcraft.boiler");
        RegistryUtils.tryAddItemCatalyst(registry, ItemUtils.getItemstack(ModChecker.Railcraft.name, "boiler_tank_pressure_low"), "mteenoughitems.railcraft.fluid_firebox", "mteenoughitems.railcraft.boiler");
        if (MTEEnoughItemsConfig.railcraft.fluid_firebox) {
            registry.addRecipes(FluidFireboxCategory.getRecipes(jeiHelpers), "mteenoughitems.railcraft.fluid_firebox");
        }
        if (MTEEnoughItemsConfig.railcraft.boiler) {
            registry.addRecipes(BoilerCategory.getRecipes(jeiHelpers), "mteenoughitems.railcraft.boiler");
        }
        if (MTEEnoughItemsConfig.railcraft.blast_furnace_fuel) {
            registry.addRecipes(BlastFurnaceFuelCategory.getRecipes(jeiHelpers), "mteenoughitems.railcraft.blast_furnace_fuel");
        }
        if (MTEEnoughItemsConfig.railcraft.worldspike_fuel) {
            registry.addRecipes(WorldSpikeFuelCategory.getRecipes(jeiHelpers), "mteenoughitems.railcraft.worldspike_fuel");
        }
    }
}

