/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mteenoughitems.jei.railcraft;

import io.bluebeaker.mteenoughitems.jei.generic.FuelRecipeWrapper;
import io.bluebeaker.mteenoughitems.jei.generic.GenericRecipeCategory;
import io.bluebeaker.mteenoughitems.utils.ModChecker;
import io.bluebeaker.mteenoughitems.utils.RenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mods.railcraft.api.crafting.ISimpleRecipe;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.util.crafting.BlastFurnaceCrafter;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class BlastFurnaceFuelCategory
extends GenericRecipeCategory<BlastFurnaceFuelRecipeWrapper> {
    public static final String UID = "mteenoughitems.railcraft.blast_furnace_fuel";
    public static final ResourceLocation GUI_PATH = new ResourceLocation("railcraft", "textures/gui/gui_blast_furnace.png");
    protected final IDrawableStatic bgHeatBar;
    protected final IDrawableAnimated heatBar;

    public BlastFurnaceFuelCategory(IGuiHelper guiHelper) {
        super(guiHelper, 116, 32);
        this.bgHeatBar = guiHelper.createDrawable(GUI_PATH, 56, 36, 14, 14);
        this.heatBar = guiHelper.drawableBuilder(GUI_PATH, 176, 0, 14, 14).buildAnimated(200, IDrawableAnimated.StartDirection.TOP, true);
        ItemBlock item = RailcraftBlocks.BLAST_FURNACE.item();
        this.icon = item == null ? null : guiHelper.createDrawableIngredient((Object)new ItemStack((Item)item));
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, BlastFurnaceFuelRecipeWrapper wrapper, IIngredients iIngredients) {
        IGuiItemStackGroup guiItemStackGroup = recipeLayout.getItemStacks();
        this.addItemSlot(guiItemStackGroup, 0, 8, this.GUI_HEIGHT / 2);
        guiItemStackGroup.set(0, wrapper.getInput());
    }

    public void drawExtras(Minecraft minecraft) {
        this.bgHeatBar.draw(minecraft, 10, this.GUI_HEIGHT / 2 - 18);
        this.heatBar.draw(minecraft, 10, this.GUI_HEIGHT / 2 - 18);
    }

    @Override
    public String getTranslationKey() {
        return "category.mteenoughitems.railcraft.blast_furnace_fuel.name";
    }

    public String getUid() {
        return UID;
    }

    public String getModName() {
        return ModChecker.Railcraft.name;
    }

    public static List<BlastFurnaceFuelRecipeWrapper> getRecipes(IJeiHelpers jeiHelpers) {
        ArrayList<BlastFurnaceFuelRecipeWrapper> recipes = new ArrayList<BlastFurnaceFuelRecipeWrapper>();
        for (ISimpleRecipe recipe : BlastFurnaceCrafter.INSTANCE.getFuels()) {
            for (ItemStack matchingStack : recipe.getInput().func_193365_a()) {
                recipes.add(new BlastFurnaceFuelRecipeWrapper(matchingStack, recipe.getTickTime(matchingStack) / 5));
            }
        }
        return recipes;
    }

    public static class BlastFurnaceFuelRecipeWrapper
    extends FuelRecipeWrapper {
        public BlastFurnaceFuelRecipeWrapper(ItemStack input, int duration) {
            super(input, 0, duration);
        }

        @Override
        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            int xPos = recipeWidth / 2;
            int yPos = recipeHeight / 2 - minecraft.field_71466_p.field_78288_b;
            RenderUtils.drawTextAlignedMiddle(this.duration + "ticks", xPos, yPos, Color.gray.getRGB());
            RenderUtils.drawTextAlignedMiddle(this.duration / 20 + "secs", xPos, yPos += minecraft.field_71466_p.field_78288_b + 2, Color.gray.getRGB());
        }
    }
}

