/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mteenoughitems.jei.railcraft;

import io.bluebeaker.mteenoughitems.jei.generic.FluidHeatConversionCategory;
import io.bluebeaker.mteenoughitems.jei.generic.FluidHeatConversionRecipe;
import io.bluebeaker.mteenoughitems.utils.ModChecker;
import io.bluebeaker.mteenoughitems.utils.RenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.fluids.Fluids;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BoilerCategory
extends FluidHeatConversionCategory<BoilerRecipe> {
    protected final IDrawableStatic bgFire;
    protected final IDrawableAnimated fire;
    public static final String UID = "mteenoughitems.railcraft.boiler";
    public static final ResourceLocation GUI_PATH = new ResourceLocation("railcraft", "textures/gui/gui_boiler_liquid.png");

    public BoilerCategory(IGuiHelper guiHelper) {
        super(guiHelper);
        this.bgFire = guiHelper.createDrawable(GUI_PATH, 62, 38, 14, 14);
        this.fire = guiHelper.drawableBuilder(GUI_PATH, 176, 47, 14, 14).buildAnimated(200, IDrawableAnimated.StartDirection.TOP, true);
        ItemBlock item = RailcraftBlocks.BOILER_TANK_PRESSURE_LOW.item();
        this.icon = item == null ? null : guiHelper.createDrawableIngredient((Object)new ItemStack((Item)item));
    }

    public String getModName() {
        return ModChecker.Railcraft.name;
    }

    @Override
    public String getTranslationKey() {
        return "category.mteenoughitems.railcraft.boiler.name";
    }

    public String getUid() {
        return UID;
    }

    public static List<BoilerRecipe> getRecipes(IJeiHelpers jeiHelpers) {
        ArrayList<BoilerRecipe> recipes = new ArrayList<BoilerRecipe>();
        recipes.add(new BoilerRecipe(jeiHelpers, new FluidStack(FluidRegistry.WATER, 1), new FluidStack(Fluids.STEAM.get(), 160)));
        return recipes;
    }

    public static class BoilerRecipe
    extends FluidHeatConversionRecipe {
        public BoilerRecipe(IJeiHelpers jeiHelpers, FluidStack input, FluidStack output) {
            super(jeiHelpers, input, output, 1L);
        }

        @Override
        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            int xPos = recipeWidth / 2;
            int yPos = recipeHeight / 2 - minecraft.field_71466_p.field_78288_b;
            RenderUtils.drawTextAlignedMiddle(">=100\u00b0C", xPos, yPos, Color.gray.getRGB());
        }

        @Override
        public String getPowerUnit() {
            return "";
        }
    }
}

