/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mteenoughitems.jei.railcraft;

import io.bluebeaker.mteenoughitems.jei.generic.FuelRecipeWrapper;
import io.bluebeaker.mteenoughitems.jei.generic.GenericRecipeCategory;
import io.bluebeaker.mteenoughitems.utils.ModChecker;
import io.bluebeaker.mteenoughitems.utils.RenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.machine.worldspike.WorldspikeVariant;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

public class WorldSpikeFuelCategory
extends GenericRecipeCategory<Wrapper> {
    public static final String UID = "mteenoughitems.railcraft.worldspike_fuel";

    public WorldSpikeFuelCategory(IGuiHelper guiHelper) {
        super(guiHelper, 116, 32);
        ItemBlock item = RailcraftBlocks.WORLDSPIKE.item();
        this.icon = item == null ? null : guiHelper.createDrawableIngredient((Object)new ItemStack((Item)item, 1, 1));
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, Wrapper wrapper, IIngredients iIngredients) {
        IGuiItemStackGroup guiItemStackGroup = recipeLayout.getItemStacks();
        this.addItemSlot(guiItemStackGroup, 0, 8, this.GUI_HEIGHT / 2 - 9);
        this.addItemSlot(guiItemStackGroup, 1, this.GUI_WIDTH - 26, this.GUI_HEIGHT / 2 - 9);
        guiItemStackGroup.set(iIngredients);
    }

    public void drawExtras(Minecraft minecraft) {
    }

    @Override
    public String getTranslationKey() {
        return "category.mteenoughitems.railcraft.worldspike_fuel.name";
    }

    public String getUid() {
        return UID;
    }

    public String getModName() {
        return ModChecker.Railcraft.name;
    }

    public static List<Wrapper> getRecipes(IJeiHelpers jeiHelpers) {
        ArrayList<Wrapper> recipes = new ArrayList<Wrapper>();
        for (int i = 1; i < WorldspikeVariant.values().length; ++i) {
            Map fuelList = WorldspikeVariant.fromId((int)i).getFuelList();
            for (Ingredient ingredient : fuelList.keySet()) {
                recipes.add(new Wrapper(ingredient, ((Float)fuelList.get(ingredient)).floatValue(), i));
            }
        }
        return recipes;
    }

    public static class Wrapper
    extends FuelRecipeWrapper {
        float duration;
        final Ingredient ingredient;
        final int variant;

        public Wrapper(Ingredient input, float duration, int variant) {
            super(ItemStack.field_190927_a, 0, (int)duration);
            this.duration = duration;
            this.ingredient = input;
            this.variant = variant;
        }

        @Override
        public void getIngredients(IIngredients iIngredients) {
            ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
            inputs.add(Arrays.asList(this.ingredient.field_193371_b));
            ItemBlock worldspikeItem = RailcraftBlocks.WORLDSPIKE.item();
            if (worldspikeItem != null) {
                inputs.add(Collections.singletonList(new ItemStack((Item)worldspikeItem, 1, this.variant)));
            }
            iIngredients.setInputLists(VanillaTypes.ITEM, inputs);
        }

        @Override
        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            int xPos = recipeWidth / 2;
            int yPos = recipeHeight / 2 - minecraft.field_71466_p.field_78288_b;
            RenderUtils.drawTextAlignedMiddle(String.format("%.2fh", Float.valueOf(this.duration)), xPos, yPos, Color.gray.getRGB());
            yPos = yPos + minecraft.field_71466_p.field_78288_b + 2;
            RenderUtils.drawTextAlignedMiddle(WorldspikeVariant.VALUES[this.variant].getBaseTag(), xPos, yPos, Color.gray.getRGB());
        }
    }
}

