/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mteenoughitems.jei.thermal;

import cofh.core.fluid.BlockFluidInteractive;
import cofh.thermalfoundation.init.TFFluids;
import io.bluebeaker.mteenoughitems.Constants;
import io.bluebeaker.mteenoughitems.jei.generic.GenericRecipeCategory;
import io.bluebeaker.mteenoughitems.jei.thermal.accessors.FluidInteractiveAccessor;
import io.bluebeaker.mteenoughitems.jei.utils.BlockTooltipCallbacks;
import io.bluebeaker.mteenoughitems.utils.Area2i;
import io.bluebeaker.mteenoughitems.utils.BlockDropChecker;
import io.bluebeaker.mteenoughitems.utils.ModChecker;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class FluidConversionCategory
extends GenericRecipeCategory<Wrapper> {
    public static final String UID = "mteenoughitems.thermal.fluid_conversion";
    protected final IDrawableStatic bgArrow;
    public static final Rectangle SIZE = new Rectangle(0, 0, 116, 32);
    public static final Area2i SLOT_INPUT = new Area2i(32, FluidConversionCategory.SIZE.height / 2 - 9, 18, 18);
    public static final Area2i SLOT_OUTPUT = new Area2i(FluidConversionCategory.SIZE.width - 26, FluidConversionCategory.SIZE.height / 2 - 9, 18, 18);

    public FluidConversionCategory(IGuiHelper guiHelper) {
        super(guiHelper, FluidConversionCategory.SIZE.width, FluidConversionCategory.SIZE.height);
        this.bgArrow = guiHelper.createDrawable(Constants.GUI_0, 0, 0, 24, 17);
        this.icon = guiHelper.createDrawableIngredient((Object)FluidUtil.getFilledBucket((FluidStack)new FluidStack(TFFluids.fluidMana, 1000)));
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, Wrapper wrapper, IIngredients iIngredients) {
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        int slotY = this.GUI_HEIGHT / 2 - 9;
        this.addFluidSlot(fluidStacks, 0, 8, slotY);
        fluidStacks.set(0, new FluidStack(wrapper.fluid, 1000));
        if (wrapper.inputFluid != null) {
            this.addFluidSlot(fluidStacks, 1, FluidConversionCategory.SLOT_INPUT.x1, FluidConversionCategory.SLOT_INPUT.y1);
            fluidStacks.set(1, new FluidStack(wrapper.inputFluid, 1000));
        } else {
            this.addItemSlot(itemStacks, 1, FluidConversionCategory.SLOT_INPUT.x1, FluidConversionCategory.SLOT_INPUT.y1);
            itemStacks.set(1, wrapper.inputItem);
        }
        if (wrapper.outputFluid != null) {
            this.addFluidSlot(fluidStacks, 2, FluidConversionCategory.SLOT_OUTPUT.x1, FluidConversionCategory.SLOT_OUTPUT.y1);
            fluidStacks.set(2, new FluidStack(wrapper.outputFluid, 1000));
        } else {
            this.addItemSlot(itemStacks, 2, FluidConversionCategory.SLOT_OUTPUT.x1, FluidConversionCategory.SLOT_OUTPUT.y1);
            itemStacks.set(2, wrapper.outputItem);
        }
        BlockTooltipCallbacks callbacks = new BlockTooltipCallbacks().add(1, wrapper.inputState).add(2, wrapper.outputState);
        itemStacks.addTooltipCallback(callbacks.getItemCallback());
        fluidStacks.addTooltipCallback(callbacks.getFluidCallback());
    }

    public void drawExtras(Minecraft minecraft) {
        this.bgArrow.draw(minecraft, 54, 8);
    }

    @Override
    public String getTranslationKey() {
        return "category.mteenoughitems.thermal.fluid_conversion.name";
    }

    public String getUid() {
        return UID;
    }

    public String getModName() {
        return ModChecker.ThermalFoundation.name;
    }

    public static List<Wrapper> getRecipes(IJeiHelpers jeiHelpers) {
        ArrayList<Wrapper> recipes = new ArrayList<Wrapper>();
        recipes.addAll(FluidConversionCategory.getRecipesForBlock((BlockFluidInteractive)TFFluids.blockFluidCryotheum));
        recipes.addAll(FluidConversionCategory.getRecipesForBlock((BlockFluidInteractive)TFFluids.blockFluidPetrotheum));
        recipes.addAll(FluidConversionCategory.getRecipesForBlock((BlockFluidInteractive)TFFluids.blockFluidPyrotheum));
        recipes.addAll(FluidConversionCategory.getRecipesForBlock((BlockFluidInteractive)TFFluids.blockFluidMana));
        return recipes;
    }

    protected static List<Wrapper> getRecipesForBlock(BlockFluidInteractive fluidBlock) {
        ArrayList<Wrapper> recipes = new ArrayList<Wrapper>();
        HashMap<IBlockState, IBlockState> collisionMap = FluidInteractiveAccessor.collisionMap.get(fluidBlock);
        HashMap<Block, IBlockState> anyStateMap = FluidInteractiveAccessor.anyState.get(fluidBlock);
        if (collisionMap == null || anyStateMap == null) {
            return recipes;
        }
        HashSet<Block> blocks = new HashSet<Block>(anyStateMap.keySet());
        collisionMap.keySet().stream().map(IBlockState::func_177230_c).forEach(blocks::add);
        for (Block block1 : blocks) {
            if (FluidRegistry.lookupFluidForBlock((Block)block1) != null) {
                FluidConversionCategory.addWrapperForFluid(recipes, fluidBlock, block1.func_176203_a(0));
                FluidConversionCategory.addWrapperForFluid(recipes, fluidBlock, block1.func_176203_a(1));
                continue;
            }
            Item item = ItemBlock.func_150898_a((Block)block1);
            if (item == Items.field_190931_a) continue;
            NonNullList items = NonNullList.func_191196_a();
            block1.func_149666_a(CreativeTabs.field_78030_b, items);
            if (items.isEmpty()) {
                items.add((Object)new ItemStack(block1));
            }
            for (ItemStack inputItem : items) {
                IBlockState input = block1.func_176203_a(inputItem.func_77973_b().func_77647_b(inputItem.func_77960_j()));
                FluidConversionCategory.addWrapperForFluid(recipes, fluidBlock, input, inputItem, null);
            }
        }
        return recipes;
    }

    protected static void addWrapperForFluid(List<Wrapper> wrappers, BlockFluidInteractive fluid, IBlockState input) {
        FluidConversionCategory.addWrapperForFluid(wrappers, fluid, input, null, null);
    }

    protected static void addWrapperForFluid(List<Wrapper> wrappers, BlockFluidInteractive fluid, IBlockState input, @Nullable ItemStack inItem, @Nullable ItemStack outItem) {
        IBlockState output = fluid.getInteraction(input);
        if (output == null) {
            return;
        }
        wrappers.add(new Wrapper(fluid.getFluid(), input, output, inItem, outItem));
    }

    public static class Wrapper
    implements IRecipeWrapper {
        public final Fluid fluid;
        public final ItemStack inputItem;
        public final ItemStack outputItem;
        public final Fluid inputFluid;
        public final Fluid outputFluid;
        public final IBlockState inputState;
        public final IBlockState outputState;

        public Wrapper(Fluid fluid, IBlockState input, IBlockState output, @Nullable ItemStack inItem, @Nullable ItemStack outItem) {
            this.fluid = fluid;
            this.inputState = input;
            this.outputState = output;
            Block inputBlock = input.func_177230_c();
            Block outputBlock = output.func_177230_c();
            this.inputFluid = FluidRegistry.lookupFluidForBlock((Block)inputBlock);
            this.outputFluid = FluidRegistry.lookupFluidForBlock((Block)outputBlock);
            this.inputItem = inItem != null ? inItem : BlockDropChecker.getDrop(input);
            this.outputItem = outItem != null ? outItem : BlockDropChecker.getDrop(output);
        }

        public void getIngredients(IIngredients iIngredients) {
            ArrayList<FluidStack> inputFluids = new ArrayList<FluidStack>();
            inputFluids.add(new FluidStack(this.fluid, 1000));
            if (this.inputFluid != null) {
                inputFluids.add(new FluidStack(this.inputFluid, 1000));
            } else {
                iIngredients.setInput(VanillaTypes.ITEM, (Object)this.inputItem);
            }
            iIngredients.setInputs(VanillaTypes.FLUID, inputFluids);
            if (this.outputFluid != null) {
                iIngredients.setOutput(VanillaTypes.FLUID, (Object)new FluidStack(this.outputFluid, 1000));
            } else {
                iIngredients.setOutput(VanillaTypes.ITEM, (Object)this.outputItem);
            }
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            int xPos = recipeWidth / 2;
            int yPos = recipeHeight / 2 - minecraft.field_71466_p.field_78288_b;
        }

        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            if (this.outputFluid != null || !this.outputItem.func_190926_b()) {
                return Collections.emptyList();
            }
            if (SLOT_OUTPUT.isInBounds(mouseX, mouseY)) {
                ArrayList<String> tip = new ArrayList<String>();
                tip.add(this.outputState.func_177230_c().func_149732_F());
                tip.add(this.outputState.toString());
                return tip;
            }
            return Collections.emptyList();
        }
    }
}

