/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mteenoughitems.jei.thermal;

import cofh.core.util.BlockWrapper;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.util.managers.device.TapperManager;
import com.google.common.collect.ImmutableList;
import io.bluebeaker.mteenoughitems.Constants;
import io.bluebeaker.mteenoughitems.jei.generic.GenericRecipeCategory;
import io.bluebeaker.mteenoughitems.jei.thermal.accessors.TapperAccessor;
import io.bluebeaker.mteenoughitems.jei.utils.BlockTooltipCallbacks;
import io.bluebeaker.mteenoughitems.utils.BlockDropChecker;
import io.bluebeaker.mteenoughitems.utils.ModChecker;
import io.bluebeaker.mteenoughitems.utils.thermal.ThermalUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class TreeFluidCategory
extends GenericRecipeCategory<Wrapper> {
    public static final String UID = "mteenoughitems.thermal.tree_extractor";
    protected final IDrawableStatic bgArrow;

    public TreeFluidCategory(IGuiHelper guiHelper) {
        super(guiHelper, 116, 48);
        this.bgArrow = guiHelper.createDrawable(Constants.GUI_0, 0, 0, 24, 17);
        this.icon = guiHelper.createDrawableIngredient((Object)BlockDevice.deviceTapper);
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, Wrapper wrapper, IIngredients iIngredients) {
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        int slotY = this.GUI_HEIGHT / 2;
        this.addItemSlot(itemStacks, 0, 16, slotY);
        itemStacks.set(0, wrapper.inputLog);
        this.addItemSlot(itemStacks, 1, 16, slotY - 18);
        itemStacks.set(1, wrapper.inputLeaves);
        this.addFluidSlot(fluidStacks, 2, this.GUI_WIDTH - 34, slotY);
        fluidStacks.set(2, new FluidStack(wrapper.outputFluid, 1000));
        BlockTooltipCallbacks callbacks = new BlockTooltipCallbacks().add(0, wrapper.logBlock);
        for (IBlockState leavesBlock : wrapper.leavesBlocks) {
            callbacks.add(1, leavesBlock);
        }
        itemStacks.addTooltipCallback(callbacks.getItemCallback());
        fluidStacks.addTooltipCallback(callbacks.getFluidCallback());
    }

    public void drawExtras(Minecraft minecraft) {
        this.bgArrow.draw(minecraft, 46, this.GUI_HEIGHT / 2);
    }

    @Override
    public String getTranslationKey() {
        return "category.mteenoughitems.thermal.tree_extractor.name";
    }

    @Override
    public String getTitle() {
        return BlockDevice.deviceTapper.func_82833_r();
    }

    public String getUid() {
        return UID;
    }

    public String getModName() {
        return ModChecker.ThermalExpansion.name;
    }

    public static List<Wrapper> getRecipes(IJeiHelpers jeiHelpers) {
        ArrayList<Wrapper> recipes = new ArrayList<Wrapper>();
        Map<BlockWrapper, FluidStack> blockWrapperFluidStackMap = TapperAccessor.blockMap.get(null);
        if (blockWrapperFluidStackMap != null) {
            for (Map.Entry<BlockWrapper, FluidStack> entry : blockWrapperFluidStackMap.entrySet()) {
                BlockWrapper key = entry.getKey();
                Set leaves = TapperManager.getLeaf((IBlockState)key.block.func_176203_a(key.metadata));
                FluidStack output = entry.getValue();
                recipes.add(new Wrapper(key, leaves, output));
            }
        }
        return recipes;
    }

    public static class Wrapper
    implements IRecipeWrapper {
        public final IBlockState logBlock;
        public final List<IBlockState> leavesBlocks = new ArrayList<IBlockState>();
        public final ItemStack inputLog;
        public final List<ItemStack> inputLeaves = new ArrayList<ItemStack>();
        public final FluidStack outputFluid;

        public Wrapper(BlockWrapper log, Set<BlockWrapper> leaves, FluidStack output) {
            this.logBlock = ThermalUtils.getBlockstateFromWrapper(log);
            leaves.forEach(b -> {
                IBlockState state = ThermalUtils.getBlockstateFromWrapper(b);
                this.leavesBlocks.add(state);
                this.inputLeaves.add(BlockDropChecker.getDrop(state));
            });
            this.inputLog = BlockDropChecker.getDrop(this.logBlock);
            this.outputFluid = output;
        }

        public void getIngredients(IIngredients iIngredients) {
            iIngredients.setInputLists(VanillaTypes.ITEM, (List)ImmutableList.of(Collections.singletonList(this.inputLog), this.inputLeaves));
            iIngredients.setOutput(VanillaTypes.FLUID, (Object)this.outputFluid);
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            int xPos = recipeWidth / 2;
            int yPos = recipeHeight / 2 - minecraft.field_71466_p.field_78288_b;
        }
    }
}

