/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mteenoughitems.jei.thermal;

import cofh.core.inventory.ComparableItemStack;
import cofh.thermalfoundation.init.TFItems;
import cofh.thermalfoundation.item.ItemFertilizer;
import gnu.trove.map.hash.TObjectIntHashMap;
import io.bluebeaker.mteenoughitems.jei.generic.FuelRecipeWrapper;
import io.bluebeaker.mteenoughitems.jei.generic.GenericRecipeCategory;
import io.bluebeaker.mteenoughitems.jei.thermal.accessors.TapperAccessor;
import io.bluebeaker.mteenoughitems.utils.ModChecker;
import io.bluebeaker.mteenoughitems.utils.RenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class TreeFluidFuelCategory
extends GenericRecipeCategory<Wrapper> {
    public static final String UID = "mteenoughitems.thermal.tree_extractor_fuel";
    public static final ResourceLocation GUI_PATH = new ResourceLocation("cofh", "textures/gui/elements/scale_flame_green.png");
    protected final IDrawableStatic bgHeatBar;
    protected final IDrawableAnimated heatBar;

    public TreeFluidFuelCategory(IGuiHelper guiHelper) {
        super(guiHelper, 116, 32);
        ItemFertilizer item = TFItems.itemFertilizer;
        this.icon = item == null ? null : guiHelper.createDrawableIngredient((Object)new ItemStack((Item)item, 1, 2));
        this.bgHeatBar = guiHelper.createDrawable(GUI_PATH, 0, 0, 16, 16);
        this.heatBar = guiHelper.drawableBuilder(GUI_PATH, 16, 0, 16, 16).buildAnimated(200, IDrawableAnimated.StartDirection.TOP, true);
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, Wrapper wrapper, IIngredients iIngredients) {
        IGuiItemStackGroup guiItemStackGroup = recipeLayout.getItemStacks();
        this.addItemSlot(guiItemStackGroup, 0, 8, this.GUI_HEIGHT / 2 - 9);
        guiItemStackGroup.set(iIngredients);
    }

    public void drawExtras(Minecraft minecraft) {
        this.bgHeatBar.draw(minecraft, 10, this.GUI_HEIGHT / 2 - 18);
        this.heatBar.draw(minecraft, 10, this.GUI_HEIGHT / 2 - 18);
    }

    @Override
    public String getTranslationKey() {
        return "category.mteenoughitems.thermal.tree_extractor_fuel.name";
    }

    public String getUid() {
        return UID;
    }

    public String getModName() {
        return ModChecker.ThermalExpansion.name;
    }

    public static List<Wrapper> getRecipes(IJeiHelpers jeiHelpers) {
        ArrayList<Wrapper> recipes = new ArrayList<Wrapper>();
        TObjectIntHashMap<ComparableItemStack> map = TapperAccessor.fertilizerMap.get(null);
        if (map != null) {
            for (ComparableItemStack stack : map.keySet()) {
                recipes.add(new Wrapper(new ItemStack(stack.item, 1, stack.metadata), map.get((Object)stack)));
            }
        }
        return recipes;
    }

    public static class Wrapper
    extends FuelRecipeWrapper {
        public Wrapper(ItemStack stack, int multiplier) {
            super(stack, multiplier, 0);
        }

        @Override
        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            int xPos = recipeWidth / 2;
            int yPos = recipeHeight / 2 - minecraft.field_71466_p.field_78288_b;
            RenderUtils.drawTextAlignedMiddle(String.format("%dx", this.power), xPos, yPos, Color.gray.getRGB());
        }
    }
}

