/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mteenoughitems.jei.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mezz.jei.api.gui.ITooltipCallback;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class BlockTooltipCallbacks {
    Map<Integer, Set<IBlockState>> blockStates = new HashMap<Integer, Set<IBlockState>>();

    public BlockTooltipCallbacks add(int i, IBlockState state) {
        if (!this.blockStates.containsKey(i)) {
            this.blockStates.put(i, new HashSet());
        }
        this.blockStates.get(i).add(state);
        return this;
    }

    public void onTooltip(int i, List<String> list) {
        Set<IBlockState> states = this.blockStates.get(i);
        if (states != null) {
            states.forEach(b -> BlockTooltipCallbacks.addBlockStrToList(list, b));
        }
    }

    public static void addBlockStrToList(List<String> list, IBlockState b) {
        list.add(b.toString());
    }

    public ITooltipCallback<ItemStack> getItemCallback() {
        return new ITooltipCallback<ItemStack>(){

            public void onTooltip(int i, boolean b, ItemStack stack, List<String> list) {
                BlockTooltipCallbacks.this.onTooltip(i, list);
            }
        };
    }

    public ITooltipCallback<FluidStack> getFluidCallback() {
        return new ITooltipCallback<FluidStack>(){

            public void onTooltip(int i, boolean b, FluidStack fluidStack, List<String> list) {
                BlockTooltipCallbacks.this.onTooltip(i, list);
            }
        };
    }
}

