/*
 * Decompiled with CFR 0.152.
 */
package io.bluebeaker.mteenoughitems.utils;

import com.mojang.authlib.GameProfile;
import io.bluebeaker.mteenoughitems.MTEEnoughItems;
import io.bluebeaker.mteenoughitems.utils.player.CheckerFakePlayer;
import io.bluebeaker.mteenoughitems.utils.world.DummyWorld;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class BlockDropChecker {
    private static final DummyWorld world = new DummyWorld();
    private static final CheckerFakePlayer fakePlayer = new CheckerFakePlayer(world, new GameProfile(UUID.randomUUID(), "MTEEnoughItems_FakePlayer"));
    private static final BlockPos pos = new BlockPos(0, 63, 0);
    private static final Vec3d rayStart = new Vec3d(-1.0, 62.0, -1.0);
    private static final Vec3d rayEnd = new Vec3d(1.0, 64.0, 1.0);

    public static ItemStack getDrop(IBlockState state) {
        try {
            world.func_180501_a(pos, state, 20);
            return state.func_177230_c().getPickBlock(state, state.func_185910_a((World)world, pos, rayStart, rayEnd), (World)world, pos, (EntityPlayer)fakePlayer);
        }
        catch (Throwable e) {
            MTEEnoughItems.getLogger().error("Error getting item for blockstate {}:", (Object)state, (Object)e);
            return ItemStack.field_190927_a;
        }
    }

    public static Map<ItemStack, Set<IBlockState>> getGroupedDrops(Collection<IBlockState> blockStates) {
        HashMap<String, ItemStack> addedItems = new HashMap<String, ItemStack>();
        HashMap<ItemStack, Set<IBlockState>> blocksMap = new HashMap<ItemStack, Set<IBlockState>>();
        for (IBlockState blockState : blockStates) {
            ItemStack drop = BlockDropChecker.getDrop(blockState);
            String item = drop.serializeNBT().toString();
            if (!addedItems.containsKey(item)) {
                addedItems.put(item, drop);
            } else {
                drop = (ItemStack)addedItems.get(item);
            }
            blocksMap.computeIfAbsent(drop, i -> new HashSet());
            ((Set)blocksMap.get(drop)).add(blockState);
        }
        return blocksMap;
    }
}

