/*
 * Decompiled with CFR 0.152.
 */
package net.hypestyle.autoclickermod121;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="autoclickermod121", value={Dist.CLIENT})
public class KeyHandler {
    private static boolean isActive = false;
    private static MouseButton selectedButton = MouseButton.LEFT;
    public static final KeyMapping TOGGLE_KEY = new KeyMapping("key.autoclick.toggle", InputConstants.Type.KEYSYM, 295, "key.categories.misc");

    public static boolean isActive() {
        return isActive;
    }

    public static void register(IEventBus modEventBus) {
        modEventBus.addListener(KeyHandler::registerKeys);
    }

    @SubscribeEvent
    public static void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(TOGGLE_KEY);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.gameMode == null) {
            return;
        }
        if (TOGGLE_KEY.consumeClick()) {
            isActive = !isActive;
            mc.player.displayClientMessage((Component)Component.literal((String)("AutoClicker " + (isActive ? "Enabled" : "Disabled"))), true);
        }
        if (!isActive) {
            if (mc.options.keyAttack.isDown()) {
                mc.options.keyAttack.setDown(false);
            }
            if (mc.options.keyUse.isDown()) {
                mc.options.keyUse.setDown(false);
            }
            return;
        }
        if (selectedButton == MouseButton.LEFT) {
            if (!mc.options.keyAttack.isDown()) {
                mc.options.keyAttack.setDown(true);
            }
            if (mc.options.keyUse.isDown()) {
                mc.options.keyUse.setDown(false);
            }
        } else if (selectedButton == MouseButton.RIGHT) {
            if (!mc.options.keyUse.isDown()) {
                mc.options.keyUse.setDown(true);
            }
            if (mc.options.keyAttack.isDown()) {
                mc.options.keyAttack.setDown(false);
            }
        }
    }

    public static void setSelectedButton(MouseButton button) {
        selectedButton = button;
    }

    public static enum MouseButton {
        LEFT,
        RIGHT;

    }
}

