/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera;

import com.xtracr.realcamera.KeyMappings;
import com.xtracr.realcamera.api.BindResult;
import com.xtracr.realcamera.api.RealCameraAPI;
import com.xtracr.realcamera.compat.DisableHelper;
import com.xtracr.realcamera.config.BindTarget;
import com.xtracr.realcamera.config.ConfigFile;
import com.xtracr.realcamera.util.BuiltIterableBuffer;
import com.xtracr.realcamera.util.LocUtil;
import com.xtracr.realcamera.util.MathUtil;
import com.xtracr.realcamera.util.MultiVertexCatcher;
import com.xtracr.realcamera.util.SmoothUtil;
import com.xtracr.realcamera.util.VertexData;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import net.minecraft.class_898;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3fc;

public class RealCameraCore {
    private static BindResult lastResult = BindResult.EMPTY;
    private static BindResult newResult = BindResult.EMPTY;
    private static class_243 cameraPos = class_243.field_1353;
    private static class_243 eulerAngle = class_243.field_1353;
    private static boolean active = false;
    private static boolean rendering = false;
    private static int failureFrames = 0;

    public static boolean isActive() {
        return active;
    }

    public static boolean isRendering() {
        return RealCameraCore.isActive() && rendering;
    }

    public static BindTarget currentTarget() {
        return RealCameraCore.lastResult.target;
    }

    public static void initialize(class_310 client) {
        class_1297 entity = client.method_1560();
        active = ConfigFile.config().enabled() && client.field_1690.method_31044().method_31034() && entity != null && !DisableHelper.MAIN_FEATURE.disabled(entity);
        rendering = ConfigFile.config().renderModel() && !DisableHelper.RENDER_MODEL.disabled(entity);
    }

    public static void reset() {
        cameraPos = eulerAngle = class_243.field_1353;
        failureFrames = 0;
    }

    public static float getPitch(float f) {
        if (RealCameraCore.currentTarget().bindConfig().bindRotation()) {
            return (float)eulerAngle.method_10216();
        }
        return f;
    }

    public static float getYaw(float f) {
        if (RealCameraCore.currentTarget().bindConfig().bindRotation()) {
            return (float)(-eulerAngle.method_10214());
        }
        return f;
    }

    public static float getRoll(float f) {
        if (ConfigFile.config().isClassic()) {
            return f + ConfigFile.config().getClassicRoll();
        }
        if (RealCameraCore.currentTarget().bindConfig().bindRotation()) {
            return (float)eulerAngle.method_10215();
        }
        return f;
    }

    public static class_243 getRawPos(class_243 cameraPos, class_243 entityPos) {
        class_243 rawPos = SmoothUtil.smoothPosition(lastResult.getPosition()).method_1019(entityPos);
        BindTarget.BindConfig bindConfig = RealCameraCore.currentTarget().bindConfig();
        return new class_243(bindConfig.bindX() ? rawPos.method_10216() : cameraPos.method_10216(), bindConfig.bindY() ? rawPos.method_10214() : cameraPos.method_10214(), bindConfig.bindZ() ? rawPos.method_10215() : cameraPos.method_10215());
    }

    public static class_243 getCameraPos(class_243 vec) {
        BindTarget.BindConfig bindConfig = RealCameraCore.currentTarget().bindConfig();
        return new class_243(bindConfig.bindX() ? cameraPos.method_10216() : vec.method_10216(), bindConfig.bindY() ? cameraPos.method_10214() : vec.method_10214(), bindConfig.bindZ() ? cameraPos.method_10215() : vec.method_10215());
    }

    public static void setCameraPos(class_243 vec) {
        cameraPos = vec;
    }

    public static void computeCamera(class_310 client, float deltaTick) {
        class_1297 entity = client.method_1560();
        boolean invisible = entity.method_5767();
        entity.method_5648(false);
        newResult = RealCameraAPI.computeBindResult(client, deltaTick);
        if (!newResult.available()) {
            class_898 dispatcher = client.method_1561();
            MultiVertexCatcher catcher = MultiVertexCatcher.defaultImpl();
            dispatcher.method_62424(entity, 0.0, 0.0, 0.0, deltaTick, new class_4587(), (class_4597)catcher, dispatcher.method_23839(entity, deltaTick));
            catcher.endCatching(RealCameraCore::computeBindResult);
        }
        entity.method_5648(invisible);
        if (newResult.available()) {
            failureFrames = 0;
            lastResult = newResult.computeCamera();
        } else {
            class_746 player = client.field_1724;
            int retentionFrames = ConfigFile.config().getBindResultRetentionFrames();
            if (!ConfigFile.config().hideBindingFailureMessage() && ++failureFrames == retentionFrames + 1 && player != null) {
                player.method_7353((class_2561)LocUtil.MESSAGE("bindingFailed", LocUtil.MOD_NAME(), LocUtil.MODEL_VIEW_TITLE(), KeyMappings.MODEL_VIEW_SCREEN.method_16007()), false);
            }
            if (!lastResult.available() || failureFrames > retentionFrames) {
                lastResult = BindResult.EMPTY;
                active = false;
                return;
            }
        }
        eulerAngle = MathUtil.getEulerAngleYXZ(SmoothUtil.smoothRotation(lastResult.getRotation())).method_1021(Math.toDegrees(1.0));
    }

    public static void renderCameraEntity(class_310 client, float deltaTick, class_4597 bufferSource, Matrix4f modelView) {
        class_243 targetEulerAngle = MathUtil.getEulerAngleYXZ(lastResult.getRotation());
        Matrix4f invertedCameraPose = new Matrix4f().rotateZ((float)targetEulerAngle.method_10215()).rotateX((float)targetEulerAngle.method_10216()).rotateY((float)(Math.PI - targetEulerAngle.method_10214())).transpose().invert().translate((Vector3fc)class_243.field_1353.method_1020(lastResult.getPosition()).method_46409());
        class_4587 poseStack = new class_4587();
        poseStack.method_34425((Matrix4fc)new Matrix4f((Matrix4fc)invertedCameraPose).mulLocal((Matrix4fc)modelView.invert(new Matrix4f())));
        class_1297 entity = client.method_1560();
        class_898 dispatcher = client.method_1561();
        MultiVertexCatcher catcher = MultiVertexCatcher.defaultImpl();
        dispatcher.method_62424(entity, 0.0, 0.0, 0.0, deltaTick, poseStack, (class_4597)catcher, dispatcher.method_23839(entity, deltaTick));
        float m02 = modelView.m02();
        float m12 = modelView.m12();
        float m22 = modelView.m22();
        float m32 = modelView.m32();
        float depth = RealCameraCore.currentTarget().disablingDepth();
        catcher.endCatching(builtBuffer -> {
            BindTarget.DisableConfig[] disableConfigs;
            for (BindTarget.DisableConfig config2 : disableConfigs = RealCameraCore.currentTarget().filteredDisableConfigs(config -> builtBuffer.textureId().contains(config.textureId()))) {
                if (!config2.disableAll()) continue;
                return;
            }
            class_4588 buffer = bufferSource.getBuffer(builtBuffer.renderType());
            if (!builtBuffer.renderType().method_43332()) {
                for (VertexData vertex : builtBuffer.vertexBuffer()) {
                    vertex.render(buffer);
                }
                return;
            }
            builtBuffer.vertexBuffer().primitiveStream().forEach(primitive -> {
                block0: for (VertexData vertex : primitive) {
                    if (Math.fma(m02, vertex.x(), Math.fma(m12, vertex.y(), Math.fma(m22, vertex.z(), m32))) > -depth) continue;
                    for (BindTarget.DisableConfig config : disableConfigs) {
                        if (config.test(vertex)) continue block0;
                    }
                    for (VertexData vertexData : primitive) {
                        vertexData.render(buffer);
                    }
                    break;
                }
            });
        });
    }

    private static void computeBindResult(BuiltIterableBuffer builtBuffer) {
        if (newResult.available()) {
            return;
        }
        block0: for (BindTarget target : ConfigFile.config().getBindTargetList()) {
            BindResult result = new BindResult(target, false);
            if (!builtBuffer.textureId().contains(result.target.textureId())) continue;
            BindTarget.TargetConfig config = result.target.targetConfig();
            VertexData.UV[] uvs = new VertexData.UV[]{new VertexData.UV(config.posU(), config.posV()), new VertexData.UV(config.forwardU(), config.forwardV()), new VertexData.UV(config.upwardU(), config.upwardV())};
            VertexData[][] primitives = builtBuffer.findPrimitivesInCache(uvs);
            if (builtBuffer.anyNotCached(uvs)) {
                for (int i = 0; i < primitives.length; ++i) {
                    if (primitives[i] == null) continue;
                    uvs[i] = null;
                }
                VertexData[][] newPrimitives = builtBuffer.findPrimitives(uvs);
                for (int i = 0; i < primitives.length; ++i) {
                    if (newPrimitives[i] == null && primitives[i] == null) continue block0;
                    if (newPrimitives[i] == null) continue;
                    primitives[i] = newPrimitives[i];
                }
            }
            if (primitives[0] != null) {
                result.setPosition(VertexData.position(primitives[0], config.posU(), config.posV()));
            }
            if (primitives[1] != null) {
                result.setForward(VertexData.normal(primitives[1]));
            }
            if (primitives[2] != null) {
                result.setUpward(VertexData.normal(primitives[2]));
            }
            if (!result.available()) continue;
            newResult = result;
            return;
        }
    }
}

