/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.api;

import com.xtracr.realcamera.config.BindTarget;
import com.xtracr.realcamera.config.ConfigFile;
import java.util.List;
import net.minecraft.class_243;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BindResult {
    public static final BindResult EMPTY = new BindResult(BindTarget.EMPTY, false);
    public final BindTarget target;
    protected final Matrix3f rotation = new Matrix3f();
    protected final boolean mirrored;
    private class_243 position = class_243.field_1353;
    private class_243 forward = class_243.field_1353;
    private class_243 upward = class_243.field_1353;

    public BindResult(BindTarget target, boolean mirrored) {
        this.target = target;
        this.mirrored = mirrored;
    }

    public static BindResult getOrCreate(String name) {
        List<BindTarget> fixedTargets = ConfigFile.config().getFixedTargetList();
        BindTarget target = fixedTargets.stream().filter(t -> t.name().equals(name)).findFirst().orElseGet(() -> {
            BindTarget blank = BindTarget.blank(name, "");
            fixedTargets.add(blank);
            return blank;
        });
        return new BindResult(target, false);
    }

    public boolean available() {
        return !this.target.isEmpty() && !this.forward.equals((Object)class_243.field_1353) && !this.upward.equals((Object)class_243.field_1353) && Double.isFinite(this.position.method_1027()) && Math.abs(this.rotation.determinant() - 1.0f) < 0.01f;
    }

    public boolean weakAvailable() {
        return !this.target.isEmpty() && (this.forward != class_243.field_1353 || this.upward != class_243.field_1353 || this.position != class_243.field_1353) && Double.isFinite(this.position.method_1027());
    }

    public class_243 getPosition() {
        return this.position;
    }

    public void setPosition(class_243 vec) {
        this.position = vec;
    }

    public class_243 getForward() {
        return this.forward;
    }

    public void setForward(class_243 vec) {
        this.forward = vec.method_1029();
    }

    public class_243 getUpward() {
        return this.upward;
    }

    public void setUpward(class_243 vec) {
        this.upward = vec.method_1029();
    }

    public Matrix3f getRotation() {
        return this.rotation;
    }

    public BindResult computeCamera() {
        if (!this.available()) {
            return this;
        }
        int orientation = this.mirrored ? -1 : 1;
        this.upward = this.forward.method_1036(this.upward.method_1036(this.forward)).method_1029();
        class_243 left = this.upward.method_1036(this.forward).method_1021((double)orientation);
        this.rotation.set((Vector3fc)left.method_46409(), (Vector3fc)this.upward.method_46409(), (Vector3fc)this.forward.method_46409());
        BindTarget.OffsetConfig offsets = this.target.offsets();
        Vector3f offset = new Vector3f(offsets.getZ(), offsets.getY(), offsets.getX()).mul(offsets.getScale()).mul((Matrix3fc)this.rotation);
        this.position = this.position.method_1031((double)offset.x(), (double)offset.y(), (double)offset.z());
        this.rotation.rotateLocal((float)orientation * (float)Math.toRadians(offsets.getYaw()), this.rotation.m10, this.rotation.m11, this.rotation.m12);
        this.rotation.rotateLocal((float)orientation * (float)Math.toRadians(offsets.getPitch()), this.rotation.m00, this.rotation.m01, this.rotation.m02);
        this.rotation.rotateLocal((float)orientation * (float)Math.toRadians(offsets.getRoll()), this.rotation.m20, this.rotation.m21, this.rotation.m22);
        return this;
    }
}

