/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.gui;

import com.google.common.collect.ImmutableSortedMap;
import com.xtracr.realcamera.RealCameraCore;
import com.xtracr.realcamera.compat.CompatibilityHelper;
import com.xtracr.realcamera.config.BindTarget;
import com.xtracr.realcamera.config.ConfigFile;
import com.xtracr.realcamera.config.ConfigScreen;
import com.xtracr.realcamera.gui.CyclingTexturedButton;
import com.xtracr.realcamera.gui.DoubleSlider;
import com.xtracr.realcamera.gui.GUIHelper;
import com.xtracr.realcamera.gui.ModelAnalyser;
import com.xtracr.realcamera.gui.NumberField;
import com.xtracr.realcamera.gui.TexturedButton;
import com.xtracr.realcamera.util.LocUtil;
import com.xtracr.realcamera.util.MathUtil;
import com.xtracr.realcamera.util.VertexData;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedMap;
import java.util.Set;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import net.minecraft.class_10017;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_241;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5676;
import net.minecraft.class_6382;
import net.minecraft.class_7172;
import net.minecraft.class_7842;
import net.minecraft.class_7843;
import net.minecraft.class_7845;
import net.minecraft.class_7847;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import net.minecraft.class_8494;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ModelViewScreen
extends class_437 {
    public final ModelAnalyser analyser = new ModelAnalyser();
    protected int xSize = 450;
    protected int ySize = 206;
    protected int middleWidth = this.xSize - 200;
    protected int widgetWidth = (this.xSize - this.middleWidth) / 4 - 8;
    protected int widgetHeight = 18;
    protected int x;
    protected int y;
    protected int page = 0;
    protected class_3675.class_306 modifierKey = ConfigFile.config().getScreenModifierKey();
    private boolean initialized;
    private int modelScale = 80;
    private int textureScale = 80;
    private int layers = 0;
    private int selectionRadius = 10;
    private double modelX;
    private double modelY;
    private double textureX;
    private double textureY;
    private double clickedX = -1.0;
    private double clickedY = -1.0;
    private float xRot;
    private float yRot;
    private String focusedTextureId;
    private class_8030 modelViewArea;
    @Nullable
    private class_8030 textureViewArea;
    private VertexData[][] focusedPolyhedron = new VertexData[0][];
    private List<BindTarget.DisableConfig> configsInClipBoard = new ArrayList<BindTarget.DisableConfig>();
    @Nullable
    private UVRectangleWidget focusedRectWidget;
    private class_7842 rectWidgetsSizeWidget;
    private class_342 textureIdField;
    private class_342 nameField;
    private class_342 disabledNameField;
    private class_342 disabledIdField;
    private NumberField<Integer> priorityField;
    private NumberField<Integer> focusedRectWidgetNumberField;
    private NumberField<Float> forwardUField;
    private NumberField<Float> forwardVField;
    private NumberField<Float> upwardUField;
    private NumberField<Float> upwardVField;
    private NumberField<Float> posUField;
    private NumberField<Float> posVField;
    private NumberField<Float> uMinField;
    private NumberField<Float> vMinField;
    private NumberField<Float> uMaxField;
    private NumberField<Float> vMaxField;
    private NumberField<Float> offsetXField;
    private NumberField<Float> offsetYField;
    private NumberField<Float> offsetZField;
    private NumberField<Float> offsetPitchField;
    private NumberField<Float> offsetYawField;
    private NumberField<Float> offsetRollField;
    private NumberField<Float> scaleField;
    private NumberField<Float> depthField;
    private final List<BindTarget.DisableConfig> disableConfigs = new ArrayList<BindTarget.DisableConfig>();
    private final List<UVRectangleWidget> rectWidgets = new ArrayList<UVRectangleWidget>();
    private final Map<String, Set<String>> hiddenNameMap = new HashMap<String, Set<String>>();
    private final Map<Integer, String> toggleConfigMap = Map.of(0, "disable", 1, "preview", 2, "configs");
    private final CyclingTexturedButton showTextureButton = new CyclingTexturedButton(48, 16, 0, 2).setOnValueChange(i -> this.initWidgets(this.page));
    private final CyclingTexturedButton pauseButton = new CyclingTexturedButton(0, 16, 0, 2);
    private final CyclingTexturedButton bindXButton = new CyclingTexturedButton(16, 16, 1, 2);
    private final CyclingTexturedButton bindYButton = new CyclingTexturedButton(16, 16, 0, 2);
    private final CyclingTexturedButton bindZButton = new CyclingTexturedButton(16, 16, 1, 2);
    private final CyclingTexturedButton bindRotButton = new CyclingTexturedButton(16, 16, 1, 2);
    private final DoubleSlider entityPitchSlider = this.createSlider("pitch", this.widgetWidth * 2 + 4, -90.0, 90.0);
    private final DoubleSlider entityYawSlider = this.createSlider("yaw", this.widgetWidth * 2 + 4, -60.0, 60.0);
    private final DoubleSlider offsetXSlider = this.createSlider("offsetX", this.widgetWidth * 2 - 18, -1.0, 1.0);
    private final DoubleSlider offsetYSlider = this.createSlider("offsetY", this.widgetWidth * 2 - 18, -1.0, 1.0);
    private final DoubleSlider offsetZSlider = this.createSlider("offsetZ", this.widgetWidth * 2 - 18, -1.0, 1.0);
    private final DoubleSlider offsetPitchSlider = this.createSlider("pitch", this.widgetWidth * 2 - 18, -180.0, 180.0);
    private final DoubleSlider offsetYawSlider = this.createSlider("yaw", this.widgetWidth * 2 - 18, -180.0, 180.0);
    private final DoubleSlider offsetRollSlider = this.createSlider("roll", this.widgetWidth * 2 - 18, -180.0, 180.0);
    private final class_5676<Integer> selectingButton = this.createCyclingButton((SequencedMap<Integer, class_2561>)ImmutableSortedMap.of((Comparable)Integer.valueOf(0), (Object)LocUtil.MODEL_VIEW_WIDGET("forwardVector", new Object[0]).method_27692(class_124.field_1060), (Comparable)Integer.valueOf(1), (Object)LocUtil.MODEL_VIEW_WIDGET("upwardVector", new Object[0]).method_27692(class_124.field_1061), (Comparable)Integer.valueOf(2), (Object)LocUtil.MODEL_VIEW_WIDGET("position", new Object[0]).method_27692(class_124.field_1078)), this.widgetWidth * 2 + 4, (class_2561)LocUtil.MODEL_VIEW_WIDGET("selecting", new Object[0]), (class_7172.class_7277<Integer>)((class_7172.class_7277)i -> this.createTooltip("selecting", this.modifierKey.method_27445(), this.modifierKey.method_27445())));
    private final class_5676<Integer> disableModeButton = this.createCyclingButton((SequencedMap<Integer, class_2561>)ImmutableSortedMap.of((Comparable)Integer.valueOf(0), (Object)LocUtil.MODEL_VIEW_WIDGET("all", new Object[0]).method_27692(class_124.field_1060), (Comparable)Integer.valueOf(1), (Object)LocUtil.MODEL_VIEW_WIDGET("part", new Object[0]).method_27692(class_124.field_1078)), this.widgetWidth * 2 + 4, (class_2561)LocUtil.MODEL_VIEW_WIDGET("disableMode", new Object[0]), (class_7172.class_7277<Integer>)((class_7172.class_7277)i -> this.createTooltip("disableMode", this.modifierKey.method_27445())));
    private final class_5676<Integer> selectionModeButton = this.createCyclingButton((SequencedMap<Integer, class_2561>)ImmutableSortedMap.of((Comparable)Integer.valueOf(0), (Object)LocUtil.MODEL_VIEW_WIDGET("single", new Object[0]), (Comparable)Integer.valueOf(1), (Object)LocUtil.MODEL_VIEW_WIDGET("multiple", new Object[0]), (Comparable)Integer.valueOf(2), (Object)LocUtil.MODEL_VIEW_WIDGET("range", new Object[0]).method_27692(class_124.field_1078)), this.widgetWidth * 2 + 4, (class_2561)LocUtil.MODEL_VIEW_WIDGET("selectionMode", new Object[0]), (class_7172.class_7277<Integer>)((class_7172.class_7277)i -> this.createTooltip("selectionMode", this.modifierKey.method_27445(), this.modifierKey.method_27445())));
    private final class_5676<Integer> toggleSliderButton = this.createCyclingButton((SequencedMap<Integer, class_2561>)ImmutableSortedMap.of((Comparable)Integer.valueOf(0), (Object)LocUtil.MODEL_VIEW_WIDGET("toggleSliderToField", new Object[0]), (Comparable)Integer.valueOf(1), (Object)LocUtil.MODEL_VIEW_WIDGET("toggleFieldToSlider", new Object[0])), this.widgetWidth * 2 + 4, (class_7172.class_7277<Integer>)((class_7172.class_7277)i -> null), (class_5676.class_5678<Integer>)((class_5676.class_5678)(button, i) -> {
        if (i == 1) {
            this.offsetXField.setNumber(Float.valueOf((float)this.offsetXSlider.getValue()));
            this.offsetYField.setNumber(Float.valueOf((float)this.offsetYSlider.getValue()));
            this.offsetZField.setNumber(Float.valueOf((float)this.offsetZSlider.getValue()));
            this.offsetPitchField.setNumber(Float.valueOf((float)this.offsetPitchSlider.getValue()));
            this.offsetYawField.setNumber(Float.valueOf((float)this.offsetYawSlider.getValue()));
            this.offsetRollField.setNumber(Float.valueOf((float)this.offsetRollSlider.getValue()));
        } else {
            this.offsetXSlider.setValue(this.offsetXField.getNumber().floatValue());
            this.offsetYSlider.setValue(this.offsetYField.getNumber().floatValue());
            this.offsetZSlider.setValue(this.offsetZField.getNumber().floatValue());
            this.offsetPitchSlider.setValue(this.offsetPitchField.getNumber().floatValue());
            this.offsetYawSlider.setValue(this.offsetYawField.getNumber().floatValue());
            this.offsetRollSlider.setValue(this.offsetRollField.getNumber().floatValue());
        }
        this.initWidgets(this.page);
    }));
    private final class_5676<Integer> toggleCategoryButton = this.createCyclingButton((SequencedMap<Integer, class_2561>)ImmutableSortedMap.of((Comparable)Integer.valueOf(0), (Object)LocUtil.MODEL_VIEW_WIDGET(this.toggleConfigMap.get(0), new Object[0]), (Comparable)Integer.valueOf(1), (Object)LocUtil.MODEL_VIEW_WIDGET(this.toggleConfigMap.get(1), new Object[0]), (Comparable)Integer.valueOf(2), (Object)LocUtil.MODEL_VIEW_WIDGET(this.toggleConfigMap.get(2), new Object[0])), this.widgetWidth * 2 - 18, (class_7172.class_7277<Integer>)((class_7172.class_7277)i -> this.createTooltip(this.toggleConfigMap.get(i), new Object[0])), (class_5676.class_5678<Integer>)((class_5676.class_5678)(button, i) -> this.initWidgets(0)));

    public ModelViewScreen() {
        super((class_2561)LocUtil.MODEL_VIEW_TITLE());
    }

    protected void method_25426() {
        super.method_25426();
        this.x = (this.field_22789 - this.xSize) / 2;
        this.y = (this.field_22790 - this.ySize) / 2;
        this.modifierKey = ConfigFile.config().getScreenModifierKey();
        this.initWidgets(this.page);
        if (!this.initialized) {
            this.loadBindTarget(RealCameraCore.currentTarget());
        }
        this.initialized = true;
    }

    private void initWidgets(int page) {
        this.page = page;
        if ((Integer)this.toggleCategoryButton.method_32603() == 1 && this.showTextureButton.getValue() == 0) {
            this.modelViewArea = new class_8030(this.x + this.xSize / 2, this.y, this.middleWidth / 2, this.ySize);
            this.textureViewArea = new class_8030(this.x + (this.xSize - this.middleWidth) / 2, this.y, this.middleWidth / 2, this.ySize);
        } else {
            this.modelViewArea = new class_8030(this.x + (this.xSize - this.middleWidth) / 2, this.y, this.middleWidth, this.ySize);
            this.textureViewArea = null;
            if (this.focusedRectWidget != null && this.focusedRectWidget.method_25370()) {
                this.method_25395(null);
            }
            this.focusedRectWidget = null;
        }
        this.method_37067();
        this.initLeftWidgets();
        if (this.textureViewArea != null) {
            this.rectWidgets.forEach(x$0 -> {
                UVRectangleWidget cfr_ignored_0 = (UVRectangleWidget)this.method_37063((class_364)x$0);
            });
        }
        if ((Integer)this.toggleCategoryButton.method_32603() == 1) {
            ((CyclingTexturedButton)this.method_37063((class_364)this.showTextureButton)).method_48229(this.x + (this.xSize - this.middleWidth) / 2 + 4, this.y + 4);
        }
        ((CyclingTexturedButton)this.method_37063((class_364)this.pauseButton)).method_48229(this.x + (this.xSize + this.middleWidth) / 2 - 38, this.y + 4);
        this.method_37063((class_364)new TexturedButton(this.x + (this.xSize + this.middleWidth) / 2 - 20, this.y + 4, 16, 16, 0, 0, button -> {
            this.textureScale = 80;
            this.modelScale = 80;
            this.entityYawSlider.setValue(0.0);
            this.entityPitchSlider.setValue(0.0);
            this.textureY = 0.0;
            this.textureX = 0.0;
            this.modelY = 0.0;
            this.modelX = 0.0;
            this.yRot = 0.0f;
            this.xRot = 0.0f;
            this.layers = 0;
        }));
        this.initRightWidgets();
    }

    private void initLeftWidgets() {
        this.rectWidgetsSizeWidget = new class_7842(this.x + 4 + this.widgetWidth + 5, this.y + 4 + (this.widgetHeight + 2) * 3, this.widgetWidth - 22, this.widgetHeight, (class_2561)LocUtil.literal(String.valueOf(this.rectWidgets.size())), this.field_22793);
        this.forwardUField = this.createFloatField(this.widgetWidth, 0.0f, this.forwardUField);
        this.forwardVField = this.createFloatField(this.widgetWidth, 0.0f, this.forwardVField);
        this.upwardUField = this.createFloatField(this.widgetWidth, 0.0f, this.upwardUField);
        this.upwardVField = this.createFloatField(this.widgetWidth, 0.0f, this.upwardVField);
        this.posUField = this.createFloatField(this.widgetWidth, 0.0f, this.posUField);
        this.posVField = this.createFloatField(this.widgetWidth, 0.0f, this.posVField);
        this.textureIdField = this.createTextField(this.widgetWidth * 2 + 4, 1024, this.textureIdField);
        this.disabledIdField = this.createTextField(this.widgetWidth * 2 + 4, 1024, this.disabledIdField);
        this.focusedRectWidgetNumberField = NumberField.ofInt(this.field_22793, this.widgetWidth - 2, this.widgetHeight - 2, 0, this.focusedRectWidgetNumberField).setMin(0).setMax(this.rectWidgets.size());
        this.uMinField = this.createFloatField(this.widgetWidth * 2 - 24, 0.0f, this.uMinField).setMin(Float.valueOf(-1.0f)).setMax(Float.valueOf(2.0f));
        this.uMaxField = this.createFloatField(this.widgetWidth * 2 - 24, 0.0f, this.uMaxField).setMin(Float.valueOf(-1.0f)).setMax(Float.valueOf(2.0f));
        this.vMinField = this.createFloatField(this.widgetWidth * 2 - 24, 0.0f, this.vMinField).setMin(Float.valueOf(-1.0f)).setMax(Float.valueOf(2.0f));
        this.vMaxField = this.createFloatField(this.widgetWidth * 2 - 24, 0.0f, this.vMaxField).setMin(Float.valueOf(-1.0f)).setMax(Float.valueOf(2.0f));
        this.offsetXField = this.createFloatField(this.widgetWidth * 2 - 20, 0.0f, this.offsetXField).setMin(Float.valueOf(-1.0f)).setMax(Float.valueOf(1.0f));
        this.offsetYField = this.createFloatField(this.widgetWidth * 2 - 20, 0.0f, this.offsetYField).setMin(Float.valueOf(-1.0f)).setMax(Float.valueOf(1.0f));
        this.offsetZField = this.createFloatField(this.widgetWidth * 2 - 20, 0.0f, this.offsetZField).setMin(Float.valueOf(-1.0f)).setMax(Float.valueOf(1.0f));
        this.offsetPitchField = this.createFloatField(this.widgetWidth * 2 - 20, 0.0f, this.offsetPitchField).setMin(Float.valueOf(-180.0f)).setMax(Float.valueOf(180.0f));
        this.offsetYawField = this.createFloatField(this.widgetWidth * 2 - 20, 0.0f, this.offsetYawField).setMin(Float.valueOf(-180.0f)).setMax(Float.valueOf(180.0f));
        this.offsetRollField = this.createFloatField(this.widgetWidth * 2 - 20, 0.0f, this.offsetRollField).setMin(Float.valueOf(-180.0f)).setMax(Float.valueOf(180.0f));
        this.scaleField = this.createFloatField(this.widgetWidth, 1.0f, this.scaleField).setMax(Float.valueOf(64.0f));
        this.depthField = this.createFloatField(this.widgetWidth, 0.2f, this.depthField).setMax(Float.valueOf(16.0f));
        class_7845 grid = new class_7845();
        grid.method_46458().method_46466(4, 2, 0, 0);
        class_7847 smallSettings = grid.method_46457().method_46466(5, 3, 1, 1);
        class_7845.class_7939 rows = grid.method_47610(2);
        if ((Integer)this.toggleCategoryButton.method_32603() == 0) {
            ((class_4185)rows.method_47612((class_8021)this.createButton((class_2561)LocUtil.MODEL_VIEW_WIDGET("import", new Object[0]), this.widgetWidth, this::importBindTarget))).method_47400(this.createTooltip("import", new Object[0]));
            ((class_4185)rows.method_47612((class_8021)this.createButton((class_2561)LocUtil.MODEL_VIEW_WIDGET("export", new Object[0]), this.widgetWidth, this::exportBindTarget))).method_47400(this.createTooltip("export", new Object[0]));
            rows.method_47613((class_8021)this.entityPitchSlider, 2);
            rows.method_47613((class_8021)this.entityYawSlider, 2);
            rows.method_47613(this.selectingButton, 2);
            rows.method_47615(this.forwardUField, smallSettings);
            rows.method_47615(this.forwardVField, smallSettings);
            rows.method_47615(this.upwardUField, smallSettings);
            rows.method_47615(this.upwardVField, smallSettings);
            rows.method_47615(this.posUField, smallSettings);
            rows.method_47615(this.posVField, smallSettings);
            ((class_342)rows.method_47614((class_8021)this.textureIdField, 2, smallSettings)).method_47400(this.createTooltip("textureId", new Object[0]));
        } else if ((Integer)this.toggleCategoryButton.method_32603() == 1) {
            class_7847 offsetXSettings = grid.method_46457().method_46466(-13, 3, 1, 1);
            rows.method_47613(this.disableModeButton, 2);
            ((class_342)rows.method_47614((class_8021)this.disabledIdField, 2, smallSettings)).method_47400(this.createTooltip("textureId", new Object[0]));
            rows.method_47613(this.selectionModeButton, 2);
            ((NumberField)rows.method_47615(this.focusedRectWidgetNumberField, smallSettings)).setOnValueChange(index -> {
                if (index == 0) {
                    this.focusedRectWidget = null;
                } else if (index > 0 && index <= this.rectWidgets.size()) {
                    this.focusedRectWidget = this.rectWidgets.get(index - 1);
                    this.uMinField.setNumber(Float.valueOf(this.focusedRectWidget.uMin));
                    this.vMinField.setNumber(Float.valueOf(this.focusedRectWidget.vMin));
                    this.uMaxField.setNumber(Float.valueOf(this.focusedRectWidget.uMax));
                    this.vMaxField.setNumber(Float.valueOf(this.focusedRectWidget.vMax));
                }
            }).method_47400(this.createTooltip("focusedRectangleNumber", new Object[0]));
            this.method_37063((class_364)new class_7842(this.x + 4 + this.widgetWidth + 3, this.y + 4 + (this.widgetHeight + 2) * 3, 6, this.widgetHeight, (class_2561)LocUtil.literal("/"), this.field_22793));
            this.method_37063((class_364)this.rectWidgetsSizeWidget);
            ((TexturedButton)rows.method_47615((class_8021)new TexturedButton(48, 0, button -> this.deleteFocusedRectWidget()), grid.method_46457().method_46466(5 + this.widgetWidth - 18, 3, 1, 1))).method_47400(this.createTooltip("deleteSelectedRectangle", new Object[0]));
            rows.method_47612((class_8021)new class_7842(26, this.widgetHeight, (class_2561)LocUtil.literal("uMin:"), this.field_22793));
            ((NumberField)rows.method_47615(this.uMinField, offsetXSettings)).setOnValueChange(f -> {
                if (this.focusedRectWidget != null) {
                    this.focusedRectWidget.uMin = f.floatValue();
                }
            });
            rows.method_47612((class_8021)new class_7842(26, this.widgetHeight, (class_2561)LocUtil.literal("vMin:"), this.field_22793));
            ((NumberField)rows.method_47615(this.vMinField, offsetXSettings)).setOnValueChange(f -> {
                if (this.focusedRectWidget != null) {
                    this.focusedRectWidget.vMin = f.floatValue();
                }
            });
            rows.method_47612((class_8021)new class_7842(26, this.widgetHeight, (class_2561)LocUtil.literal("uMax:"), this.field_22793));
            ((NumberField)rows.method_47615(this.uMaxField, offsetXSettings)).setOnValueChange(f -> {
                if (this.focusedRectWidget != null) {
                    this.focusedRectWidget.uMax = f.floatValue();
                }
            });
            rows.method_47612((class_8021)new class_7842(26, this.widgetHeight, (class_2561)LocUtil.literal("vMax:"), this.field_22793));
            ((NumberField)rows.method_47615(this.vMaxField, offsetXSettings)).setOnValueChange(f -> {
                if (this.focusedRectWidget != null) {
                    this.focusedRectWidget.vMax = f.floatValue();
                }
            });
        } else {
            boolean useSliderOffset = (Integer)this.toggleSliderButton.method_32603() == 0;
            rows.method_47613(this.toggleSliderButton, 2);
            class_7847 sliderSettings = grid.method_46457().method_46466(-20, 2, 0, 0);
            class_7847 fieldSettings = grid.method_46457().method_46466(-17, 3, 1, 1);
            ((CyclingTexturedButton)rows.method_47615((class_8021)this.bindXButton, smallSettings)).method_47400(this.createTooltip("bindButtons", new Object[0]));
            if (useSliderOffset) {
                rows.method_47615((class_8021)this.offsetXSlider, sliderSettings);
            } else {
                rows.method_47615(this.offsetXField, fieldSettings);
            }
            ((CyclingTexturedButton)rows.method_47615((class_8021)this.bindYButton, smallSettings)).method_47400(this.createTooltip("bindButtons", new Object[0]));
            if (useSliderOffset) {
                rows.method_47615((class_8021)this.offsetYSlider, sliderSettings);
            } else {
                rows.method_47615(this.offsetYField, fieldSettings);
            }
            ((CyclingTexturedButton)rows.method_47615((class_8021)this.bindZButton, smallSettings)).method_47400(this.createTooltip("bindButtons", new Object[0]));
            if (useSliderOffset) {
                rows.method_47615((class_8021)this.offsetZSlider, sliderSettings);
            } else {
                rows.method_47615(this.offsetZField, fieldSettings);
            }
            ((CyclingTexturedButton)rows.method_47615((class_8021)this.bindRotButton, smallSettings)).method_47400(this.createTooltip("bindButtons", new Object[0]));
            if (useSliderOffset) {
                rows.method_47615((class_8021)this.offsetPitchSlider, sliderSettings);
            } else {
                rows.method_47615(this.offsetPitchField, fieldSettings);
            }
            if (useSliderOffset) {
                rows.method_47614((class_8021)this.offsetYawSlider, 2, grid.method_46457().method_46466(26, 2, 0, 0));
            } else {
                rows.method_47614(this.offsetYawField, 2, grid.method_46457().method_46466(29, 3, 1, 1));
            }
            rows.method_47615((class_8021)new TexturedButton(0, 0, button -> {
                this.offsetXField.setNumber(Float.valueOf(0.0f));
                this.offsetYField.setNumber(Float.valueOf(0.0f));
                this.offsetZField.setNumber(Float.valueOf(0.0f));
                this.offsetPitchField.setNumber(Float.valueOf(0.0f));
                this.offsetYawField.setNumber(Float.valueOf(0.0f));
                this.offsetRollField.setNumber(Float.valueOf(0.0f));
                this.offsetXSlider.setValue(0.0);
                this.offsetYSlider.setValue(0.0);
                this.offsetZSlider.setValue(0.0);
                this.offsetPitchSlider.setValue(0.0);
                this.offsetYawSlider.setValue(0.0);
                this.offsetRollSlider.setValue(0.0);
            }), smallSettings);
            if (useSliderOffset) {
                rows.method_47615((class_8021)this.offsetRollSlider, sliderSettings);
            } else {
                rows.method_47615(this.offsetRollField, fieldSettings);
            }
            ((NumberField)rows.method_47615(this.scaleField, smallSettings)).method_47400(this.createTooltip("scale", new Object[0]));
            ((NumberField)rows.method_47615(this.depthField, smallSettings)).method_47400(this.createTooltip("depth", new Object[0]));
        }
        rows.method_47612((class_8021)this.createButton((class_2561)LocUtil.MODEL_VIEW_WIDGET("save", new Object[0]), this.widgetWidth, button -> {
            if (this.nameField.method_1882().isBlank()) {
                button.method_47400(class_7919.method_47407((class_2561)LocUtil.MODEL_VIEW_TOOLTIP("emptyName", new Object[0]).method_27692(class_124.field_1061)));
                return;
            }
            button.method_47400(null);
            BindTarget bindTarget = this.genBindTarget();
            ConfigFile.config().putBindTarget(bindTarget);
            ConfigFile.save();
            this.loadBindTarget(bindTarget);
            this.initWidgets(this.page);
        }));
        this.priorityField = NumberField.ofInt(this.field_22793, this.widgetWidth - 2, this.widgetHeight - 2, 0, this.priorityField);
        ((NumberField)rows.method_47615(this.priorityField, smallSettings)).method_47400(this.createTooltip("priority", new Object[0]));
        this.nameField = this.createTextField(this.widgetWidth * 2 + 4, 20, this.nameField);
        ((class_342)rows.method_47614((class_8021)this.nameField, 2, smallSettings)).method_47400(this.createTooltip("targetName", new Object[0]));
        grid.method_48222();
        class_7843.method_46443((class_8021)grid, (int)this.x, (int)(this.y + 2), (int)(this.x + (this.xSize - this.middleWidth) / 2 - 4), (int)(this.y + this.ySize), (float)0.0f, (float)0.0f);
        grid.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
    }

    private void initRightWidgets() {
        int size;
        int widgetsPerPage;
        this.disabledNameField = this.createTextField(this.widgetWidth * 2 - 18, 20, this.disabledNameField);
        class_7845 grid = new class_7845();
        grid.method_46458().method_46466(4, 2, 0, 0);
        class_7847 smallSettings = grid.method_46457().method_46466(5, 3, 1, 1);
        class_7845.class_7939 rows = grid.method_47610(4);
        rows.method_47613(this.toggleCategoryButton, 3);
        ((TexturedButton)rows.method_47615((class_8021)new TexturedButton(80, 0, button -> {
            if (CompatibilityHelper.isModLoaded("cloth-config")) {
                this.field_22787.method_1507(ConfigScreen.create(this));
            }
        }), smallSettings)).method_47400(this.createTooltip("toConfigScreen", new Object[0]));
        if ((Integer)this.toggleCategoryButton.method_32603() == 1) {
            widgetsPerPage = 6;
            size = this.disableConfigs.size();
            ((class_4185)rows.method_47613((class_8021)this.createButton((class_2561)LocUtil.MODEL_VIEW_WIDGET("copy", new Object[0]), this.widgetWidth, button -> {
                this.configsInClipBoard = List.copyOf(this.disableConfigs);
            }), 2)).method_47400(this.createTooltip("copy", new Object[0]));
            ((class_4185)rows.method_47613((class_8021)this.createButton((class_2561)LocUtil.MODEL_VIEW_WIDGET("paste", new Object[0]), this.widgetWidth, button -> {
                this.configsInClipBoard.stream().filter(config -> this.disableConfigs.stream().noneMatch(c -> c.name().equals(config.name()))).forEach(this.disableConfigs::add);
                this.initWidgets(0);
            }), 2)).method_47400(this.createTooltip("paste", new Object[0]));
            ((class_342)rows.method_47614((class_8021)this.disabledNameField, 3, smallSettings)).method_47400(this.createTooltip("disabledName", new Object[0]));
            ((TexturedButton)rows.method_47615((class_8021)new TexturedButton(64, 0, button -> {
                String name = this.disabledNameField.method_1882();
                String textureId = this.disabledIdField.method_1882();
                if (name.isBlank()) {
                    button.method_47400(class_7919.method_47407((class_2561)LocUtil.MODEL_VIEW_TOOLTIP("emptyName", new Object[0]).method_27692(class_124.field_1061)));
                } else if (textureId.isBlank()) {
                    button.method_47400(class_7919.method_47407((class_2561)LocUtil.MODEL_VIEW_TOOLTIP("emptyTextureId", new Object[0]).method_27692(class_124.field_1061)));
                } else {
                    button.method_47400(this.createTooltip("saveAs", new Object[0]));
                    BindTarget.DisableConfig disableConfig = new BindTarget.DisableConfig(name, textureId, (Integer)this.disableModeButton.method_32603() == 0, (BindTarget.UVRectangle[])this.rectWidgets.stream().map(UVRectangleWidget::toUVRectangle).toArray(BindTarget.UVRectangle[]::new));
                    for (int i = 0; i < this.disableConfigs.size(); ++i) {
                        if (!this.disableConfigs.get(i).name().equals(name)) continue;
                        this.disableConfigs.set(i, disableConfig);
                        this.initWidgets(this.page);
                        return;
                    }
                    this.disableConfigs.add(disableConfig);
                    this.initWidgets(this.page);
                }
            }), smallSettings)).method_47400(this.createTooltip("saveAs", new Object[0]));
            for (int i = this.page * widgetsPerPage; i < Math.min((this.page + 1) * widgetsPerPage, size); ++i) {
                BindTarget.DisableConfig config = this.disableConfigs.get(i);
                String targetName = this.nameField.method_1882();
                Set hiddenNames = this.hiddenNameMap.computeIfAbsent(targetName, k -> new HashSet());
                ((CyclingTexturedButton)this.method_37063((class_364)new CyclingTexturedButton(32, 16, hiddenNames.contains(config.name()) ? 1 : 0, 2))).setOnValueChange(value -> {
                    if (value == 0) {
                        hiddenNames.remove(config.name());
                    } else {
                        hiddenNames.add(config.name());
                    }
                }).method_48229(this.x + (this.xSize + this.middleWidth) / 2 - 20, this.y + 5 + (this.widgetHeight + 2) * (3 + i % widgetsPerPage));
                ((class_4185)rows.method_47613((class_8021)this.createButton((class_2561)LocUtil.literal(config.name()), this.widgetWidth * 2 - 18, button -> {
                    this.disabledNameField.method_1852(config.name());
                    this.disabledIdField.method_1852(config.textureId());
                    this.disableModeButton.method_32605((Object)(config.disableAll() ? 0 : 1));
                    this.rectWidgets.clear();
                    for (BindTarget.UVRectangle rect : config.rectangles()) {
                        this.rectWidgets.add(this.createRectWidget(rect));
                    }
                    this.initWidgets(this.page);
                }), 3)).method_47400(class_7919.method_47407((class_2561)LocUtil.literal(config.name())));
                rows.method_47615((class_8021)new TexturedButton(48, 0, button -> {
                    this.disableConfigs.removeIf(disableConfig -> disableConfig.name().equals(config.name()));
                    if (this.disabledNameField.method_1882().equals(config.name())) {
                        this.rectWidgets.clear();
                    }
                    this.initWidgets(this.page * widgetsPerPage > size - 2 && size > 1 ? this.page - 1 : this.page);
                }), smallSettings);
            }
        } else {
            widgetsPerPage = 8;
            List<BindTarget> fixedTargetList = ConfigFile.config().getFixedTargetList().stream().filter(target -> target.name().equals(RealCameraCore.currentTarget().name())).toList();
            List<BindTarget> targetList = ConfigFile.config().getBindTargetList();
            int fixedTargetCount = fixedTargetList.size();
            size = fixedTargetCount + targetList.size();
            for (int i = this.page * widgetsPerPage; i < Math.min((this.page + 1) * widgetsPerPage, size); ++i) {
                BindTarget target2 = i < fixedTargetCount ? fixedTargetList.get(i) : targetList.get(i - fixedTargetCount);
                String name = target2.name();
                ((class_4185)rows.method_47613((class_8021)this.createButton((class_2561)LocUtil.literal(name), this.widgetWidth * 2 - 18, button -> this.loadBindTarget(target2)), 3)).method_47400(class_7919.method_47407((class_2561)LocUtil.literal(name)));
                if (i < fixedTargetCount) continue;
                rows.method_47615((class_8021)new TexturedButton(48, 0, button -> {
                    targetList.remove(target2);
                    ConfigFile.save();
                    this.initWidgets(this.page * widgetsPerPage > size - 2 && size > 1 ? this.page - 1 : this.page);
                }), smallSettings);
            }
        }
        grid.method_48222();
        class_7843.method_46443((class_8021)grid, (int)(this.x + (this.xSize + this.middleWidth) / 2 + 4), (int)(this.y + 2), (int)(this.x + this.xSize), (int)(this.y + this.ySize), (float)0.0f, (float)0.0f);
        grid.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        int pages = (size - 1) / widgetsPerPage + 1;
        this.method_37063((class_364)new TexturedButton(this.x + (this.xSize + this.middleWidth) / 2 + 8, this.y + this.ySize - 20, 16, 16, 16, 0, button -> this.initWidgets((this.page - 1 + pages) % pages)));
        this.method_37063((class_364)new class_7842(this.x + (this.xSize + this.middleWidth) / 2 + 30, this.y + this.ySize - 20, this.widgetWidth * 2 - 40, this.widgetHeight, (class_2561)LocUtil.literal(this.page + 1 + " / " + pages), this.field_22793));
        this.method_37063((class_364)new TexturedButton(this.x + this.xSize - 21, this.y + this.ySize - 20, 16, 16, 32, 0, button -> this.initWidgets((this.page + 1) % pages)));
    }

    @NotNull
    public UVRectangleWidget addRectWidget(@NotNull UVRectangleWidget rectWidget) {
        UVRectangleWidget foundRectWidget = this.rectWidgets.stream().filter(r -> r.contains(rectWidget)).findFirst().orElse(null);
        if (foundRectWidget == null) {
            this.rectWidgets.add(rectWidget);
            this.focusedRectWidgetNumberField.setMax(this.rectWidgets.size());
            this.rectWidgetsSizeWidget.method_25355((class_2561)LocUtil.literal(String.valueOf(this.rectWidgets.size())));
            if (this.textureViewArea != null) {
                this.method_37063((class_364)rectWidget);
            }
            return rectWidget;
        }
        return foundRectWidget;
    }

    public boolean deleteFocusedRectWidget() {
        if (this.focusedRectWidget == null) {
            return false;
        }
        this.rectWidgets.remove((Object)this.focusedRectWidget);
        this.method_37066((class_364)this.focusedRectWidget);
        this.focusedRectWidgetNumberField.setNumber(0);
        this.focusedRectWidgetNumberField.setMax(this.rectWidgets.size());
        this.rectWidgetsSizeWidget.method_25355((class_2561)LocUtil.literal(String.valueOf(this.rectWidgets.size())));
        return true;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float deltaTick) {
        super.method_25394(graphics, mouseX, mouseY, deltaTick);
        if ((Integer)this.toggleCategoryButton.method_32603() == 1 && (Integer)this.selectionModeButton.method_32603() == 2 && this.inModelViewArea(mouseX, mouseY)) {
            GUIHelper.enableScissor(graphics, this.modelViewArea);
            GUIHelper.fill(graphics, mouseX - this.selectionRadius, mouseY - this.selectionRadius, mouseX + this.selectionRadius, mouseY + this.selectionRadius, 400.0f, 1328755660);
            graphics.method_44380();
        }
        if (this.textureViewArea != null) {
            GUIHelper.enableScissor(graphics, this.textureViewArea);
            if (this.clickedX >= 0.0 && this.clickedY >= 0.0) {
                graphics.method_25294(Math.min((int)this.clickedX, mouseX), Math.min((int)this.clickedY, mouseY), Math.max((int)this.clickedX, mouseX), Math.max((int)this.clickedY, mouseY), 1328755660);
            }
            if ((Integer)this.disableModeButton.method_32603() == 0) {
                new UVRectangleWidget(0.0f, 0.0f, 1.0f, 1.0f).method_48579(graphics, mouseX, mouseY, deltaTick);
            }
            graphics.method_44380();
        }
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float deltaTick) {
        super.method_25420(graphics, mouseX, mouseY, deltaTick);
        graphics.method_25294(this.x, this.y, this.x + (this.xSize - this.middleWidth) / 2 - 4, this.y + this.ySize, -12303292);
        graphics.method_25294(this.x + (this.xSize - this.middleWidth) / 2, this.y, this.x + (this.xSize + this.middleWidth) / 2, this.y + this.ySize, -14540254);
        graphics.method_25294(this.x + (this.xSize + this.middleWidth) / 2 + 4, this.y, this.x + this.xSize, this.y + this.ySize, -12303292);
        this.analyser.initialize(this.genBindTarget(), this.modelScale);
        this.renderModelViewArea(graphics, (class_1309)this.field_22787.field_1724);
        this.renderTextureViewArea(graphics, (class_1309)this.field_22787.field_1724);
        this.applyAnalyser(graphics, mouseX, mouseY);
    }

    protected void applyAnalyser(class_332 graphics, int mouseX, int mouseY) {
        String textureId = (Integer)this.toggleCategoryButton.method_32603() == 0 ? "" : this.disabledIdField.method_1882();
        Set<String> hiddenNames = this.hiddenNameMap.getOrDefault(this.nameField.method_1882(), Set.of());
        this.analyser.applyDisableConfigs(textureId, hiddenNames);
        if ((Integer)this.toggleCategoryButton.method_32603() == 1 && (Integer)this.selectionModeButton.method_32603() == 2 && this.inModelViewArea(mouseX, mouseY)) {
            this.analyser.computeFocusedOnModel(mouseX - this.selectionRadius, mouseY - this.selectionRadius, mouseX + this.selectionRadius, mouseY + this.selectionRadius);
        }
        if (this.inTextureViewArea(mouseX, mouseY)) {
            this.analyser.computeFocusedOnTexture(mouseX, mouseY);
        }
        if (this.inModelViewArea(mouseX, mouseY)) {
            this.analyser.computeFocusedOnModel(mouseX, mouseY, this.layers);
        }
        if ((Integer)this.toggleCategoryButton.method_32603() == 0 || (Integer)this.selectionModeButton.method_32603() == 1) {
            this.analyser.computeFocusedPolyhedron();
        }
        this.focusedPolyhedron = (VertexData[][])this.analyser.focusedPolyhedron.toArray((T[])new VertexData[0][]);
        this.focusedTextureId = this.analyser.getFocusedTextureId();
        GUIHelper.enableScissor(graphics, this.modelViewArea);
        if ((Integer)this.toggleCategoryButton.method_32603() != 2) {
            this.analyser.drawFocusedInModelArea(graphics);
        }
        if ((Integer)this.toggleCategoryButton.method_32603() == 0) {
            this.analyser.drawBindTarget(graphics);
        } else {
            this.analyser.drawCameraDirections(graphics);
        }
        graphics.method_44380();
        if (this.textureViewArea != null) {
            GUIHelper.enableScissor(graphics, this.textureViewArea);
            this.analyser.drawFocusedInTextureArea(graphics);
            graphics.method_44380();
        }
    }

    protected void renderModelViewArea(class_332 graphics, class_1309 entity) {
        int x1 = this.modelViewArea.method_49620();
        int y1 = this.modelViewArea.method_49618();
        int x2 = this.modelViewArea.method_49621();
        int y2 = this.modelViewArea.method_49619();
        Quaternionf quaternionf = new Quaternionf().rotateX(0.5235988f + this.xRot).rotateY(0.5235988f + this.yRot).rotateZ((float)Math.PI);
        float entityBodyYaw = entity.field_6283;
        float entityYaw = entity.method_36454();
        float entityPitch = entity.method_36455();
        float entityPrevHeadYaw = entity.field_6259;
        float entityHeadYaw = entity.field_6241;
        entity.field_6283 = 180.0f;
        entity.method_36456(180.0f + (float)this.entityYawSlider.getValue());
        entity.method_36457((float)this.entityPitchSlider.getValue());
        entity.field_6241 = entity.method_36454();
        entity.field_6259 = entity.method_36454();
        Vector3f offset = new Vector3f((float)this.modelX, (float)this.modelY, 0.0f);
        this.renderEntityWithAnalyser(graphics, x1, y1, x2, y2, this.modelScale, offset, quaternionf, entity);
        entity.field_6283 = entityBodyYaw;
        entity.method_36456(entityYaw);
        entity.method_36457(entityPitch);
        entity.field_6259 = entityPrevHeadYaw;
        entity.field_6241 = entityHeadYaw;
    }

    protected void renderEntityWithAnalyser(class_332 graphics, int x1, int y1, int x2, int y2, float scale, Vector3f offset, Quaternionf quaternionf, class_1309 entity) {
        this.analyser.modelPose.method_46416((float)(x1 + x2) / 2.0f, (float)(y1 + y2) / 2.0f, 0.0f);
        this.analyser.modelPose.method_22905(scale, scale, -scale);
        this.analyser.modelPose.method_46416(offset.x(), offset.y(), offset.z());
        this.analyser.modelPose.method_22907((Quaternionfc)quaternionf);
        this.analyser.modelPose.method_46416(0.0f, -entity.method_17682() / 2.0f, 0.0f);
        this.analyser.updateModel(this.field_22787, (class_1297)entity, 1.0f, this.analyser.modelPose);
        class_10017 entityRenderState = this.field_22787.method_1561().method_3953((class_1297)entity).method_62425((class_1297)entity, 1.0f);
        entityRenderState.field_58169 = null;
        graphics.method_70856(entityRenderState, scale, offset, quaternionf, new Quaternionf(), x1, y1, x2, y2);
    }

    protected void renderTextureViewArea(class_332 graphics, class_1309 entity) {
        if (this.textureViewArea == null) {
            return;
        }
        int x1 = this.textureViewArea.method_49620();
        int y1 = this.textureViewArea.method_49618();
        int x2 = this.textureViewArea.method_49621();
        int y2 = this.textureViewArea.method_49619();
        Vector3f offset = new Vector3f((float)this.textureX - 0.5f, (float)this.textureY - 0.5f, 0.0f);
        this.renderTextureWithAnalyser(graphics, x1, y1, x2, y2, (float)(this.textureScale * this.textureViewArea.comp_1196()) / 80.0f, offset, entity);
    }

    protected void renderTextureWithAnalyser(class_332 graphics, int x1, int y1, int x2, int y2, float scale, Vector3f offset, class_1309 entity) {
        this.analyser.texturePose.method_46416((float)(x1 + x2) / 2.0f, (float)(y1 + y2) / 2.0f, 0.0f);
        this.analyser.texturePose.method_22905(scale, scale, -scale);
        this.analyser.texturePose.method_46416(offset.x(), offset.y(), offset.z());
        class_10017 entityRenderState = this.field_22787.method_1561().method_3953((class_1297)entity).method_62425((class_1297)entity, 1.0f);
        entityRenderState.field_58169 = null;
        graphics.method_70856(entityRenderState, scale, offset, new Quaternionf(), null, x1, y1, x2, y2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importBindTarget(class_4185 button) {
        class_2540 byteBuf = null;
        try {
            int length;
            String base64 = this.field_22787.field_1774.method_1460();
            byte[] compressed = Base64.getDecoder().decode(base64);
            InflaterInputStream inflaterStream = new InflaterInputStream(new ByteArrayInputStream(compressed));
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((length = inflaterStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, length);
            }
            byte[] bytes = outputStream.toByteArray();
            byteBuf = new class_2540(Unpooled.wrappedBuffer((byte[])bytes));
            BindTarget target = BindTarget.read(byteBuf);
            if (target.isEmpty()) {
                throw new IllegalArgumentException("Invalid config format");
            }
            this.loadBindTarget(target);
            button.method_47400(class_7919.method_47407((class_2561)LocUtil.MODEL_VIEW_TOOLTIP("importSucceeded", LocUtil.literal("'" + target.name() + "'").method_27692(class_124.field_1068)).method_27692(class_124.field_1060)));
        }
        catch (Exception e) {
            Object message = e.getClass().getSimpleName();
            if (e instanceof IllegalArgumentException) {
                message = (String)message + ": " + e.getMessage();
            }
            button.method_47400(class_7919.method_47407((class_2561)LocUtil.MODEL_VIEW_TOOLTIP("importFailed", message).method_27692(class_124.field_1061)));
        }
        finally {
            if (byteBuf != null) {
                byteBuf.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportBindTarget(class_4185 button) {
        class_2540 byteBuf = new class_2540(Unpooled.buffer());
        try {
            this.genBindTarget().write(byteBuf);
            byte[] bytes = new byte[byteBuf.readableBytes()];
            byteBuf.method_52952(byteBuf.readerIndex(), bytes);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try (DeflaterOutputStream deflaterStream = new DeflaterOutputStream((OutputStream)outputStream, new Deflater(9));){
                deflaterStream.write(bytes);
            }
            String base64 = Base64.getEncoder().encodeToString(outputStream.toByteArray());
            this.field_22787.field_1774.method_1455(base64);
            button.method_47400(class_7919.method_47407((class_2561)LocUtil.MODEL_VIEW_TOOLTIP("exportSucceeded", new Object[0]).method_27692(class_124.field_1060)));
        }
        catch (Exception e) {
            String message = e.getClass().getSimpleName() + ": " + e.getMessage();
            button.method_47400(class_7919.method_47407((class_2561)LocUtil.MODEL_VIEW_TOOLTIP("exportFailed", message).method_27692(class_124.field_1061)));
        }
        finally {
            byteBuf.release();
        }
    }

    protected void loadBindTarget(BindTarget target) {
        if (target.isEmpty()) {
            return;
        }
        this.nameField.method_1852(target.name());
        this.textureIdField.method_1852(target.textureId());
        this.priorityField.setNumber(target.priority());
        this.depthField.setNumber(Float.valueOf(target.disablingDepth()));
        this.forwardUField.setNumber(Float.valueOf(target.targetConfig().forwardU()));
        this.forwardVField.setNumber(Float.valueOf(target.targetConfig().forwardV()));
        this.upwardUField.setNumber(Float.valueOf(target.targetConfig().upwardU()));
        this.upwardVField.setNumber(Float.valueOf(target.targetConfig().upwardV()));
        this.posUField.setNumber(Float.valueOf(target.targetConfig().posU()));
        this.posVField.setNumber(Float.valueOf(target.targetConfig().posV()));
        this.bindXButton.setValue(target.bindConfig().bindX() ? 0 : 1);
        this.bindYButton.setValue(target.bindConfig().bindY() ? 0 : 1);
        this.bindZButton.setValue(target.bindConfig().bindZ() ? 0 : 1);
        this.bindRotButton.setValue(target.bindConfig().bindRotation() ? 0 : 1);
        this.scaleField.setNumber(Float.valueOf(target.offsets().getScale()));
        this.offsetXSlider.setValue(target.offsets().getX());
        this.offsetXField.setNumber(Float.valueOf(target.offsets().getX()));
        this.offsetYSlider.setValue(target.offsets().getY());
        this.offsetYField.setNumber(Float.valueOf(target.offsets().getY()));
        this.offsetZSlider.setValue(target.offsets().getZ());
        this.offsetZField.setNumber(Float.valueOf(target.offsets().getZ()));
        this.offsetPitchSlider.setValue(target.offsets().getPitch());
        this.offsetPitchField.setNumber(Float.valueOf(target.offsets().getPitch()));
        this.offsetYawSlider.setValue(target.offsets().getYaw());
        this.offsetYawField.setNumber(Float.valueOf(target.offsets().getYaw()));
        this.offsetRollSlider.setValue(target.offsets().getRoll());
        this.offsetRollField.setNumber(Float.valueOf(target.offsets().getRoll()));
        this.disableConfigs.clear();
        this.disableConfigs.addAll(List.of(target.disableConfigs()));
    }

    protected BindTarget genBindTarget() {
        BindTarget.TargetConfig targetConfig = new BindTarget.TargetConfig(this.forwardUField.getNumber().floatValue(), this.forwardVField.getNumber().floatValue(), this.upwardUField.getNumber().floatValue(), this.upwardVField.getNumber().floatValue(), this.posUField.getNumber().floatValue(), this.posVField.getNumber().floatValue());
        BindTarget.BindConfig bindConfig = new BindTarget.BindConfig(this.bindXButton.getValue() == 0, this.bindYButton.getValue() == 0, this.bindZButton.getValue() == 0, this.bindRotButton.getValue() == 0);
        BindTarget.OffsetConfig offsets = new BindTarget.OffsetConfig().setScale(this.scaleField.getNumber().floatValue()).setX((Integer)this.toggleSliderButton.method_32603() == 0 ? (float)this.offsetXSlider.getValue() : this.offsetXField.getNumber().floatValue()).setY((Integer)this.toggleSliderButton.method_32603() == 0 ? (float)this.offsetYSlider.getValue() : this.offsetYField.getNumber().floatValue()).setZ((Integer)this.toggleSliderButton.method_32603() == 0 ? (float)this.offsetZSlider.getValue() : this.offsetZField.getNumber().floatValue()).setPitch((Integer)this.toggleSliderButton.method_32603() == 0 ? (float)this.offsetPitchSlider.getValue() : this.offsetPitchField.getNumber().floatValue()).setYaw((Integer)this.toggleSliderButton.method_32603() == 0 ? (float)this.offsetYawSlider.getValue() : this.offsetYawField.getNumber().floatValue()).setRoll((Integer)this.toggleSliderButton.method_32603() == 0 ? (float)this.offsetRollSlider.getValue() : this.offsetRollField.getNumber().floatValue());
        BindTarget.DisableConfig currentDisableConfig = new BindTarget.DisableConfig(this.disabledNameField.method_1882(), this.disabledIdField.method_1882(), (Integer)this.disableModeButton.method_32603() == 0, (BindTarget.UVRectangle[])this.rectWidgets.stream().map(UVRectangleWidget::toUVRectangle).toArray(BindTarget.UVRectangle[]::new));
        BindTarget.DisableConfig[] disableConfigArray = this.disableConfigs.toArray(new BindTarget.DisableConfig[0]);
        for (int i = 0; i < disableConfigArray.length; ++i) {
            if (!disableConfigArray[i].name().equals(currentDisableConfig.name())) continue;
            disableConfigArray[i] = currentDisableConfig;
        }
        return new BindTarget(this.nameField.method_1882(), this.textureIdField.method_1882(), this.priorityField.getNumber(), this.depthField.getNumber().floatValue(), targetConfig, bindConfig, offsets, disableConfigArray);
    }

    protected class_7919 createTooltip(String key, Object ... args) {
        return class_7919.method_47407((class_2561)LocUtil.MODEL_VIEW_TOOLTIP(key, args));
    }

    protected UVRectangleWidget createRectWidget(BindTarget.UVRectangle rect) {
        return new UVRectangleWidget(rect.uMin(), rect.vMin(), rect.uMax(), rect.vMax());
    }

    protected class_4185 createButton(class_2561 message, int width, class_4185.class_4241 onPress) {
        return class_4185.method_46430((class_2561)message, (class_4185.class_4241)onPress).method_46437(width, this.widgetHeight).method_46431();
    }

    protected class_5676<Integer> createCyclingButton(SequencedMap<Integer, class_2561> messages, int width, class_2561 optionText, class_7172.class_7277<Integer> tooltipSupplier) {
        return new class_5676.class_5677(messages::get).method_32620(messages.sequencedKeySet()).method_32619((Object)0).method_32618(tooltipSupplier).method_35723(0, 0, width, this.widgetHeight, optionText);
    }

    protected class_5676<Integer> createCyclingButton(SequencedMap<Integer, class_2561> messages, int width, class_7172.class_7277<Integer> tooltipSupplier, class_5676.class_5678<Integer> onValueChange) {
        return new class_5676.class_5677(messages::get).method_32620(messages.sequencedKeySet()).method_32619((Object)0).method_32618(tooltipSupplier).method_32616().method_32617(0, 0, width, this.widgetHeight, (class_2561)class_2561.method_43473(), onValueChange);
    }

    protected DoubleSlider createSlider(String key, int width, double min, double max) {
        return new DoubleSlider(width, this.widgetHeight, 0.0, min, max, d -> LocUtil.MODEL_VIEW_WIDGET(key, MathUtil.round(d, 2)));
    }

    protected NumberField<Float> createFloatField(int width, float defaultValue, @Nullable NumberField<Float> copyFrom) {
        return NumberField.ofFloat(this.field_22793, width - 2, this.widgetHeight - 2, defaultValue, copyFrom).setMax(Float.valueOf(1.0f)).setMin(Float.valueOf(0.0f));
    }

    protected class_342 createTextField(int width, int maxLength, @Nullable class_342 copyFrom) {
        class_342 editBox = new class_342(this.field_22793, 0, 0, width - 2, this.widgetHeight - 2, (class_2561)class_2561.method_43473());
        editBox.method_1880(maxLength);
        if (copyFrom != null) {
            editBox.method_1852(copyFrom.method_1882());
        }
        return editBox;
    }

    protected boolean inModelViewArea(double x, double y) {
        return this.modelViewArea.method_58137((int)x, (int)y);
    }

    protected boolean inTextureViewArea(double x, double y) {
        return this.textureViewArea != null && this.textureViewArea.method_58137((int)x, (int)y);
    }

    public boolean leftClickedWithModifier(double mouseX, double mouseY) {
        if (this.focusedPolyhedron.length == 0) {
            return false;
        }
        if (this.inModelViewArea(mouseX, mouseY) && (Integer)this.toggleCategoryButton.method_32603() == 0) {
            float u = 0.0f;
            float v = 0.0f;
            for (VertexData vertex : this.focusedPolyhedron[0]) {
                u += vertex.u();
                v += vertex.v();
            }
            u /= (float)this.focusedPolyhedron[0].length;
            v /= (float)this.focusedPolyhedron[0].length;
            if ((Integer)this.selectingButton.method_32603() == 0) {
                this.forwardUField.setNumber(Float.valueOf(u));
                this.forwardVField.setNumber(Float.valueOf(v));
            } else if ((Integer)this.selectingButton.method_32603() == 1) {
                this.upwardUField.setNumber(Float.valueOf(u));
                this.upwardVField.setNumber(Float.valueOf(v));
            } else {
                this.posUField.setNumber(Float.valueOf(u));
                this.posVField.setNumber(Float.valueOf(v));
            }
            this.textureIdField.method_1852(this.focusedTextureId);
            return true;
        }
        if ((this.inModelViewArea(mouseX, mouseY) || this.inTextureViewArea(mouseX, mouseY)) && (Integer)this.toggleCategoryButton.method_32603() == 1) {
            String disabledId = this.disabledIdField.method_1882();
            if (disabledId.isBlank() || !this.focusedTextureId.contains(disabledId)) {
                this.disabledIdField.method_1852(this.focusedTextureId);
                return true;
            }
            if ((Integer)this.selectionModeButton.method_32603() == 2) {
                boolean merged;
                ArrayList<UVRectangleWidget> rectWidgets = new ArrayList<UVRectangleWidget>();
                for (VertexData[] primitive : this.focusedPolyhedron) {
                    float uMin = 1.0f;
                    float vMin = 1.0f;
                    float uMax = 0.0f;
                    float vMax = 0.0f;
                    for (VertexData vertex : primitive) {
                        if (vertex.u() < uMin) {
                            uMin = vertex.u();
                        }
                        if (vertex.v() < vMin) {
                            vMin = vertex.v();
                        }
                        if (vertex.u() > uMax) {
                            uMax = vertex.u();
                        }
                        if (!(vertex.v() > vMax)) continue;
                        vMax = vertex.v();
                    }
                    rectWidgets.add(new UVRectangleWidget(uMin, vMin, uMax, vMax));
                }
                do {
                    merged = false;
                    for (int i = 0; i < rectWidgets.size(); ++i) {
                        UVRectangleWidget rectWidget = (UVRectangleWidget)((Object)rectWidgets.get(i));
                        int j = i + 1;
                        while (j < rectWidgets.size()) {
                            if (rectWidget.mergeWith((UVRectangleWidget)((Object)rectWidgets.get(j)))) {
                                rectWidgets.remove(j);
                                merged = true;
                                continue;
                            }
                            ++j;
                        }
                    }
                } while (merged);
                rectWidgets.forEach(this::addRectWidget);
            } else {
                float uMin = 1.0f;
                float vMin = 1.0f;
                float uMax = 0.0f;
                float vMax = 0.0f;
                VertexData[][] vertexDataArray = this.focusedPolyhedron;
                int n = vertexDataArray.length;
                for (int i = 0; i < n; ++i) {
                    VertexData[] primitive;
                    for (VertexData vertex : primitive = vertexDataArray[i]) {
                        if (vertex.u() < uMin) {
                            uMin = vertex.u();
                        }
                        if (vertex.v() < vMin) {
                            vMin = vertex.v();
                        }
                        if (vertex.u() > uMax) {
                            uMax = vertex.u();
                        }
                        if (!(vertex.v() > vMax)) continue;
                        vMax = vertex.v();
                    }
                }
                this.method_25395((class_364)this.addRectWidget(new UVRectangleWidget(uMin, vMin, uMax, vMax)));
            }
            return true;
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        double storedX = this.clickedX;
        double storedY = this.clickedY;
        this.clickedY = -1.0;
        this.clickedX = -1.0;
        if (button == 0 && (Integer)this.toggleCategoryButton.method_32603() != 2) {
            if (class_3675.method_15987((long)this.field_22787.method_22683().method_4490(), (int)this.modifierKey.method_1444())) {
                if (this.leftClickedWithModifier(mouseX, mouseY)) {
                    return true;
                }
            } else if (this.inTextureViewArea(mouseX, mouseY)) {
                if (super.method_25402(mouseX, mouseY, button)) {
                    return true;
                }
                if (storedX >= 0.0 && storedY >= 0.0) {
                    float xMin = (float)Math.min(storedX, mouseX);
                    float yMin = (float)Math.min(storedY, mouseY);
                    float xMax = (float)Math.max(storedX, mouseX);
                    float yMax = (float)Math.max(storedY, mouseY);
                    this.method_25395((class_364)this.addRectWidget(new UVRectangleWidget(xMin, yMin, xMax, yMax, this.textureViewArea)));
                    return true;
                }
                this.clickedX = (int)mouseX;
                this.clickedY = (int)mouseY;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0 && !class_3675.method_15987((long)this.field_22787.method_22683().method_4490(), (int)this.modifierKey.method_1444())) {
            if (this.inModelViewArea(mouseX, mouseY)) {
                this.xRot += (float)(Math.PI * deltaY / (double)this.ySize);
                this.yRot -= (float)(Math.PI * deltaX / (double)this.middleWidth);
                return true;
            }
        } else if (button == 1) {
            if (this.inModelViewArea(mouseX, mouseY)) {
                this.modelX += deltaX / (double)this.modelScale;
                this.modelY += deltaY / (double)this.modelScale;
                return true;
            }
            if (this.inTextureViewArea(mouseX, mouseY)) {
                this.textureX += deltaX / (double)this.textureScale;
                this.textureY += deltaY / (double)this.textureScale;
                return true;
            }
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.inModelViewArea(mouseX, mouseY)) {
            if (class_3675.method_15987((long)this.field_22787.method_22683().method_4490(), (int)this.modifierKey.method_1444())) {
                if ((Integer)this.toggleCategoryButton.method_32603() == 1 && (Integer)this.selectionModeButton.method_32603() == 2) {
                    this.selectionRadius = class_3532.method_15340((int)(this.selectionRadius + (int)verticalAmount * 2), (int)2, (int)48);
                } else {
                    this.layers = Math.max(0, this.layers + (int)verticalAmount);
                }
            } else {
                this.modelScale = class_3532.method_15340((int)(this.modelScale + (int)verticalAmount * this.modelScale / 16), (int)16, (int)1024);
            }
            return true;
        }
        if (this.inTextureViewArea(mouseX, mouseY)) {
            this.textureScale = class_3532.method_15340((int)(this.textureScale + (int)verticalAmount * this.textureScale / 16), (int)16, (int)1024);
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        class_364 focused;
        if (class_8494.method_51255((int)keyCode) && (focused = this.method_25399()) != null && !focused.method_25370()) {
            this.method_25395((class_364)this.focusedRectWidget);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25421() {
        return this.pauseButton.getValue() == 1;
    }

    public class UVRectangleWidget
    extends class_339 {
        protected float uMin;
        protected float vMin;
        protected float uMax;
        protected float vMax;

        public UVRectangleWidget(float uMin, float vMin, float uMax, float vMax) {
            super(0, 0, 16, 16, (class_2561)class_2561.method_43473());
            this.uMin = uMin;
            this.vMin = vMin;
            this.uMax = uMax;
            this.vMax = vMax;
        }

        public UVRectangleWidget(float xMin, float yMin, float xMax, @NotNull float yMax, class_8030 screenArea) {
            super((int)xMin, (int)yMin, (int)(xMax - xMin), (int)(yMax - yMin), (class_2561)class_2561.method_43473());
            class_241 minUV = this.translateXYToUV(xMin, yMin, screenArea);
            class_241 maxUV = this.translateXYToUV(xMax, yMax, screenArea);
            this.uMin = minUV.field_1343;
            this.vMin = minUV.field_1342;
            this.uMax = maxUV.field_1343;
            this.vMax = maxUV.field_1342;
        }

        public BindTarget.UVRectangle toUVRectangle() {
            return new BindTarget.UVRectangle(this.uMin, this.vMin, this.uMax, this.vMax);
        }

        public boolean contains(UVRectangleWidget other) {
            return this.uMin <= other.uMin && this.vMin <= other.vMin && this.uMax >= other.uMax && this.vMax >= other.vMax;
        }

        public boolean mergeWith(UVRectangleWidget other) {
            if (this.uMin == other.uMin && this.uMax == other.uMax && this.vMin <= other.vMax && this.vMax >= other.vMin) {
                this.vMin = Math.min(this.vMin, other.vMin);
                this.vMax = Math.max(this.vMax, other.vMax);
                return true;
            }
            if (this.vMin == other.vMin && this.vMax == other.vMax && this.uMin <= other.uMax && this.uMax >= other.uMin) {
                this.uMin = Math.min(this.uMin, other.uMin);
                this.uMax = Math.max(this.uMax, other.uMax);
                return true;
            }
            return false;
        }

        private class_241 translateUVToXY(float u, float v, class_8030 screenArea) {
            int x1 = screenArea.method_49620();
            int y1 = screenArea.method_49618();
            int x2 = screenArea.method_49621();
            int y2 = screenArea.method_49619();
            Vector3f vector3f = new Vector3f(u, v, 0.0f).add((float)ModelViewScreen.this.textureX - 0.5f, (float)ModelViewScreen.this.textureY - 0.5f, 0.0f).mul((float)(ModelViewScreen.this.textureScale * screenArea.comp_1196()) / 80.0f).add((float)(x1 + x2) / 2.0f, (float)(y1 + y2) / 2.0f, 0.0f);
            return new class_241(vector3f.x(), vector3f.y());
        }

        private class_241 translateXYToUV(float x, float y, class_8030 screenArea) {
            int x1 = screenArea.method_49620();
            int y1 = screenArea.method_49618();
            int x2 = screenArea.method_49621();
            int y2 = screenArea.method_49619();
            Vector3f vector3f = new Vector3f(x, y, 0.0f).add(-((float)(x1 + x2)) / 2.0f, -((float)(y1 + y2)) / 2.0f, 0.0f).mul(80.0f / (float)(ModelViewScreen.this.textureScale * screenArea.comp_1196())).add((float)(-ModelViewScreen.this.textureX) + 0.5f, (float)(-ModelViewScreen.this.textureY) + 0.5f, 0.0f);
            return new class_241(vector3f.x(), vector3f.y());
        }

        protected void method_48579(class_332 graphics, int mouseX, int mouseY, float deltaTick) {
            class_241 minXY = this.translateUVToXY(this.uMin, this.vMin, ModelViewScreen.this.textureViewArea);
            class_241 maxXY = this.translateUVToXY(this.uMax, this.vMax, ModelViewScreen.this.textureViewArea);
            float x1 = minXY.field_1343;
            float y1 = minXY.field_1342;
            float x2 = maxXY.field_1343;
            float y2 = maxXY.field_1342;
            float width = x2 - x1;
            float height = y2 - y1;
            this.method_46421((int)x1);
            this.method_46419((int)y1);
            this.method_25358((int)width);
            this.method_53533((int)height);
            GUIHelper.enableScissor(graphics, ModelViewScreen.this.textureViewArea);
            GUIHelper.fill(graphics, x1, y1, x2, y2, 1328755660);
            if (this.method_25367()) {
                GUIHelper.fill(graphics, x1, y1, x2, y2, 791884748);
            }
            if (this.method_25370() || this == ModelViewScreen.this.focusedRectWidget) {
                GUIHelper.renderOutline(graphics, x1, y1, width, height, -1426063361);
            }
            graphics.method_44380();
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (ModelViewScreen.this.textureViewArea == null) {
                return false;
            }
            if (keyCode == 261 && ModelViewScreen.this.deleteFocusedRectWidget()) {
                return true;
            }
            if (class_8494.method_51255((int)keyCode) && this.uMin < this.uMax && this.vMin < this.vMax) {
                ModelViewScreen.this.textureX = 0.5 * (double)(1.0f - this.uMin - this.uMax);
                ModelViewScreen.this.textureY = 0.5 * (double)(1.0f - this.vMin - this.vMax);
                ModelViewScreen.this.textureScale = (int)class_3532.method_15350((double)(2560.0 / ((double)ModelViewScreen.this.textureViewArea.comp_1196() * Math.sqrt((this.uMax - this.uMin) * (this.vMax - this.vMin)))), (double)16.0, (double)1024.0);
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        public void method_25365(boolean focused) {
            super.method_25365(focused);
            if (focused) {
                ModelViewScreen.this.focusedRectWidget = this;
                ModelViewScreen.this.focusedRectWidgetNumberField.setNumber(ModelViewScreen.this.rectWidgets.indexOf((Object)this) + 1);
                ModelViewScreen.this.uMinField.setNumber(Float.valueOf(this.uMin));
                ModelViewScreen.this.vMinField.setNumber(Float.valueOf(this.vMin));
                ModelViewScreen.this.uMaxField.setNumber(Float.valueOf(this.uMax));
                ModelViewScreen.this.vMaxField.setNumber(Float.valueOf(this.vMax));
            }
        }

        protected void method_47399(class_6382 narrationElementOutput) {
        }
    }
}

