/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.util;

import com.xtracr.realcamera.util.IterableVertexBuffer;
import com.xtracr.realcamera.util.VertexData;
import java.awt.Polygon;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1921;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;

public record BuiltIterableBuffer(class_1921 renderType, String textureId, IterableVertexBuffer vertexBuffer) {
    private static final Pattern TEXTURE_ID_PATTERN = Pattern.compile("texture\\[Optional\\[(.*?)]");
    private static final Map<class_1921, String> TEXTURE_ID_CACHE = new HashMap<class_1921, String>();
    private static final Map<class_1921, Map<VertexData.UV, float[]>> FIND_PRIMITIVE_CACHE = new HashMap<class_1921, Map<VertexData.UV, float[]>>();

    public static BuiltIterableBuffer buildFrom(class_1921 renderType, class_9801 meshData) {
        String textureId = TEXTURE_ID_CACHE.computeIfAbsent(renderType, rt -> {
            String renderTypeName = rt.toString();
            Matcher matcher = TEXTURE_ID_PATTERN.matcher(renderTypeName);
            return matcher.find() ? matcher.group(1) : renderTypeName;
        });
        return new BuiltIterableBuffer(renderType, textureId, new IterableVertexBuffer(meshData));
    }

    public boolean anyNotCached(VertexData.UV[] uvs) {
        Map<VertexData.UV, float[]> cache = FIND_PRIMITIVE_CACHE.get(this.renderType);
        if (cache == null) {
            return true;
        }
        for (VertexData.UV uv : uvs) {
            if (cache.containsKey(uv)) continue;
            return true;
        }
        return false;
    }

    public VertexData[] @Nullable [] findPrimitivesInCache(VertexData.UV[] uvs) {
        Map<VertexData.UV, float[]> cache = FIND_PRIMITIVE_CACHE.get(this.renderType);
        int length = this.renderType.method_23033().field_27384;
        int uvsLength = uvs.length;
        VertexData[][] primitives = new VertexData[uvsLength][];
        if (cache == null) {
            return primitives;
        }
        float[][] uvCacheArray = new float[uvsLength][];
        boolean allNull = true;
        for (int i = 0; i < uvsLength; ++i) {
            uvCacheArray[i] = cache.get(uvs[i]);
            if (uvCacheArray[i] == null) continue;
            allNull = false;
        }
        if (allNull) {
            return primitives;
        }
        this.vertexBuffer.primitiveStream().anyMatch(primitive -> {
            boolean allFound = true;
            block0: for (int i = 0; i < uvsLength; ++i) {
                float[] uvCache;
                if (primitives[i] != null || (uvCache = uvCacheArray[i]) == null) continue;
                for (int j = 0; j < length; ++j) {
                    if (uvCache[j * 2] == primitive[j].u() && uvCache[j * 2 + 1] == primitive[j].v()) continue;
                    allFound = false;
                    continue block0;
                }
                primitives[i] = VertexData.asImmutable(primitive);
            }
            return allFound;
        });
        return primitives;
    }

    public VertexData[] @Nullable [] findPrimitives(VertexData.UV[] uvs) {
        int resolution = 1000000;
        int length = this.renderType.method_23033().field_27384;
        int uvsLength = uvs.length;
        int[] us = new int[length];
        int[] vs = new int[length];
        VertexData[][] primitives = new VertexData[uvsLength][];
        this.vertexBuffer.primitiveStream().anyMatch(primitive -> {
            for (int i = 0; i < length; ++i) {
                us[i] = (int)(1000000.0f * primitive[i].u());
                vs[i] = (int)(1000000.0f * primitive[i].v());
            }
            Polygon polygon = new Polygon(us, vs, length);
            boolean allFound = true;
            for (int i = 0; i < uvsLength; ++i) {
                VertexData.UV uv;
                if (primitives[i] != null || (uv = uvs[i]) == null) continue;
                if (!polygon.contains(1000000.0f * uv.u(), 1000000.0f * uv.v())) {
                    allFound = false;
                    continue;
                }
                float[] uvCache = new float[length * 2];
                for (int j = 0; j < length; ++j) {
                    uvCache[j * 2] = primitive[j].u();
                    uvCache[j * 2 + 1] = primitive[j].v();
                }
                FIND_PRIMITIVE_CACHE.computeIfAbsent(this.renderType, k -> new HashMap()).put(uv, uvCache);
                primitives[i] = VertexData.asImmutable(primitive);
            }
            return allFound;
        });
        return primitives;
    }
}

