/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.util;

import com.xtracr.realcamera.util.BuiltIterableBuffer;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectSortedMaps;
import java.util.Arrays;
import java.util.SequencedMap;
import java.util.function.Consumer;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.jetbrains.annotations.NotNull;

public interface MultiVertexCatcher
extends class_4597 {
    public static MultiVertexCatcher defaultImpl() {
        return MeshCatcher.INSTANCE;
    }

    public void endCatching(Consumer<BuiltIterableBuffer> var1);

    public static class MeshCatcher
    extends class_4597.class_4598
    implements MultiVertexCatcher {
        private static final MeshCatcher INSTANCE = new MeshCatcher();
        private final SequencedMap<class_1921, ByteBufferBuilderPool> bufferPools = new Object2ObjectLinkedOpenHashMap();
        private final SequencedMap<class_9801, class_1921> caughtMeshes = new Object2ObjectLinkedOpenHashMap();

        protected MeshCatcher() {
            super(new class_9799(0), (SequencedMap)Object2ObjectSortedMaps.emptyMap());
        }

        @NotNull
        public class_4588 getBuffer(class_1921 renderType) {
            class_287 bufferBuilder = (class_287)this.field_52157.get(renderType);
            if (bufferBuilder != null) {
                this.method_60893(renderType, bufferBuilder);
            }
            ByteBufferBuilderPool bufferPool = this.bufferPools.computeIfAbsent(renderType, type -> new ByteBufferBuilderPool(type.method_22722()));
            bufferBuilder = new class_287(bufferPool.getBuffer(), renderType.method_23033(), renderType.method_23031());
            this.field_52157.put(renderType, bufferBuilder);
            return bufferBuilder;
        }

        @Override
        public void endCatching(Consumer<BuiltIterableBuffer> consumer) {
            this.method_22993();
            this.caughtMeshes.forEach((meshData, renderType) -> {
                consumer.accept(BuiltIterableBuffer.buildFrom(renderType, meshData));
                meshData.close();
            });
            this.caughtMeshes.clear();
            this.bufferPools.values().forEach(ByteBufferBuilderPool::release);
        }

        public void method_22993() {
            for (class_1921 renderType : this.bufferPools.keySet()) {
                this.method_22994(renderType);
            }
        }

        protected void method_60893(class_1921 renderType, class_287 bufferBuilder) {
            class_9801 meshData = bufferBuilder.method_60794();
            if (meshData != null) {
                this.caughtMeshes.put(meshData, renderType);
            }
        }

        private static class ByteBufferBuilderPool {
            private final int bufferSize;
            private class_9799[] pool = new class_9799[0];
            private int next = 0;

            public ByteBufferBuilderPool(int bufferSize) {
                this.bufferSize = bufferSize;
            }

            public class_9799 getBuffer() {
                class_9799 byteBufferBuilder;
                if (this.next < this.pool.length) {
                    byteBufferBuilder = this.pool[this.next++];
                } else {
                    this.pool = Arrays.copyOf(this.pool, this.pool.length + 1);
                    this.pool[this.next++] = byteBufferBuilder = new class_9799(this.bufferSize);
                }
                return byteBufferBuilder;
            }

            public void release() {
                this.next = 0;
            }
        }
    }
}

