/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera;

import com.xtracr.realcamera.EventHandler;
import com.xtracr.realcamera.KeyMappings;
import com.xtracr.realcamera.RealCamera;
import com.xtracr.realcamera.config.ConfigScreen;
import java.util.Map;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="realcamera")
public class RealCameraNeoForge
implements RealCamera {
    private final ModContainer modContainer;
    private final Map<String, String> modIdMap = Map.of("cloth-config", "cloth_config");

    public RealCameraNeoForge(IEventBus modEventBus, ModContainer modContainer) {
        this.modContainer = modContainer;
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::onKeyRegister);
    }

    public void clientSetup(FMLClientSetupEvent event) {
        this.initialize();
        NeoForge.EVENT_BUS.addListener(EventHandler::onClientTick);
        NeoForge.EVENT_BUS.addListener(EventHandler::onFrameGraphSetup);
        if (this.isModLoaded("cloth-config")) {
            this.modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(container, modListScreen) -> ConfigScreen.create(modListScreen)));
        }
    }

    public void onKeyRegister(RegisterKeyMappingsEvent event) {
        KeyMappings.register(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(this.modIdMap.getOrDefault(modId, modId));
    }
}

