/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.api;

import com.xtracr.realcamera.config.BindTarget;
import com.xtracr.realcamera.config.ConfigFile;
import java.util.List;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BindResult {
    public static final BindResult EMPTY = new BindResult(BindTarget.EMPTY, false);
    public final BindTarget target;
    protected final Matrix3f rotation = new Matrix3f();
    protected final boolean mirrored;
    private Vec3 position = Vec3.ZERO;
    private Vec3 forward = Vec3.ZERO;
    private Vec3 upward = Vec3.ZERO;

    public BindResult(BindTarget target, boolean mirrored) {
        this.target = target;
        this.mirrored = mirrored;
    }

    public static BindResult getOrCreate(String name) {
        List<BindTarget> fixedTargets = ConfigFile.config().getFixedTargetList();
        BindTarget target = fixedTargets.stream().filter(t -> t.name().equals(name)).findFirst().orElseGet(() -> {
            BindTarget blank = BindTarget.blank(name, "");
            fixedTargets.add(blank);
            return blank;
        });
        return new BindResult(target, false);
    }

    public boolean available() {
        return !this.target.isEmpty() && !this.forward.equals((Object)Vec3.ZERO) && !this.upward.equals((Object)Vec3.ZERO) && Double.isFinite(this.position.lengthSqr()) && Math.abs(this.rotation.determinant() - 1.0f) < 0.01f;
    }

    public boolean weakAvailable() {
        return !this.target.isEmpty() && (this.forward != Vec3.ZERO || this.upward != Vec3.ZERO || this.position != Vec3.ZERO) && Double.isFinite(this.position.lengthSqr());
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public void setPosition(Vec3 vec) {
        this.position = vec;
    }

    public Vec3 getForward() {
        return this.forward;
    }

    public void setForward(Vec3 vec) {
        this.forward = vec.normalize();
    }

    public Vec3 getUpward() {
        return this.upward;
    }

    public void setUpward(Vec3 vec) {
        this.upward = vec.normalize();
    }

    public Matrix3f getRotation() {
        return this.rotation;
    }

    public BindResult computeCamera() {
        if (!this.available()) {
            return this;
        }
        int orientation = this.mirrored ? -1 : 1;
        this.upward = this.forward.cross(this.upward.cross(this.forward)).normalize();
        Vec3 left = this.upward.cross(this.forward).scale((double)orientation);
        this.rotation.set((Vector3fc)left.toVector3f(), (Vector3fc)this.upward.toVector3f(), (Vector3fc)this.forward.toVector3f());
        BindTarget.OffsetConfig offsets = this.target.offsets();
        Vector3f offset = new Vector3f(offsets.getZ(), offsets.getY(), offsets.getX()).mul(offsets.getScale()).mul((Matrix3fc)this.rotation);
        this.position = this.position.add((double)offset.x(), (double)offset.y(), (double)offset.z());
        this.rotation.rotateLocal((float)orientation * (float)Math.toRadians(offsets.getYaw()), this.rotation.m10, this.rotation.m11, this.rotation.m12);
        this.rotation.rotateLocal((float)orientation * (float)Math.toRadians(offsets.getPitch()), this.rotation.m00, this.rotation.m01, this.rotation.m02);
        this.rotation.rotateLocal((float)orientation * (float)Math.toRadians(offsets.getRoll()), this.rotation.m20, this.rotation.m21, this.rotation.m22);
        return this;
    }
}

