/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.compat;

import com.xtracr.realcamera.RealCamera;
import com.xtracr.realcamera.RealCameraCore;
import com.xtracr.realcamera.compat.DisableHelper;
import com.xtracr.realcamera.compat.LegacyBindingMode;
import com.xtracr.realcamera.compat.PlatformHelper;
import com.xtracr.realcamera.compat.YSMCompat;
import com.xtracr.realcamera.config.ConfigFile;
import com.xtracr.realcamera.mixin.accessor.CameraAccessor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.client.Camera;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class CompatibilityHelper {
    private static PlatformHelper platformHelper;
    private static Method NEA_playerTransformer_setDeltaTick;
    private static Field NEA_NEAnimationsLoader_INSTANCE;
    private static Field NEA_NEAnimationsLoader_playerTransformer;
    private static Field SBW_ClientEventHandler_zoomTime;
    private static Class<?> SBW_VehicleEntity;

    public static void initialize(PlatformHelper platformHelper) {
        CompatibilityHelper.platformHelper = platformHelper;
        LegacyBindingMode.register();
        if (CompatibilityHelper.isModLoaded("yes_steve_model")) {
            YSMCompat.register();
        }
        if (CompatibilityHelper.isModLoaded("freecam")) {
            try {
                Class<?> FC_Freecam = Class.forName("net.xolt.freecam.Freecam");
                Method FC_Freecam_isEnabled = FC_Freecam.getDeclaredMethod("isEnabled", new Class[0]);
                DisableHelper.MAIN_FEATURE.registerOr(player -> {
                    try {
                        return (Boolean)FC_Freecam_isEnabled.invoke(null, new Object[0]);
                    }
                    catch (Exception ignored) {
                        return false;
                    }
                });
            }
            catch (Exception e) {
                RealCamera.LOGGER.warn("Compatibility with Freecam is outdated: [{}] {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            }
        }
        if (CompatibilityHelper.isModLoaded("notenoughanimations")) {
            try {
                Class<?> NEA_NEAnimationsLoader = Class.forName("dev.tr7zw.notenoughanimations.NEAnimationsLoader");
                Class<?> NEA_PlayerTransformer = Class.forName("dev.tr7zw.notenoughanimations.logic.PlayerTransformer");
                NEA_playerTransformer_setDeltaTick = NEA_PlayerTransformer.getDeclaredMethod("setDeltaTick", Float.TYPE);
                NEA_NEAnimationsLoader_INSTANCE = NEA_NEAnimationsLoader.getDeclaredField("INSTANCE");
                NEA_NEAnimationsLoader_playerTransformer = NEA_NEAnimationsLoader.getDeclaredField("playerTransformer");
            }
            catch (Exception e) {
                RealCamera.LOGGER.warn("Compatibility with Not Enough Animations is outdated: [{}] {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            }
        }
        if (CompatibilityHelper.isModLoaded("superbwarfare")) {
            try {
                Class<?> SBW_ClientEventHandler = Class.forName("com.atsuishio.superbwarfare.event.ClientEventHandler");
                SBW_ClientEventHandler_zoomTime = SBW_ClientEventHandler.getDeclaredField("zoomTime");
                SBW_VehicleEntity = Class.forName("com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity");
                DisableHelper.MAIN_FEATURE.registerOrInBinding(player -> CompatibilityHelper.SBW_gunsIsZooming());
                DisableHelper.MAIN_FEATURE.registerOrInBinding(CompatibilityHelper::SBW_isDrivingVehicle);
            }
            catch (Exception e) {
                RealCamera.LOGGER.warn("Compatibility with SuperbWarfare is outdated: [{}] {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            }
        }
    }

    private static boolean SBW_gunsIsZooming() {
        try {
            return SBW_ClientEventHandler_zoomTime.getDouble(null) > 0.0;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private static boolean SBW_isDrivingVehicle(Player player) {
        try {
            Entity vehicle = player.getVehicle();
            return vehicle != null && SBW_VehicleEntity.isAssignableFrom(vehicle.getClass());
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static void NEA_setDeltaTick(float deltaTick) {
        if (NEA_playerTransformer_setDeltaTick != null) {
            try {
                Object INSTANCE = NEA_NEAnimationsLoader_INSTANCE.get(null);
                Object playerTransformer = NEA_NEAnimationsLoader_playerTransformer.get(INSTANCE);
                NEA_playerTransformer_setDeltaTick.invoke(playerTransformer, Float.valueOf(deltaTick));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void forceSetCameraPos(Camera camera) {
        if (RealCameraCore.isActive() && !ConfigFile.config().isClassic()) {
            ((CameraAccessor)camera).invokeSetPosition(RealCameraCore.getCameraPos(camera.getPosition()));
        }
    }

    public static boolean isModLoaded(String modId) {
        return platformHelper.isModLoaded(modId);
    }
}

