/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.compat;

import com.mojang.blaze3d.vertex.PoseStack;
import com.xtracr.realcamera.api.BindResult;
import com.xtracr.realcamera.api.RealCameraAPI;
import com.xtracr.realcamera.config.ConfigFile;
import com.xtracr.realcamera.mixin.accessor.PlayerRendererAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class LegacyBindingMode {
    public static void register() {
        RealCameraAPI.registerFunction(100, LegacyBindingMode::computeBindResult);
    }

    private static BindResult computeBindResult(Minecraft client, float deltaTick) {
        Direction direction;
        if (!ConfigFile.config().legacyBindingMode()) {
            return BindResult.EMPTY;
        }
        PoseStack poseStack = new PoseStack();
        LocalPlayer player = client.player;
        PlayerRenderer playerRenderer = (PlayerRenderer)client.getEntityRenderDispatcher().getRenderer((Entity)player);
        PlayerRenderState renderState = (PlayerRenderState)playerRenderer.createRenderState((Entity)player, deltaTick);
        Vec3 renderOffset = playerRenderer.getRenderOffset(renderState);
        poseStack.translate(renderOffset.x(), renderOffset.y(), renderOffset.z());
        if (renderState.hasPose(Pose.SLEEPING) && (direction = renderState.bedOrientation) != null) {
            float f = renderState.eyeHeight - 0.1f;
            poseStack.translate((float)(-direction.getStepX()) * f, 0.0f, (float)(-direction.getStepZ()) * f);
        }
        float g = renderState.scale;
        poseStack.scale(g, g, g);
        ((PlayerRendererAccessor)playerRenderer).invokeSetupRotations(renderState, poseStack, renderState.bodyRot, g);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        ((PlayerRendererAccessor)playerRenderer).invokeScale(renderState, poseStack);
        poseStack.translate(0.0f, -1.501f, 0.0f);
        ((PlayerModel)playerRenderer.getModel()).setupAnim(renderState);
        ((PlayerModel)playerRenderer.getModel()).head.translateAndRotate(poseStack);
        Vector4f offset = poseStack.last().pose().transform(new Vector4f(0.0f, -0.125f, -0.2f, 1.0f));
        BindResult result = BindResult.getOrCreate("LEGACY_MODE");
        result.setPosition(new Vec3((double)offset.x(), (double)offset.y(), (double)offset.z()));
        poseStack.scale(1.0f, -1.0f, -1.0f);
        result.setForward(new Vec3(poseStack.last().normal().getColumn(2, new Vector3f())));
        result.setUpward(new Vec3(poseStack.last().normal().getColumn(1, new Vector3f())));
        return result;
    }
}

