/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.compat;

import com.mojang.blaze3d.vertex.PoseStack;
import com.xtracr.realcamera.api.BindResult;
import com.xtracr.realcamera.api.RealCameraAPI;
import com.xtracr.realcamera.config.BindTarget;
import com.xtracr.realcamera.config.ConfigFile;
import com.xtracr.realcamera.util.BuiltIterableBuffer;
import com.xtracr.realcamera.util.MultiVertexCatcher;
import com.xtracr.realcamera.util.VertexData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class YSMCompat {
    private static final Map<BindTarget, BindResult> resultMap = new HashMap<BindTarget, BindResult>();
    private static final TransformedVertexRecorder[] transformedRecorders = new TransformedVertexRecorder[4];
    private static BindResult bindResult = BindResult.EMPTY;
    private static boolean allCached = false;

    public static void register() {
        RealCameraAPI.registerFunction(-100, YSMCompat::computeBindResult);
    }

    private static BindResult computeBindResult(Minecraft client, float deltaTick) {
        MultiVertexCatcher catcher;
        resultMap.clear();
        bindResult = BindResult.EMPTY;
        allCached = true;
        Entity entity = client.getCameraEntity();
        EntityRenderDispatcher dispatcher = client.getEntityRenderDispatcher();
        PoseStack poseStack = new PoseStack();
        for (TransformedVertexRecorder transformedRecorder : transformedRecorders) {
            poseStack.pushPose();
            poseStack.mulPose((Matrix4fc)transformedRecorder.matrix4f.invert(new Matrix4f()));
            catcher = MultiVertexCatcher.defaultImpl();
            dispatcher.render(entity, 0.0, 0.0, 0.0, deltaTick, poseStack, (MultiBufferSource)catcher, dispatcher.getPackedLightCoords(entity, deltaTick));
            catcher.endCatching(transformedRecorder::computeBindResultInCache);
            poseStack.popPose();
            if (!bindResult.available()) continue;
            return bindResult;
        }
        if (allCached) {
            return BindResult.EMPTY;
        }
        for (TransformedVertexRecorder transformedRecorder : transformedRecorders) {
            poseStack.pushPose();
            poseStack.mulPose((Matrix4fc)transformedRecorder.matrix4f.invert(new Matrix4f()));
            catcher = MultiVertexCatcher.defaultImpl();
            dispatcher.render(entity, 0.0, 0.0, 0.0, deltaTick, poseStack, (MultiBufferSource)catcher, dispatcher.getPackedLightCoords(entity, deltaTick));
            catcher.endCatching(transformedRecorder::computeBindResult);
            poseStack.popPose();
            if (!bindResult.available()) continue;
            return bindResult;
        }
        return BindResult.EMPTY;
    }

    static {
        float pitch = 1.9106332f;
        float yaw = 2.0943952f;
        YSMCompat.transformedRecorders[0] = new TransformedVertexRecorder();
        YSMCompat.transformedRecorders[1] = new TransformedVertexRecorder().setRotation(1.9106332f, 0.0f);
        YSMCompat.transformedRecorders[2] = new TransformedVertexRecorder().setRotation(1.9106332f, 2.0943952f);
        YSMCompat.transformedRecorders[3] = new TransformedVertexRecorder().setRotation(1.9106332f, 4.1887903f);
    }

    protected static class TransformedVertexRecorder {
        protected final Matrix4f matrix4f = new Matrix4f();
        protected final Matrix3f matrix3f = new Matrix3f();

        protected TransformedVertexRecorder() {
        }

        public TransformedVertexRecorder setRotation(float pitch, float yaw) {
            this.matrix4f.rotationYXZ(yaw, pitch, 0.0f).invert();
            this.matrix3f.rotationYXZ(yaw, pitch, 0.0f).invert();
            return this;
        }

        public void computeBindResultInCache(BuiltIterableBuffer builtBuffer) {
            if (bindResult.available()) {
                return;
            }
            for (BindTarget target : ConfigFile.config().getBindTargetList()) {
                VertexData[][] primitives;
                BindResult result = resultMap.computeIfAbsent(target, k -> new BindResult(target, false));
                if (!builtBuffer.textureId().contains(result.target.textureId())) continue;
                BindTarget.TargetConfig config = result.target.targetConfig();
                VertexData.UV posUV = new VertexData.UV(config.posU(), config.posV());
                VertexData.UV forwardUV = new VertexData.UV(config.forwardU(), config.forwardV());
                VertexData.UV upwardUV = new VertexData.UV(config.upwardU(), config.upwardV());
                if (builtBuffer.anyNotCached(new VertexData.UV[]{posUV, forwardUV, upwardUV})) {
                    allCached = false;
                }
                if (result.getPosition() != Vec3.ZERO) {
                    posUV = null;
                }
                if (result.getForward() != Vec3.ZERO) {
                    forwardUV = null;
                }
                if (result.getUpward() != Vec3.ZERO) {
                    upwardUV = null;
                }
                if ((primitives = builtBuffer.findPrimitivesInCache(new VertexData.UV[]{posUV, forwardUV, upwardUV}))[0] != null) {
                    result.setPosition(new Vec3(VertexData.position(primitives[0], config.posU(), config.posV()).toVector3f().mulPosition((Matrix4fc)this.matrix4f)));
                }
                if (primitives[1] != null) {
                    result.setForward(new Vec3(VertexData.normal(primitives[1]).toVector3f().mul((Matrix3fc)this.matrix3f)));
                }
                if (primitives[2] != null) {
                    result.setUpward(new Vec3(VertexData.normal(primitives[2]).toVector3f().mul((Matrix3fc)this.matrix3f)));
                }
                if (!result.available()) continue;
                bindResult = result;
                return;
            }
        }

        public void computeBindResult(BuiltIterableBuffer builtBuffer) {
            if (bindResult.available()) {
                return;
            }
            for (BindTarget target : ConfigFile.config().getBindTargetList()) {
                VertexData.UV upwardUV;
                VertexData.UV forwardUV;
                BindResult result = resultMap.computeIfAbsent(target, k -> new BindResult(target, false));
                if (!builtBuffer.textureId().contains(result.target.textureId())) continue;
                BindTarget.TargetConfig config = result.target.targetConfig();
                VertexData.UV posUV = result.getPosition() == Vec3.ZERO ? new VertexData.UV(config.posU(), config.posV()) : null;
                VertexData[][] primitives = builtBuffer.findPrimitives(new VertexData.UV[]{posUV, forwardUV = result.getForward() == Vec3.ZERO ? new VertexData.UV(config.forwardU(), config.forwardV()) : null, upwardUV = result.getUpward() == Vec3.ZERO ? new VertexData.UV(config.upwardU(), config.upwardV()) : null});
                if (primitives[0] != null) {
                    result.setPosition(new Vec3(VertexData.position(primitives[0], config.posU(), config.posV()).toVector3f().mulPosition((Matrix4fc)this.matrix4f)));
                }
                if (primitives[1] != null) {
                    result.setForward(new Vec3(VertexData.normal(primitives[1]).toVector3f().mul((Matrix3fc)this.matrix3f)));
                }
                if (primitives[2] != null) {
                    result.setUpward(new Vec3(VertexData.normal(primitives[2]).toVector3f().mul((Matrix3fc)this.matrix3f)));
                }
                if (!result.available()) continue;
                bindResult = result;
                return;
            }
        }
    }
}

