/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.gui;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.xtracr.realcamera.gui.GUIHelper;
import com.xtracr.realcamera.util.MathUtil;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public record ColoredFloatLineRenderState(RenderPipeline pipeline, TextureSetup textureSetup, Matrix3x2f pose, float x, float y, float z, float vectorX, float vectorY, float vectorZ, int argb, @Nullable ScreenRectangle scissorArea, @Nullable ScreenRectangle bounds) implements GuiElementRenderState
{
    public ColoredFloatLineRenderState(RenderPipeline pipeline, TextureSetup textureSetup, Matrix3x2f pose, float x, float y, float z, float vectorX, float vectorY, float vectorZ, int argb, @Nullable ScreenRectangle scissorArea) {
        this(pipeline, textureSetup, pose, x, y, z, vectorX, vectorY, vectorZ, argb, scissorArea, GUIHelper.getBounds((int)MathUtil.floor(x, x + vectorX), (int)MathUtil.floor(y, y + vectorY), (int)MathUtil.ceil(x, x + vectorX), (int)MathUtil.ceil(x, x + vectorX), pose, scissorArea));
    }

    public void buildVertices(VertexConsumer vertexConsumer, float depth) {
        Vector2f vec = this.pose.transformPosition(this.vectorX, this.vectorY, new Vector2f());
        if (this.pipeline.getVertexFormatMode().primitiveLength == 2) {
            vertexConsumer.addVertexWith2DPose(this.pose, this.x, this.y, this.z + depth).setColor(this.argb).setNormal(vec.x(), vec.y(), this.vectorZ);
            vertexConsumer.addVertexWith2DPose(this.pose, this.x + this.vectorX, this.y + this.vectorY, this.z + this.vectorZ + depth).setColor(this.argb).setNormal(vec.x(), vec.y(), this.vectorZ);
        } else {
            Vector2f start = this.pose.transformPosition(this.x, this.y, new Vector2f());
            Vector2f end = start.add((Vector2fc)vec, new Vector2f());
            Vector2f normal = vec.normalize(new Vector2f()).mul(0.5f);
            vertexConsumer.addVertex(start.x() - normal.y(), start.y() + normal.x(), this.z + depth).setColor(this.argb);
            vertexConsumer.addVertex(end.x() - normal.y(), end.y() + normal.x(), this.z + this.vectorZ + depth).setColor(this.argb);
            vertexConsumer.addVertex(end.x() + normal.y(), end.y() - normal.x(), this.z + this.vectorZ + depth).setColor(this.argb);
            vertexConsumer.addVertex(start.x() + normal.y(), start.y() - normal.x(), this.z + depth).setColor(this.argb);
        }
    }
}

