/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.gui;

import com.xtracr.realcamera.gui.ColoredFloatLineRenderState;
import com.xtracr.realcamera.gui.ColoredFloatQuadRenderState;
import com.xtracr.realcamera.gui.ColoredFloatRectangleRenderState;
import com.xtracr.realcamera.mixin.accessor.GuiGraphicAccessor;
import com.xtracr.realcamera.util.VertexData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

public class GUIHelper {
    @Nullable
    public static ScreenRectangle getBounds(int x0, int y0, int x1, int y1, Matrix3x2f pose, @Nullable ScreenRectangle scissorArea) {
        ScreenRectangle scissorArea2 = new ScreenRectangle(x0, y0, x1 - x0, y1 - y0).transformMaxBounds(pose);
        return scissorArea != null ? scissorArea.intersection(scissorArea2) : scissorArea2;
    }

    public static void enableScissor(GuiGraphics graphics, ScreenRectangle rectangle) {
        graphics.enableScissor(rectangle.left(), rectangle.top(), rectangle.right(), rectangle.bottom());
    }

    public static void fill(GuiGraphics graphics, float x0, float y0, float x1, float y1, int argb) {
        GUIHelper.fill(graphics, x0, y0, x1, y1, 0.0f, argb);
    }

    public static void fill(GuiGraphics graphics, float x0, float y0, float x1, float y1, float z, int argb) {
        ((GuiGraphicAccessor)graphics).getGuiRenderState().submitGuiElement((GuiElementRenderState)new ColoredFloatRectangleRenderState(RenderPipelines.GUI, TextureSetup.noTexture(), new Matrix3x2f((Matrix3x2fc)graphics.pose()), x0, y0, x1, y1, z, argb, ((GuiGraphicAccessor)graphics).getScissorStack().peek()));
    }

    public static void renderOutline(GuiGraphics graphics, float x, float y, float width, float height, int argb) {
        GUIHelper.fill(graphics, x, y, x + width, y + 1.0f, argb);
        GUIHelper.fill(graphics, x, y + height - 1.0f, x + width, y + height, argb);
        GUIHelper.fill(graphics, x, y + 1.0f, x + 1.0f, y + height - 1.0f, argb);
        GUIHelper.fill(graphics, x + width - 1.0f, y + 1.0f, x + width, y + height - 1.0f, argb);
    }

    public static void renderPolygon(GuiGraphics graphics, VertexData[] polygon, float z, int argb) {
        if (polygon.length < 3) {
            return;
        }
        float x0 = polygon[0].x();
        float y0 = polygon[0].y();
        float x1 = polygon[1].x();
        float y1 = polygon[1].y();
        float x2 = polygon[2].x();
        float y2 = polygon[2].y();
        float x3 = polygon.length > 3 ? polygon[3].x() : x2;
        float y3 = polygon.length > 3 ? polygon[3].y() : y2;
        ((GuiGraphicAccessor)graphics).getGuiRenderState().submitGuiElement((GuiElementRenderState)new ColoredFloatQuadRenderState(RenderPipelines.GUI, TextureSetup.noTexture(), new Matrix3x2f((Matrix3x2fc)graphics.pose()), x0, y0, z, x1, y1, z, x2, y2, z, x3, y3, z, argb, ((GuiGraphicAccessor)graphics).getScissorStack().peek()));
    }

    public static void renderVector(GuiGraphics graphics, Vec3 start, Vec3 vector, float z, int argb) {
        ((GuiGraphicAccessor)graphics).getGuiRenderState().submitGuiElement((GuiElementRenderState)new ColoredFloatLineRenderState(RenderPipelines.GUI, TextureSetup.noTexture(), new Matrix3x2f((Matrix3x2fc)graphics.pose()), (float)start.x(), (float)start.y(), z, (float)vector.x(), (float)vector.y(), 0.0f, argb, ((GuiGraphicAccessor)graphics).getScissorStack().peek()));
    }
}

