/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.gui;

import com.google.common.collect.ImmutableSortedMap;
import com.mojang.blaze3d.platform.InputConstants;
import com.xtracr.realcamera.RealCameraCore;
import com.xtracr.realcamera.compat.CompatibilityHelper;
import com.xtracr.realcamera.config.BindTarget;
import com.xtracr.realcamera.config.ConfigFile;
import com.xtracr.realcamera.config.ConfigScreen;
import com.xtracr.realcamera.gui.CyclingTexturedButton;
import com.xtracr.realcamera.gui.DoubleSlider;
import com.xtracr.realcamera.gui.GUIHelper;
import com.xtracr.realcamera.gui.ModelAnalyser;
import com.xtracr.realcamera.gui.NumberField;
import com.xtracr.realcamera.gui.TexturedButton;
import com.xtracr.realcamera.util.LocUtil;
import com.xtracr.realcamera.util.MathUtil;
import com.xtracr.realcamera.util.VertexData;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedMap;
import java.util.Set;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ModelViewScreen
extends Screen {
    public final ModelAnalyser analyser = new ModelAnalyser();
    protected int xSize = 450;
    protected int ySize = 206;
    protected int middleWidth = this.xSize - 200;
    protected int widgetWidth = (this.xSize - this.middleWidth) / 4 - 8;
    protected int widgetHeight = 18;
    protected int x;
    protected int y;
    protected int page = 0;
    protected InputConstants.Key modifierKey = ConfigFile.config().getScreenModifierKey();
    private boolean initialized;
    private int modelScale = 80;
    private int textureScale = 80;
    private int layers = 0;
    private int selectionRadius = 10;
    private double modelX;
    private double modelY;
    private double textureX;
    private double textureY;
    private double clickedX = -1.0;
    private double clickedY = -1.0;
    private float xRot;
    private float yRot;
    private String focusedTextureId;
    private ScreenRectangle modelViewArea;
    @Nullable
    private ScreenRectangle textureViewArea;
    private VertexData[][] focusedPolyhedron = new VertexData[0][];
    private List<BindTarget.DisableConfig> configsInClipBoard = new ArrayList<BindTarget.DisableConfig>();
    @Nullable
    private UVRectangleWidget focusedRectWidget;
    private StringWidget rectWidgetsSizeWidget;
    private EditBox textureIdField;
    private EditBox nameField;
    private EditBox disabledNameField;
    private EditBox disabledIdField;
    private NumberField<Integer> priorityField;
    private NumberField<Integer> focusedRectWidgetNumberField;
    private NumberField<Float> forwardUField;
    private NumberField<Float> forwardVField;
    private NumberField<Float> upwardUField;
    private NumberField<Float> upwardVField;
    private NumberField<Float> posUField;
    private NumberField<Float> posVField;
    private NumberField<Float> uMinField;
    private NumberField<Float> vMinField;
    private NumberField<Float> uMaxField;
    private NumberField<Float> vMaxField;
    private NumberField<Float> offsetXField;
    private NumberField<Float> offsetYField;
    private NumberField<Float> offsetZField;
    private NumberField<Float> offsetPitchField;
    private NumberField<Float> offsetYawField;
    private NumberField<Float> offsetRollField;
    private NumberField<Float> scaleField;
    private NumberField<Float> depthField;
    private final List<BindTarget.DisableConfig> disableConfigs = new ArrayList<BindTarget.DisableConfig>();
    private final List<UVRectangleWidget> rectWidgets = new ArrayList<UVRectangleWidget>();
    private final Map<String, Set<String>> hiddenNameMap = new HashMap<String, Set<String>>();
    private final Map<Integer, String> toggleConfigMap = Map.of(0, "disable", 1, "preview", 2, "configs");
    private final CyclingTexturedButton showTextureButton = new CyclingTexturedButton(48, 16, 0, 2).setOnValueChange(i -> this.initWidgets(this.page));
    private final CyclingTexturedButton pauseButton = new CyclingTexturedButton(0, 16, 0, 2);
    private final CyclingTexturedButton bindXButton = new CyclingTexturedButton(16, 16, 1, 2);
    private final CyclingTexturedButton bindYButton = new CyclingTexturedButton(16, 16, 0, 2);
    private final CyclingTexturedButton bindZButton = new CyclingTexturedButton(16, 16, 1, 2);
    private final CyclingTexturedButton bindRotButton = new CyclingTexturedButton(16, 16, 1, 2);
    private final DoubleSlider entityPitchSlider = this.createSlider("pitch", this.widgetWidth * 2 + 4, -90.0, 90.0);
    private final DoubleSlider entityYawSlider = this.createSlider("yaw", this.widgetWidth * 2 + 4, -60.0, 60.0);
    private final DoubleSlider offsetXSlider = this.createSlider("offsetX", this.widgetWidth * 2 - 18, -1.0, 1.0);
    private final DoubleSlider offsetYSlider = this.createSlider("offsetY", this.widgetWidth * 2 - 18, -1.0, 1.0);
    private final DoubleSlider offsetZSlider = this.createSlider("offsetZ", this.widgetWidth * 2 - 18, -1.0, 1.0);
    private final DoubleSlider offsetPitchSlider = this.createSlider("pitch", this.widgetWidth * 2 - 18, -180.0, 180.0);
    private final DoubleSlider offsetYawSlider = this.createSlider("yaw", this.widgetWidth * 2 - 18, -180.0, 180.0);
    private final DoubleSlider offsetRollSlider = this.createSlider("roll", this.widgetWidth * 2 - 18, -180.0, 180.0);
    private final CycleButton<Integer> selectingButton = this.createCyclingButton((SequencedMap<Integer, Component>)ImmutableSortedMap.of((Comparable)Integer.valueOf(0), (Object)LocUtil.MODEL_VIEW_WIDGET("forwardVector", new Object[0]).withStyle(ChatFormatting.GREEN), (Comparable)Integer.valueOf(1), (Object)LocUtil.MODEL_VIEW_WIDGET("upwardVector", new Object[0]).withStyle(ChatFormatting.RED), (Comparable)Integer.valueOf(2), (Object)LocUtil.MODEL_VIEW_WIDGET("position", new Object[0]).withStyle(ChatFormatting.BLUE)), this.widgetWidth * 2 + 4, (Component)LocUtil.MODEL_VIEW_WIDGET("selecting", new Object[0]), (OptionInstance.TooltipSupplier<Integer>)((OptionInstance.TooltipSupplier)i -> this.createTooltip("selecting", this.modifierKey.getDisplayName(), this.modifierKey.getDisplayName())));
    private final CycleButton<Integer> disableModeButton = this.createCyclingButton((SequencedMap<Integer, Component>)ImmutableSortedMap.of((Comparable)Integer.valueOf(0), (Object)LocUtil.MODEL_VIEW_WIDGET("all", new Object[0]).withStyle(ChatFormatting.GREEN), (Comparable)Integer.valueOf(1), (Object)LocUtil.MODEL_VIEW_WIDGET("part", new Object[0]).withStyle(ChatFormatting.BLUE)), this.widgetWidth * 2 + 4, (Component)LocUtil.MODEL_VIEW_WIDGET("disableMode", new Object[0]), (OptionInstance.TooltipSupplier<Integer>)((OptionInstance.TooltipSupplier)i -> this.createTooltip("disableMode", this.modifierKey.getDisplayName())));
    private final CycleButton<Integer> selectionModeButton = this.createCyclingButton((SequencedMap<Integer, Component>)ImmutableSortedMap.of((Comparable)Integer.valueOf(0), (Object)LocUtil.MODEL_VIEW_WIDGET("single", new Object[0]), (Comparable)Integer.valueOf(1), (Object)LocUtil.MODEL_VIEW_WIDGET("multiple", new Object[0]), (Comparable)Integer.valueOf(2), (Object)LocUtil.MODEL_VIEW_WIDGET("range", new Object[0]).withStyle(ChatFormatting.BLUE)), this.widgetWidth * 2 + 4, (Component)LocUtil.MODEL_VIEW_WIDGET("selectionMode", new Object[0]), (OptionInstance.TooltipSupplier<Integer>)((OptionInstance.TooltipSupplier)i -> this.createTooltip("selectionMode", this.modifierKey.getDisplayName(), this.modifierKey.getDisplayName())));
    private final CycleButton<Integer> toggleSliderButton = this.createCyclingButton((SequencedMap<Integer, Component>)ImmutableSortedMap.of((Comparable)Integer.valueOf(0), (Object)LocUtil.MODEL_VIEW_WIDGET("toggleSliderToField", new Object[0]), (Comparable)Integer.valueOf(1), (Object)LocUtil.MODEL_VIEW_WIDGET("toggleFieldToSlider", new Object[0])), this.widgetWidth * 2 + 4, (OptionInstance.TooltipSupplier<Integer>)((OptionInstance.TooltipSupplier)i -> null), (CycleButton.OnValueChange<Integer>)((CycleButton.OnValueChange)(button, i) -> {
        if (i == 1) {
            this.offsetXField.setNumber(Float.valueOf((float)this.offsetXSlider.getValue()));
            this.offsetYField.setNumber(Float.valueOf((float)this.offsetYSlider.getValue()));
            this.offsetZField.setNumber(Float.valueOf((float)this.offsetZSlider.getValue()));
            this.offsetPitchField.setNumber(Float.valueOf((float)this.offsetPitchSlider.getValue()));
            this.offsetYawField.setNumber(Float.valueOf((float)this.offsetYawSlider.getValue()));
            this.offsetRollField.setNumber(Float.valueOf((float)this.offsetRollSlider.getValue()));
        } else {
            this.offsetXSlider.setValue(this.offsetXField.getNumber().floatValue());
            this.offsetYSlider.setValue(this.offsetYField.getNumber().floatValue());
            this.offsetZSlider.setValue(this.offsetZField.getNumber().floatValue());
            this.offsetPitchSlider.setValue(this.offsetPitchField.getNumber().floatValue());
            this.offsetYawSlider.setValue(this.offsetYawField.getNumber().floatValue());
            this.offsetRollSlider.setValue(this.offsetRollField.getNumber().floatValue());
        }
        this.initWidgets(this.page);
    }));
    private final CycleButton<Integer> toggleCategoryButton = this.createCyclingButton((SequencedMap<Integer, Component>)ImmutableSortedMap.of((Comparable)Integer.valueOf(0), (Object)LocUtil.MODEL_VIEW_WIDGET(this.toggleConfigMap.get(0), new Object[0]), (Comparable)Integer.valueOf(1), (Object)LocUtil.MODEL_VIEW_WIDGET(this.toggleConfigMap.get(1), new Object[0]), (Comparable)Integer.valueOf(2), (Object)LocUtil.MODEL_VIEW_WIDGET(this.toggleConfigMap.get(2), new Object[0])), this.widgetWidth * 2 - 18, (OptionInstance.TooltipSupplier<Integer>)((OptionInstance.TooltipSupplier)i -> this.createTooltip(this.toggleConfigMap.get(i), new Object[0])), (CycleButton.OnValueChange<Integer>)((CycleButton.OnValueChange)(button, i) -> this.initWidgets(0)));

    public ModelViewScreen() {
        super((Component)LocUtil.MODEL_VIEW_TITLE());
    }

    protected void init() {
        super.init();
        this.x = (this.width - this.xSize) / 2;
        this.y = (this.height - this.ySize) / 2;
        this.modifierKey = ConfigFile.config().getScreenModifierKey();
        this.initWidgets(this.page);
        if (!this.initialized) {
            this.loadBindTarget(RealCameraCore.currentTarget());
        }
        this.initialized = true;
    }

    private void initWidgets(int page) {
        this.page = page;
        if ((Integer)this.toggleCategoryButton.getValue() == 1 && this.showTextureButton.getValue() == 0) {
            this.modelViewArea = new ScreenRectangle(this.x + this.xSize / 2, this.y, this.middleWidth / 2, this.ySize);
            this.textureViewArea = new ScreenRectangle(this.x + (this.xSize - this.middleWidth) / 2, this.y, this.middleWidth / 2, this.ySize);
        } else {
            this.modelViewArea = new ScreenRectangle(this.x + (this.xSize - this.middleWidth) / 2, this.y, this.middleWidth, this.ySize);
            this.textureViewArea = null;
            if (this.focusedRectWidget != null && this.focusedRectWidget.isFocused()) {
                this.setFocused(null);
            }
            this.focusedRectWidget = null;
        }
        this.clearWidgets();
        this.initLeftWidgets();
        if (this.textureViewArea != null) {
            this.rectWidgets.forEach(x$0 -> {
                UVRectangleWidget cfr_ignored_0 = (UVRectangleWidget)this.addRenderableWidget((GuiEventListener)x$0);
            });
        }
        if ((Integer)this.toggleCategoryButton.getValue() == 1) {
            ((CyclingTexturedButton)this.addRenderableWidget((GuiEventListener)this.showTextureButton)).setPosition(this.x + (this.xSize - this.middleWidth) / 2 + 4, this.y + 4);
        }
        ((CyclingTexturedButton)this.addRenderableWidget((GuiEventListener)this.pauseButton)).setPosition(this.x + (this.xSize + this.middleWidth) / 2 - 38, this.y + 4);
        this.addRenderableWidget((GuiEventListener)new TexturedButton(this.x + (this.xSize + this.middleWidth) / 2 - 20, this.y + 4, 16, 16, 0, 0, button -> {
            this.textureScale = 80;
            this.modelScale = 80;
            this.entityYawSlider.setValue(0.0);
            this.entityPitchSlider.setValue(0.0);
            this.textureY = 0.0;
            this.textureX = 0.0;
            this.modelY = 0.0;
            this.modelX = 0.0;
            this.yRot = 0.0f;
            this.xRot = 0.0f;
            this.layers = 0;
        }));
        this.initRightWidgets();
    }

    private void initLeftWidgets() {
        this.rectWidgetsSizeWidget = new StringWidget(this.x + 4 + this.widgetWidth + 5, this.y + 4 + (this.widgetHeight + 2) * 3, this.widgetWidth - 22, this.widgetHeight, (Component)LocUtil.literal(String.valueOf(this.rectWidgets.size())), this.font);
        this.forwardUField = this.createFloatField(this.widgetWidth, 0.0f, this.forwardUField);
        this.forwardVField = this.createFloatField(this.widgetWidth, 0.0f, this.forwardVField);
        this.upwardUField = this.createFloatField(this.widgetWidth, 0.0f, this.upwardUField);
        this.upwardVField = this.createFloatField(this.widgetWidth, 0.0f, this.upwardVField);
        this.posUField = this.createFloatField(this.widgetWidth, 0.0f, this.posUField);
        this.posVField = this.createFloatField(this.widgetWidth, 0.0f, this.posVField);
        this.textureIdField = this.createTextField(this.widgetWidth * 2 + 4, 1024, this.textureIdField);
        this.disabledIdField = this.createTextField(this.widgetWidth * 2 + 4, 1024, this.disabledIdField);
        this.focusedRectWidgetNumberField = NumberField.ofInt(this.font, this.widgetWidth - 2, this.widgetHeight - 2, 0, this.focusedRectWidgetNumberField).setMin(0).setMax(this.rectWidgets.size());
        this.uMinField = this.createFloatField(this.widgetWidth * 2 - 24, 0.0f, this.uMinField).setMin(Float.valueOf(-1.0f)).setMax(Float.valueOf(2.0f));
        this.uMaxField = this.createFloatField(this.widgetWidth * 2 - 24, 0.0f, this.uMaxField).setMin(Float.valueOf(-1.0f)).setMax(Float.valueOf(2.0f));
        this.vMinField = this.createFloatField(this.widgetWidth * 2 - 24, 0.0f, this.vMinField).setMin(Float.valueOf(-1.0f)).setMax(Float.valueOf(2.0f));
        this.vMaxField = this.createFloatField(this.widgetWidth * 2 - 24, 0.0f, this.vMaxField).setMin(Float.valueOf(-1.0f)).setMax(Float.valueOf(2.0f));
        this.offsetXField = this.createFloatField(this.widgetWidth * 2 - 20, 0.0f, this.offsetXField).setMin(Float.valueOf(-1.0f)).setMax(Float.valueOf(1.0f));
        this.offsetYField = this.createFloatField(this.widgetWidth * 2 - 20, 0.0f, this.offsetYField).setMin(Float.valueOf(-1.0f)).setMax(Float.valueOf(1.0f));
        this.offsetZField = this.createFloatField(this.widgetWidth * 2 - 20, 0.0f, this.offsetZField).setMin(Float.valueOf(-1.0f)).setMax(Float.valueOf(1.0f));
        this.offsetPitchField = this.createFloatField(this.widgetWidth * 2 - 20, 0.0f, this.offsetPitchField).setMin(Float.valueOf(-180.0f)).setMax(Float.valueOf(180.0f));
        this.offsetYawField = this.createFloatField(this.widgetWidth * 2 - 20, 0.0f, this.offsetYawField).setMin(Float.valueOf(-180.0f)).setMax(Float.valueOf(180.0f));
        this.offsetRollField = this.createFloatField(this.widgetWidth * 2 - 20, 0.0f, this.offsetRollField).setMin(Float.valueOf(-180.0f)).setMax(Float.valueOf(180.0f));
        this.scaleField = this.createFloatField(this.widgetWidth, 1.0f, this.scaleField).setMax(Float.valueOf(64.0f));
        this.depthField = this.createFloatField(this.widgetWidth, 0.2f, this.depthField).setMax(Float.valueOf(16.0f));
        GridLayout grid = new GridLayout();
        grid.defaultCellSetting().padding(4, 2, 0, 0);
        LayoutSettings smallSettings = grid.newCellSettings().padding(5, 3, 1, 1);
        GridLayout.RowHelper rows = grid.createRowHelper(2);
        if ((Integer)this.toggleCategoryButton.getValue() == 0) {
            ((Button)rows.addChild((LayoutElement)this.createButton((Component)LocUtil.MODEL_VIEW_WIDGET("import", new Object[0]), this.widgetWidth, this::importBindTarget))).setTooltip(this.createTooltip("import", new Object[0]));
            ((Button)rows.addChild((LayoutElement)this.createButton((Component)LocUtil.MODEL_VIEW_WIDGET("export", new Object[0]), this.widgetWidth, this::exportBindTarget))).setTooltip(this.createTooltip("export", new Object[0]));
            rows.addChild((LayoutElement)this.entityPitchSlider, 2);
            rows.addChild((LayoutElement)this.entityYawSlider, 2);
            rows.addChild(this.selectingButton, 2);
            rows.addChild(this.forwardUField, smallSettings);
            rows.addChild(this.forwardVField, smallSettings);
            rows.addChild(this.upwardUField, smallSettings);
            rows.addChild(this.upwardVField, smallSettings);
            rows.addChild(this.posUField, smallSettings);
            rows.addChild(this.posVField, smallSettings);
            ((EditBox)rows.addChild((LayoutElement)this.textureIdField, 2, smallSettings)).setTooltip(this.createTooltip("textureId", new Object[0]));
        } else if ((Integer)this.toggleCategoryButton.getValue() == 1) {
            LayoutSettings offsetXSettings = grid.newCellSettings().padding(-13, 3, 1, 1);
            rows.addChild(this.disableModeButton, 2);
            ((EditBox)rows.addChild((LayoutElement)this.disabledIdField, 2, smallSettings)).setTooltip(this.createTooltip("textureId", new Object[0]));
            rows.addChild(this.selectionModeButton, 2);
            ((NumberField)rows.addChild(this.focusedRectWidgetNumberField, smallSettings)).setOnValueChange(index -> {
                if (index == 0) {
                    this.focusedRectWidget = null;
                } else if (index > 0 && index <= this.rectWidgets.size()) {
                    this.focusedRectWidget = this.rectWidgets.get(index - 1);
                    this.uMinField.setNumber(Float.valueOf(this.focusedRectWidget.uMin));
                    this.vMinField.setNumber(Float.valueOf(this.focusedRectWidget.vMin));
                    this.uMaxField.setNumber(Float.valueOf(this.focusedRectWidget.uMax));
                    this.vMaxField.setNumber(Float.valueOf(this.focusedRectWidget.vMax));
                }
            }).setTooltip(this.createTooltip("focusedRectangleNumber", new Object[0]));
            this.addRenderableWidget((GuiEventListener)new StringWidget(this.x + 4 + this.widgetWidth + 3, this.y + 4 + (this.widgetHeight + 2) * 3, 6, this.widgetHeight, (Component)LocUtil.literal("/"), this.font));
            this.addRenderableWidget((GuiEventListener)this.rectWidgetsSizeWidget);
            ((TexturedButton)rows.addChild((LayoutElement)new TexturedButton(48, 0, button -> this.deleteFocusedRectWidget()), grid.newCellSettings().padding(5 + this.widgetWidth - 18, 3, 1, 1))).setTooltip(this.createTooltip("deleteSelectedRectangle", new Object[0]));
            rows.addChild((LayoutElement)new StringWidget(26, this.widgetHeight, (Component)LocUtil.literal("uMin:"), this.font));
            ((NumberField)rows.addChild(this.uMinField, offsetXSettings)).setOnValueChange(f -> {
                if (this.focusedRectWidget != null) {
                    this.focusedRectWidget.uMin = f.floatValue();
                }
            });
            rows.addChild((LayoutElement)new StringWidget(26, this.widgetHeight, (Component)LocUtil.literal("vMin:"), this.font));
            ((NumberField)rows.addChild(this.vMinField, offsetXSettings)).setOnValueChange(f -> {
                if (this.focusedRectWidget != null) {
                    this.focusedRectWidget.vMin = f.floatValue();
                }
            });
            rows.addChild((LayoutElement)new StringWidget(26, this.widgetHeight, (Component)LocUtil.literal("uMax:"), this.font));
            ((NumberField)rows.addChild(this.uMaxField, offsetXSettings)).setOnValueChange(f -> {
                if (this.focusedRectWidget != null) {
                    this.focusedRectWidget.uMax = f.floatValue();
                }
            });
            rows.addChild((LayoutElement)new StringWidget(26, this.widgetHeight, (Component)LocUtil.literal("vMax:"), this.font));
            ((NumberField)rows.addChild(this.vMaxField, offsetXSettings)).setOnValueChange(f -> {
                if (this.focusedRectWidget != null) {
                    this.focusedRectWidget.vMax = f.floatValue();
                }
            });
        } else {
            boolean useSliderOffset = (Integer)this.toggleSliderButton.getValue() == 0;
            rows.addChild(this.toggleSliderButton, 2);
            LayoutSettings sliderSettings = grid.newCellSettings().padding(-20, 2, 0, 0);
            LayoutSettings fieldSettings = grid.newCellSettings().padding(-17, 3, 1, 1);
            ((CyclingTexturedButton)rows.addChild((LayoutElement)this.bindXButton, smallSettings)).setTooltip(this.createTooltip("bindButtons", new Object[0]));
            if (useSliderOffset) {
                rows.addChild((LayoutElement)this.offsetXSlider, sliderSettings);
            } else {
                rows.addChild(this.offsetXField, fieldSettings);
            }
            ((CyclingTexturedButton)rows.addChild((LayoutElement)this.bindYButton, smallSettings)).setTooltip(this.createTooltip("bindButtons", new Object[0]));
            if (useSliderOffset) {
                rows.addChild((LayoutElement)this.offsetYSlider, sliderSettings);
            } else {
                rows.addChild(this.offsetYField, fieldSettings);
            }
            ((CyclingTexturedButton)rows.addChild((LayoutElement)this.bindZButton, smallSettings)).setTooltip(this.createTooltip("bindButtons", new Object[0]));
            if (useSliderOffset) {
                rows.addChild((LayoutElement)this.offsetZSlider, sliderSettings);
            } else {
                rows.addChild(this.offsetZField, fieldSettings);
            }
            ((CyclingTexturedButton)rows.addChild((LayoutElement)this.bindRotButton, smallSettings)).setTooltip(this.createTooltip("bindButtons", new Object[0]));
            if (useSliderOffset) {
                rows.addChild((LayoutElement)this.offsetPitchSlider, sliderSettings);
            } else {
                rows.addChild(this.offsetPitchField, fieldSettings);
            }
            if (useSliderOffset) {
                rows.addChild((LayoutElement)this.offsetYawSlider, 2, grid.newCellSettings().padding(26, 2, 0, 0));
            } else {
                rows.addChild(this.offsetYawField, 2, grid.newCellSettings().padding(29, 3, 1, 1));
            }
            rows.addChild((LayoutElement)new TexturedButton(0, 0, button -> {
                this.offsetXField.setNumber(Float.valueOf(0.0f));
                this.offsetYField.setNumber(Float.valueOf(0.0f));
                this.offsetZField.setNumber(Float.valueOf(0.0f));
                this.offsetPitchField.setNumber(Float.valueOf(0.0f));
                this.offsetYawField.setNumber(Float.valueOf(0.0f));
                this.offsetRollField.setNumber(Float.valueOf(0.0f));
                this.offsetXSlider.setValue(0.0);
                this.offsetYSlider.setValue(0.0);
                this.offsetZSlider.setValue(0.0);
                this.offsetPitchSlider.setValue(0.0);
                this.offsetYawSlider.setValue(0.0);
                this.offsetRollSlider.setValue(0.0);
            }), smallSettings);
            if (useSliderOffset) {
                rows.addChild((LayoutElement)this.offsetRollSlider, sliderSettings);
            } else {
                rows.addChild(this.offsetRollField, fieldSettings);
            }
            ((NumberField)rows.addChild(this.scaleField, smallSettings)).setTooltip(this.createTooltip("scale", new Object[0]));
            ((NumberField)rows.addChild(this.depthField, smallSettings)).setTooltip(this.createTooltip("depth", new Object[0]));
        }
        rows.addChild((LayoutElement)this.createButton((Component)LocUtil.MODEL_VIEW_WIDGET("save", new Object[0]), this.widgetWidth, button -> {
            if (this.nameField.getValue().isBlank()) {
                button.setTooltip(Tooltip.create((Component)LocUtil.MODEL_VIEW_TOOLTIP("emptyName", new Object[0]).withStyle(ChatFormatting.RED)));
                return;
            }
            button.setTooltip(null);
            BindTarget bindTarget = this.genBindTarget();
            ConfigFile.config().putBindTarget(bindTarget);
            ConfigFile.save();
            this.loadBindTarget(bindTarget);
            this.initWidgets(this.page);
        }));
        this.priorityField = NumberField.ofInt(this.font, this.widgetWidth - 2, this.widgetHeight - 2, 0, this.priorityField);
        ((NumberField)rows.addChild(this.priorityField, smallSettings)).setTooltip(this.createTooltip("priority", new Object[0]));
        this.nameField = this.createTextField(this.widgetWidth * 2 + 4, 20, this.nameField);
        ((EditBox)rows.addChild((LayoutElement)this.nameField, 2, smallSettings)).setTooltip(this.createTooltip("targetName", new Object[0]));
        grid.arrangeElements();
        FrameLayout.alignInRectangle((LayoutElement)grid, (int)this.x, (int)(this.y + 2), (int)(this.x + (this.xSize - this.middleWidth) / 2 - 4), (int)(this.y + this.ySize), (float)0.0f, (float)0.0f);
        grid.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    private void initRightWidgets() {
        int size;
        int widgetsPerPage;
        this.disabledNameField = this.createTextField(this.widgetWidth * 2 - 18, 20, this.disabledNameField);
        GridLayout grid = new GridLayout();
        grid.defaultCellSetting().padding(4, 2, 0, 0);
        LayoutSettings smallSettings = grid.newCellSettings().padding(5, 3, 1, 1);
        GridLayout.RowHelper rows = grid.createRowHelper(4);
        rows.addChild(this.toggleCategoryButton, 3);
        ((TexturedButton)rows.addChild((LayoutElement)new TexturedButton(80, 0, button -> {
            if (CompatibilityHelper.isModLoaded("cloth-config")) {
                this.minecraft.setScreen(ConfigScreen.create(this));
            }
        }), smallSettings)).setTooltip(this.createTooltip("toConfigScreen", new Object[0]));
        if ((Integer)this.toggleCategoryButton.getValue() == 1) {
            widgetsPerPage = 6;
            size = this.disableConfigs.size();
            ((Button)rows.addChild((LayoutElement)this.createButton((Component)LocUtil.MODEL_VIEW_WIDGET("copy", new Object[0]), this.widgetWidth, button -> {
                this.configsInClipBoard = List.copyOf(this.disableConfigs);
            }), 2)).setTooltip(this.createTooltip("copy", new Object[0]));
            ((Button)rows.addChild((LayoutElement)this.createButton((Component)LocUtil.MODEL_VIEW_WIDGET("paste", new Object[0]), this.widgetWidth, button -> {
                this.configsInClipBoard.stream().filter(config -> this.disableConfigs.stream().noneMatch(c -> c.name().equals(config.name()))).forEach(this.disableConfigs::add);
                this.initWidgets(0);
            }), 2)).setTooltip(this.createTooltip("paste", new Object[0]));
            ((EditBox)rows.addChild((LayoutElement)this.disabledNameField, 3, smallSettings)).setTooltip(this.createTooltip("disabledName", new Object[0]));
            ((TexturedButton)rows.addChild((LayoutElement)new TexturedButton(64, 0, button -> {
                String name = this.disabledNameField.getValue();
                String textureId = this.disabledIdField.getValue();
                if (name.isBlank()) {
                    button.setTooltip(Tooltip.create((Component)LocUtil.MODEL_VIEW_TOOLTIP("emptyName", new Object[0]).withStyle(ChatFormatting.RED)));
                } else if (textureId.isBlank()) {
                    button.setTooltip(Tooltip.create((Component)LocUtil.MODEL_VIEW_TOOLTIP("emptyTextureId", new Object[0]).withStyle(ChatFormatting.RED)));
                } else {
                    button.setTooltip(this.createTooltip("saveAs", new Object[0]));
                    BindTarget.DisableConfig disableConfig = new BindTarget.DisableConfig(name, textureId, (Integer)this.disableModeButton.getValue() == 0, (BindTarget.UVRectangle[])this.rectWidgets.stream().map(UVRectangleWidget::toUVRectangle).toArray(BindTarget.UVRectangle[]::new));
                    for (int i = 0; i < this.disableConfigs.size(); ++i) {
                        if (!this.disableConfigs.get(i).name().equals(name)) continue;
                        this.disableConfigs.set(i, disableConfig);
                        this.initWidgets(this.page);
                        return;
                    }
                    this.disableConfigs.add(disableConfig);
                    this.initWidgets(this.page);
                }
            }), smallSettings)).setTooltip(this.createTooltip("saveAs", new Object[0]));
            for (int i = this.page * widgetsPerPage; i < Math.min((this.page + 1) * widgetsPerPage, size); ++i) {
                BindTarget.DisableConfig config = this.disableConfigs.get(i);
                String targetName = this.nameField.getValue();
                Set hiddenNames = this.hiddenNameMap.computeIfAbsent(targetName, k -> new HashSet());
                ((CyclingTexturedButton)this.addRenderableWidget((GuiEventListener)new CyclingTexturedButton(32, 16, hiddenNames.contains(config.name()) ? 1 : 0, 2))).setOnValueChange(value -> {
                    if (value == 0) {
                        hiddenNames.remove(config.name());
                    } else {
                        hiddenNames.add(config.name());
                    }
                }).setPosition(this.x + (this.xSize + this.middleWidth) / 2 - 20, this.y + 5 + (this.widgetHeight + 2) * (3 + i % widgetsPerPage));
                ((Button)rows.addChild((LayoutElement)this.createButton((Component)LocUtil.literal(config.name()), this.widgetWidth * 2 - 18, button -> {
                    this.disabledNameField.setValue(config.name());
                    this.disabledIdField.setValue(config.textureId());
                    this.disableModeButton.setValue((Object)(config.disableAll() ? 0 : 1));
                    this.rectWidgets.clear();
                    for (BindTarget.UVRectangle rect : config.rectangles()) {
                        this.rectWidgets.add(this.createRectWidget(rect));
                    }
                    this.initWidgets(this.page);
                }), 3)).setTooltip(Tooltip.create((Component)LocUtil.literal(config.name())));
                rows.addChild((LayoutElement)new TexturedButton(48, 0, button -> {
                    this.disableConfigs.removeIf(disableConfig -> disableConfig.name().equals(config.name()));
                    if (this.disabledNameField.getValue().equals(config.name())) {
                        this.rectWidgets.clear();
                    }
                    this.initWidgets(this.page * widgetsPerPage > size - 2 && size > 1 ? this.page - 1 : this.page);
                }), smallSettings);
            }
        } else {
            widgetsPerPage = 8;
            List<BindTarget> fixedTargetList = ConfigFile.config().getFixedTargetList().stream().filter(target -> target.name().equals(RealCameraCore.currentTarget().name())).toList();
            List<BindTarget> targetList = ConfigFile.config().getBindTargetList();
            int fixedTargetCount = fixedTargetList.size();
            size = fixedTargetCount + targetList.size();
            for (int i = this.page * widgetsPerPage; i < Math.min((this.page + 1) * widgetsPerPage, size); ++i) {
                BindTarget target2 = i < fixedTargetCount ? fixedTargetList.get(i) : targetList.get(i - fixedTargetCount);
                String name = target2.name();
                ((Button)rows.addChild((LayoutElement)this.createButton((Component)LocUtil.literal(name), this.widgetWidth * 2 - 18, button -> this.loadBindTarget(target2)), 3)).setTooltip(Tooltip.create((Component)LocUtil.literal(name)));
                if (i < fixedTargetCount) continue;
                rows.addChild((LayoutElement)new TexturedButton(48, 0, button -> {
                    targetList.remove(target2);
                    ConfigFile.save();
                    this.initWidgets(this.page * widgetsPerPage > size - 2 && size > 1 ? this.page - 1 : this.page);
                }), smallSettings);
            }
        }
        grid.arrangeElements();
        FrameLayout.alignInRectangle((LayoutElement)grid, (int)(this.x + (this.xSize + this.middleWidth) / 2 + 4), (int)(this.y + 2), (int)(this.x + this.xSize), (int)(this.y + this.ySize), (float)0.0f, (float)0.0f);
        grid.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        int pages = (size - 1) / widgetsPerPage + 1;
        this.addRenderableWidget((GuiEventListener)new TexturedButton(this.x + (this.xSize + this.middleWidth) / 2 + 8, this.y + this.ySize - 20, 16, 16, 16, 0, button -> this.initWidgets((this.page - 1 + pages) % pages)));
        this.addRenderableWidget((GuiEventListener)new StringWidget(this.x + (this.xSize + this.middleWidth) / 2 + 30, this.y + this.ySize - 20, this.widgetWidth * 2 - 40, this.widgetHeight, (Component)LocUtil.literal(this.page + 1 + " / " + pages), this.font));
        this.addRenderableWidget((GuiEventListener)new TexturedButton(this.x + this.xSize - 21, this.y + this.ySize - 20, 16, 16, 32, 0, button -> this.initWidgets((this.page + 1) % pages)));
    }

    @NotNull
    public UVRectangleWidget addRectWidget(@NotNull UVRectangleWidget rectWidget) {
        UVRectangleWidget foundRectWidget = this.rectWidgets.stream().filter(r -> r.contains(rectWidget)).findFirst().orElse(null);
        if (foundRectWidget == null) {
            this.rectWidgets.add(rectWidget);
            this.focusedRectWidgetNumberField.setMax(this.rectWidgets.size());
            this.rectWidgetsSizeWidget.setMessage((Component)LocUtil.literal(String.valueOf(this.rectWidgets.size())));
            if (this.textureViewArea != null) {
                this.addRenderableWidget((GuiEventListener)rectWidget);
            }
            return rectWidget;
        }
        return foundRectWidget;
    }

    public boolean deleteFocusedRectWidget() {
        if (this.focusedRectWidget == null) {
            return false;
        }
        this.rectWidgets.remove((Object)this.focusedRectWidget);
        this.removeWidget((GuiEventListener)this.focusedRectWidget);
        this.focusedRectWidgetNumberField.setNumber(0);
        this.focusedRectWidgetNumberField.setMax(this.rectWidgets.size());
        this.rectWidgetsSizeWidget.setMessage((Component)LocUtil.literal(String.valueOf(this.rectWidgets.size())));
        return true;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float deltaTick) {
        super.render(graphics, mouseX, mouseY, deltaTick);
        if ((Integer)this.toggleCategoryButton.getValue() == 1 && (Integer)this.selectionModeButton.getValue() == 2 && this.inModelViewArea(mouseX, mouseY)) {
            GUIHelper.enableScissor(graphics, this.modelViewArea);
            GUIHelper.fill(graphics, mouseX - this.selectionRadius, mouseY - this.selectionRadius, mouseX + this.selectionRadius, mouseY + this.selectionRadius, 400.0f, 1328755660);
            graphics.disableScissor();
        }
        if (this.textureViewArea != null) {
            GUIHelper.enableScissor(graphics, this.textureViewArea);
            if (this.clickedX >= 0.0 && this.clickedY >= 0.0) {
                graphics.fill(Math.min((int)this.clickedX, mouseX), Math.min((int)this.clickedY, mouseY), Math.max((int)this.clickedX, mouseX), Math.max((int)this.clickedY, mouseY), 1328755660);
            }
            if ((Integer)this.disableModeButton.getValue() == 0) {
                new UVRectangleWidget(0.0f, 0.0f, 1.0f, 1.0f).renderWidget(graphics, mouseX, mouseY, deltaTick);
            }
            graphics.disableScissor();
        }
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float deltaTick) {
        super.renderBackground(graphics, mouseX, mouseY, deltaTick);
        graphics.fill(this.x, this.y, this.x + (this.xSize - this.middleWidth) / 2 - 4, this.y + this.ySize, -12303292);
        graphics.fill(this.x + (this.xSize - this.middleWidth) / 2, this.y, this.x + (this.xSize + this.middleWidth) / 2, this.y + this.ySize, -14540254);
        graphics.fill(this.x + (this.xSize + this.middleWidth) / 2 + 4, this.y, this.x + this.xSize, this.y + this.ySize, -12303292);
        this.analyser.initialize(this.genBindTarget(), this.modelScale);
        this.renderModelViewArea(graphics, (LivingEntity)this.minecraft.player);
        this.renderTextureViewArea(graphics, (LivingEntity)this.minecraft.player);
        this.applyAnalyser(graphics, mouseX, mouseY);
    }

    protected void applyAnalyser(GuiGraphics graphics, int mouseX, int mouseY) {
        String textureId = (Integer)this.toggleCategoryButton.getValue() == 0 ? "" : this.disabledIdField.getValue();
        Set<String> hiddenNames = this.hiddenNameMap.getOrDefault(this.nameField.getValue(), Set.of());
        this.analyser.applyDisableConfigs(textureId, hiddenNames);
        if ((Integer)this.toggleCategoryButton.getValue() == 1 && (Integer)this.selectionModeButton.getValue() == 2 && this.inModelViewArea(mouseX, mouseY)) {
            this.analyser.computeFocusedOnModel(mouseX - this.selectionRadius, mouseY - this.selectionRadius, mouseX + this.selectionRadius, mouseY + this.selectionRadius);
        }
        if (this.inTextureViewArea(mouseX, mouseY)) {
            this.analyser.computeFocusedOnTexture(mouseX, mouseY);
        }
        if (this.inModelViewArea(mouseX, mouseY)) {
            this.analyser.computeFocusedOnModel(mouseX, mouseY, this.layers);
        }
        if ((Integer)this.toggleCategoryButton.getValue() == 0 || (Integer)this.selectionModeButton.getValue() == 1) {
            this.analyser.computeFocusedPolyhedron();
        }
        this.focusedPolyhedron = (VertexData[][])this.analyser.focusedPolyhedron.toArray((T[])new VertexData[0][]);
        this.focusedTextureId = this.analyser.getFocusedTextureId();
        GUIHelper.enableScissor(graphics, this.modelViewArea);
        if ((Integer)this.toggleCategoryButton.getValue() != 2) {
            this.analyser.drawFocusedInModelArea(graphics);
        }
        if ((Integer)this.toggleCategoryButton.getValue() == 0) {
            this.analyser.drawBindTarget(graphics);
        } else {
            this.analyser.drawCameraDirections(graphics);
        }
        graphics.disableScissor();
        if (this.textureViewArea != null) {
            GUIHelper.enableScissor(graphics, this.textureViewArea);
            this.analyser.drawFocusedInTextureArea(graphics);
            graphics.disableScissor();
        }
    }

    protected void renderModelViewArea(GuiGraphics graphics, LivingEntity entity) {
        int x1 = this.modelViewArea.left();
        int y1 = this.modelViewArea.top();
        int x2 = this.modelViewArea.right();
        int y2 = this.modelViewArea.bottom();
        Quaternionf quaternionf = new Quaternionf().rotateX(0.5235988f + this.xRot).rotateY(0.5235988f + this.yRot).rotateZ((float)Math.PI);
        float entityBodyYaw = entity.yBodyRot;
        float entityYaw = entity.getYRot();
        float entityPitch = entity.getXRot();
        float entityPrevHeadYaw = entity.yHeadRotO;
        float entityHeadYaw = entity.yHeadRot;
        entity.yBodyRot = 180.0f;
        entity.setYRot(180.0f + (float)this.entityYawSlider.getValue());
        entity.setXRot((float)this.entityPitchSlider.getValue());
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        Vector3f offset = new Vector3f((float)this.modelX, (float)this.modelY, 0.0f);
        this.renderEntityWithAnalyser(graphics, x1, y1, x2, y2, this.modelScale, offset, quaternionf, entity);
        entity.yBodyRot = entityBodyYaw;
        entity.setYRot(entityYaw);
        entity.setXRot(entityPitch);
        entity.yHeadRotO = entityPrevHeadYaw;
        entity.yHeadRot = entityHeadYaw;
    }

    protected void renderEntityWithAnalyser(GuiGraphics graphics, int x1, int y1, int x2, int y2, float scale, Vector3f offset, Quaternionf quaternionf, LivingEntity entity) {
        this.analyser.modelPose.translate((float)(x1 + x2) / 2.0f, (float)(y1 + y2) / 2.0f, 0.0f);
        this.analyser.modelPose.scale(scale, scale, -scale);
        this.analyser.modelPose.translate(offset.x(), offset.y(), offset.z());
        this.analyser.modelPose.mulPose((Quaternionfc)quaternionf);
        this.analyser.modelPose.translate(0.0f, -entity.getBbHeight() / 2.0f, 0.0f);
        this.analyser.updateModel(this.minecraft, (Entity)entity, 1.0f, this.analyser.modelPose);
        EntityRenderState entityRenderState = this.minecraft.getEntityRenderDispatcher().getRenderer((Entity)entity).createRenderState((Entity)entity, 1.0f);
        entityRenderState.hitboxesRenderState = null;
        graphics.submitEntityRenderState(entityRenderState, scale, offset, quaternionf, new Quaternionf(), x1, y1, x2, y2);
    }

    protected void renderTextureViewArea(GuiGraphics graphics, LivingEntity entity) {
        if (this.textureViewArea == null) {
            return;
        }
        int x1 = this.textureViewArea.left();
        int y1 = this.textureViewArea.top();
        int x2 = this.textureViewArea.right();
        int y2 = this.textureViewArea.bottom();
        Vector3f offset = new Vector3f((float)this.textureX - 0.5f, (float)this.textureY - 0.5f, 0.0f);
        this.renderTextureWithAnalyser(graphics, x1, y1, x2, y2, (float)(this.textureScale * this.textureViewArea.width()) / 80.0f, offset, entity);
    }

    protected void renderTextureWithAnalyser(GuiGraphics graphics, int x1, int y1, int x2, int y2, float scale, Vector3f offset, LivingEntity entity) {
        this.analyser.texturePose.translate((float)(x1 + x2) / 2.0f, (float)(y1 + y2) / 2.0f, 0.0f);
        this.analyser.texturePose.scale(scale, scale, -scale);
        this.analyser.texturePose.translate(offset.x(), offset.y(), offset.z());
        EntityRenderState entityRenderState = this.minecraft.getEntityRenderDispatcher().getRenderer((Entity)entity).createRenderState((Entity)entity, 1.0f);
        entityRenderState.hitboxesRenderState = null;
        graphics.submitEntityRenderState(entityRenderState, scale, offset, new Quaternionf(), null, x1, y1, x2, y2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importBindTarget(Button button) {
        FriendlyByteBuf byteBuf = null;
        try {
            int length;
            String base64 = this.minecraft.keyboardHandler.getClipboard();
            byte[] compressed = Base64.getDecoder().decode(base64);
            InflaterInputStream inflaterStream = new InflaterInputStream(new ByteArrayInputStream(compressed));
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((length = inflaterStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, length);
            }
            byte[] bytes = outputStream.toByteArray();
            byteBuf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])bytes));
            BindTarget target = BindTarget.read(byteBuf);
            if (target.isEmpty()) {
                throw new IllegalArgumentException("Invalid config format");
            }
            this.loadBindTarget(target);
            button.setTooltip(Tooltip.create((Component)LocUtil.MODEL_VIEW_TOOLTIP("importSucceeded", LocUtil.literal("'" + target.name() + "'").withStyle(ChatFormatting.WHITE)).withStyle(ChatFormatting.GREEN)));
        }
        catch (Exception e) {
            Object message = e.getClass().getSimpleName();
            if (e instanceof IllegalArgumentException) {
                message = (String)message + ": " + e.getMessage();
            }
            button.setTooltip(Tooltip.create((Component)LocUtil.MODEL_VIEW_TOOLTIP("importFailed", message).withStyle(ChatFormatting.RED)));
        }
        finally {
            if (byteBuf != null) {
                byteBuf.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportBindTarget(Button button) {
        FriendlyByteBuf byteBuf = new FriendlyByteBuf(Unpooled.buffer());
        try {
            this.genBindTarget().write(byteBuf);
            byte[] bytes = new byte[byteBuf.readableBytes()];
            byteBuf.getBytes(byteBuf.readerIndex(), bytes);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try (DeflaterOutputStream deflaterStream = new DeflaterOutputStream((OutputStream)outputStream, new Deflater(9));){
                deflaterStream.write(bytes);
            }
            String base64 = Base64.getEncoder().encodeToString(outputStream.toByteArray());
            this.minecraft.keyboardHandler.setClipboard(base64);
            button.setTooltip(Tooltip.create((Component)LocUtil.MODEL_VIEW_TOOLTIP("exportSucceeded", new Object[0]).withStyle(ChatFormatting.GREEN)));
        }
        catch (Exception e) {
            String message = e.getClass().getSimpleName() + ": " + e.getMessage();
            button.setTooltip(Tooltip.create((Component)LocUtil.MODEL_VIEW_TOOLTIP("exportFailed", message).withStyle(ChatFormatting.RED)));
        }
        finally {
            byteBuf.release();
        }
    }

    protected void loadBindTarget(BindTarget target) {
        if (target.isEmpty()) {
            return;
        }
        this.nameField.setValue(target.name());
        this.textureIdField.setValue(target.textureId());
        this.priorityField.setNumber(target.priority());
        this.depthField.setNumber(Float.valueOf(target.disablingDepth()));
        this.forwardUField.setNumber(Float.valueOf(target.targetConfig().forwardU()));
        this.forwardVField.setNumber(Float.valueOf(target.targetConfig().forwardV()));
        this.upwardUField.setNumber(Float.valueOf(target.targetConfig().upwardU()));
        this.upwardVField.setNumber(Float.valueOf(target.targetConfig().upwardV()));
        this.posUField.setNumber(Float.valueOf(target.targetConfig().posU()));
        this.posVField.setNumber(Float.valueOf(target.targetConfig().posV()));
        this.bindXButton.setValue(target.bindConfig().bindX() ? 0 : 1);
        this.bindYButton.setValue(target.bindConfig().bindY() ? 0 : 1);
        this.bindZButton.setValue(target.bindConfig().bindZ() ? 0 : 1);
        this.bindRotButton.setValue(target.bindConfig().bindRotation() ? 0 : 1);
        this.scaleField.setNumber(Float.valueOf(target.offsets().getScale()));
        this.offsetXSlider.setValue(target.offsets().getX());
        this.offsetXField.setNumber(Float.valueOf(target.offsets().getX()));
        this.offsetYSlider.setValue(target.offsets().getY());
        this.offsetYField.setNumber(Float.valueOf(target.offsets().getY()));
        this.offsetZSlider.setValue(target.offsets().getZ());
        this.offsetZField.setNumber(Float.valueOf(target.offsets().getZ()));
        this.offsetPitchSlider.setValue(target.offsets().getPitch());
        this.offsetPitchField.setNumber(Float.valueOf(target.offsets().getPitch()));
        this.offsetYawSlider.setValue(target.offsets().getYaw());
        this.offsetYawField.setNumber(Float.valueOf(target.offsets().getYaw()));
        this.offsetRollSlider.setValue(target.offsets().getRoll());
        this.offsetRollField.setNumber(Float.valueOf(target.offsets().getRoll()));
        this.disableConfigs.clear();
        this.disableConfigs.addAll(List.of(target.disableConfigs()));
    }

    protected BindTarget genBindTarget() {
        BindTarget.TargetConfig targetConfig = new BindTarget.TargetConfig(this.forwardUField.getNumber().floatValue(), this.forwardVField.getNumber().floatValue(), this.upwardUField.getNumber().floatValue(), this.upwardVField.getNumber().floatValue(), this.posUField.getNumber().floatValue(), this.posVField.getNumber().floatValue());
        BindTarget.BindConfig bindConfig = new BindTarget.BindConfig(this.bindXButton.getValue() == 0, this.bindYButton.getValue() == 0, this.bindZButton.getValue() == 0, this.bindRotButton.getValue() == 0);
        BindTarget.OffsetConfig offsets = new BindTarget.OffsetConfig().setScale(this.scaleField.getNumber().floatValue()).setX((Integer)this.toggleSliderButton.getValue() == 0 ? (float)this.offsetXSlider.getValue() : this.offsetXField.getNumber().floatValue()).setY((Integer)this.toggleSliderButton.getValue() == 0 ? (float)this.offsetYSlider.getValue() : this.offsetYField.getNumber().floatValue()).setZ((Integer)this.toggleSliderButton.getValue() == 0 ? (float)this.offsetZSlider.getValue() : this.offsetZField.getNumber().floatValue()).setPitch((Integer)this.toggleSliderButton.getValue() == 0 ? (float)this.offsetPitchSlider.getValue() : this.offsetPitchField.getNumber().floatValue()).setYaw((Integer)this.toggleSliderButton.getValue() == 0 ? (float)this.offsetYawSlider.getValue() : this.offsetYawField.getNumber().floatValue()).setRoll((Integer)this.toggleSliderButton.getValue() == 0 ? (float)this.offsetRollSlider.getValue() : this.offsetRollField.getNumber().floatValue());
        BindTarget.DisableConfig currentDisableConfig = new BindTarget.DisableConfig(this.disabledNameField.getValue(), this.disabledIdField.getValue(), (Integer)this.disableModeButton.getValue() == 0, (BindTarget.UVRectangle[])this.rectWidgets.stream().map(UVRectangleWidget::toUVRectangle).toArray(BindTarget.UVRectangle[]::new));
        BindTarget.DisableConfig[] disableConfigArray = this.disableConfigs.toArray(new BindTarget.DisableConfig[0]);
        for (int i = 0; i < disableConfigArray.length; ++i) {
            if (!disableConfigArray[i].name().equals(currentDisableConfig.name())) continue;
            disableConfigArray[i] = currentDisableConfig;
        }
        return new BindTarget(this.nameField.getValue(), this.textureIdField.getValue(), this.priorityField.getNumber(), this.depthField.getNumber().floatValue(), targetConfig, bindConfig, offsets, disableConfigArray);
    }

    protected Tooltip createTooltip(String key, Object ... args) {
        return Tooltip.create((Component)LocUtil.MODEL_VIEW_TOOLTIP(key, args));
    }

    protected UVRectangleWidget createRectWidget(BindTarget.UVRectangle rect) {
        return new UVRectangleWidget(rect.uMin(), rect.vMin(), rect.uMax(), rect.vMax());
    }

    protected Button createButton(Component message, int width, Button.OnPress onPress) {
        return Button.builder((Component)message, (Button.OnPress)onPress).size(width, this.widgetHeight).build();
    }

    protected CycleButton<Integer> createCyclingButton(SequencedMap<Integer, Component> messages, int width, Component optionText, OptionInstance.TooltipSupplier<Integer> tooltipSupplier) {
        return new CycleButton.Builder(messages::get).withValues(messages.sequencedKeySet()).withInitialValue((Object)0).withTooltip(tooltipSupplier).create(0, 0, width, this.widgetHeight, optionText);
    }

    protected CycleButton<Integer> createCyclingButton(SequencedMap<Integer, Component> messages, int width, OptionInstance.TooltipSupplier<Integer> tooltipSupplier, CycleButton.OnValueChange<Integer> onValueChange) {
        return new CycleButton.Builder(messages::get).withValues(messages.sequencedKeySet()).withInitialValue((Object)0).withTooltip(tooltipSupplier).displayOnlyValue().create(0, 0, width, this.widgetHeight, (Component)Component.empty(), onValueChange);
    }

    protected DoubleSlider createSlider(String key, int width, double min, double max) {
        return new DoubleSlider(width, this.widgetHeight, 0.0, min, max, d -> LocUtil.MODEL_VIEW_WIDGET(key, MathUtil.round(d, 2)));
    }

    protected NumberField<Float> createFloatField(int width, float defaultValue, @Nullable NumberField<Float> copyFrom) {
        return NumberField.ofFloat(this.font, width - 2, this.widgetHeight - 2, defaultValue, copyFrom).setMax(Float.valueOf(1.0f)).setMin(Float.valueOf(0.0f));
    }

    protected EditBox createTextField(int width, int maxLength, @Nullable EditBox copyFrom) {
        EditBox editBox = new EditBox(this.font, 0, 0, width - 2, this.widgetHeight - 2, (Component)Component.empty());
        editBox.setMaxLength(maxLength);
        if (copyFrom != null) {
            editBox.setValue(copyFrom.getValue());
        }
        return editBox;
    }

    protected boolean inModelViewArea(double x, double y) {
        return this.modelViewArea.containsPoint((int)x, (int)y);
    }

    protected boolean inTextureViewArea(double x, double y) {
        return this.textureViewArea != null && this.textureViewArea.containsPoint((int)x, (int)y);
    }

    public boolean leftClickedWithModifier(double mouseX, double mouseY) {
        if (this.focusedPolyhedron.length == 0) {
            return false;
        }
        if (this.inModelViewArea(mouseX, mouseY) && (Integer)this.toggleCategoryButton.getValue() == 0) {
            float u = 0.0f;
            float v = 0.0f;
            for (VertexData vertex : this.focusedPolyhedron[0]) {
                u += vertex.u();
                v += vertex.v();
            }
            u /= (float)this.focusedPolyhedron[0].length;
            v /= (float)this.focusedPolyhedron[0].length;
            if ((Integer)this.selectingButton.getValue() == 0) {
                this.forwardUField.setNumber(Float.valueOf(u));
                this.forwardVField.setNumber(Float.valueOf(v));
            } else if ((Integer)this.selectingButton.getValue() == 1) {
                this.upwardUField.setNumber(Float.valueOf(u));
                this.upwardVField.setNumber(Float.valueOf(v));
            } else {
                this.posUField.setNumber(Float.valueOf(u));
                this.posVField.setNumber(Float.valueOf(v));
            }
            this.textureIdField.setValue(this.focusedTextureId);
            return true;
        }
        if ((this.inModelViewArea(mouseX, mouseY) || this.inTextureViewArea(mouseX, mouseY)) && (Integer)this.toggleCategoryButton.getValue() == 1) {
            String disabledId = this.disabledIdField.getValue();
            if (disabledId.isBlank() || !this.focusedTextureId.contains(disabledId)) {
                this.disabledIdField.setValue(this.focusedTextureId);
                return true;
            }
            if ((Integer)this.selectionModeButton.getValue() == 2) {
                boolean merged;
                ArrayList<UVRectangleWidget> rectWidgets = new ArrayList<UVRectangleWidget>();
                for (VertexData[] primitive : this.focusedPolyhedron) {
                    float uMin = 1.0f;
                    float vMin = 1.0f;
                    float uMax = 0.0f;
                    float vMax = 0.0f;
                    for (VertexData vertex : primitive) {
                        if (vertex.u() < uMin) {
                            uMin = vertex.u();
                        }
                        if (vertex.v() < vMin) {
                            vMin = vertex.v();
                        }
                        if (vertex.u() > uMax) {
                            uMax = vertex.u();
                        }
                        if (!(vertex.v() > vMax)) continue;
                        vMax = vertex.v();
                    }
                    rectWidgets.add(new UVRectangleWidget(uMin, vMin, uMax, vMax));
                }
                do {
                    merged = false;
                    for (int i = 0; i < rectWidgets.size(); ++i) {
                        UVRectangleWidget rectWidget = (UVRectangleWidget)((Object)rectWidgets.get(i));
                        int j = i + 1;
                        while (j < rectWidgets.size()) {
                            if (rectWidget.mergeWith((UVRectangleWidget)((Object)rectWidgets.get(j)))) {
                                rectWidgets.remove(j);
                                merged = true;
                                continue;
                            }
                            ++j;
                        }
                    }
                } while (merged);
                rectWidgets.forEach(this::addRectWidget);
            } else {
                float uMin = 1.0f;
                float vMin = 1.0f;
                float uMax = 0.0f;
                float vMax = 0.0f;
                VertexData[][] vertexDataArray = this.focusedPolyhedron;
                int n = vertexDataArray.length;
                for (int i = 0; i < n; ++i) {
                    VertexData[] primitive;
                    for (VertexData vertex : primitive = vertexDataArray[i]) {
                        if (vertex.u() < uMin) {
                            uMin = vertex.u();
                        }
                        if (vertex.v() < vMin) {
                            vMin = vertex.v();
                        }
                        if (vertex.u() > uMax) {
                            uMax = vertex.u();
                        }
                        if (!(vertex.v() > vMax)) continue;
                        vMax = vertex.v();
                    }
                }
                this.setFocused((GuiEventListener)this.addRectWidget(new UVRectangleWidget(uMin, vMin, uMax, vMax)));
            }
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        double storedX = this.clickedX;
        double storedY = this.clickedY;
        this.clickedY = -1.0;
        this.clickedX = -1.0;
        if (button == 0 && (Integer)this.toggleCategoryButton.getValue() != 2) {
            if (InputConstants.isKeyDown((long)this.minecraft.getWindow().getWindow(), (int)this.modifierKey.getValue())) {
                if (this.leftClickedWithModifier(mouseX, mouseY)) {
                    return true;
                }
            } else if (this.inTextureViewArea(mouseX, mouseY)) {
                if (super.mouseClicked(mouseX, mouseY, button)) {
                    return true;
                }
                if (storedX >= 0.0 && storedY >= 0.0) {
                    float xMin = (float)Math.min(storedX, mouseX);
                    float yMin = (float)Math.min(storedY, mouseY);
                    float xMax = (float)Math.max(storedX, mouseX);
                    float yMax = (float)Math.max(storedY, mouseY);
                    this.setFocused((GuiEventListener)this.addRectWidget(new UVRectangleWidget(xMin, yMin, xMax, yMax, this.textureViewArea)));
                    return true;
                }
                this.clickedX = (int)mouseX;
                this.clickedY = (int)mouseY;
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0 && !InputConstants.isKeyDown((long)this.minecraft.getWindow().getWindow(), (int)this.modifierKey.getValue())) {
            if (this.inModelViewArea(mouseX, mouseY)) {
                this.xRot += (float)(Math.PI * deltaY / (double)this.ySize);
                this.yRot -= (float)(Math.PI * deltaX / (double)this.middleWidth);
                return true;
            }
        } else if (button == 1) {
            if (this.inModelViewArea(mouseX, mouseY)) {
                this.modelX += deltaX / (double)this.modelScale;
                this.modelY += deltaY / (double)this.modelScale;
                return true;
            }
            if (this.inTextureViewArea(mouseX, mouseY)) {
                this.textureX += deltaX / (double)this.textureScale;
                this.textureY += deltaY / (double)this.textureScale;
                return true;
            }
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.inModelViewArea(mouseX, mouseY)) {
            if (InputConstants.isKeyDown((long)this.minecraft.getWindow().getWindow(), (int)this.modifierKey.getValue())) {
                if ((Integer)this.toggleCategoryButton.getValue() == 1 && (Integer)this.selectionModeButton.getValue() == 2) {
                    this.selectionRadius = Mth.clamp((int)(this.selectionRadius + (int)verticalAmount * 2), (int)2, (int)48);
                } else {
                    this.layers = Math.max(0, this.layers + (int)verticalAmount);
                }
            } else {
                this.modelScale = Mth.clamp((int)(this.modelScale + (int)verticalAmount * this.modelScale / 16), (int)16, (int)1024);
            }
            return true;
        }
        if (this.inTextureViewArea(mouseX, mouseY)) {
            this.textureScale = Mth.clamp((int)(this.textureScale + (int)verticalAmount * this.textureScale / 16), (int)16, (int)1024);
        }
        return super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        GuiEventListener focused;
        if (CommonInputs.selected((int)keyCode) && (focused = this.getFocused()) != null && !focused.isFocused()) {
            this.setFocused((GuiEventListener)this.focusedRectWidget);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean isPauseScreen() {
        return this.pauseButton.getValue() == 1;
    }

    public class UVRectangleWidget
    extends AbstractWidget {
        protected float uMin;
        protected float vMin;
        protected float uMax;
        protected float vMax;

        public UVRectangleWidget(float uMin, float vMin, float uMax, float vMax) {
            super(0, 0, 16, 16, (Component)Component.empty());
            this.uMin = uMin;
            this.vMin = vMin;
            this.uMax = uMax;
            this.vMax = vMax;
        }

        public UVRectangleWidget(float xMin, float yMin, float xMax, @NotNull float yMax, ScreenRectangle screenArea) {
            super((int)xMin, (int)yMin, (int)(xMax - xMin), (int)(yMax - yMin), (Component)Component.empty());
            Vec2 minUV = this.translateXYToUV(xMin, yMin, screenArea);
            Vec2 maxUV = this.translateXYToUV(xMax, yMax, screenArea);
            this.uMin = minUV.x;
            this.vMin = minUV.y;
            this.uMax = maxUV.x;
            this.vMax = maxUV.y;
        }

        public BindTarget.UVRectangle toUVRectangle() {
            return new BindTarget.UVRectangle(this.uMin, this.vMin, this.uMax, this.vMax);
        }

        public boolean contains(UVRectangleWidget other) {
            return this.uMin <= other.uMin && this.vMin <= other.vMin && this.uMax >= other.uMax && this.vMax >= other.vMax;
        }

        public boolean mergeWith(UVRectangleWidget other) {
            if (this.uMin == other.uMin && this.uMax == other.uMax && this.vMin <= other.vMax && this.vMax >= other.vMin) {
                this.vMin = Math.min(this.vMin, other.vMin);
                this.vMax = Math.max(this.vMax, other.vMax);
                return true;
            }
            if (this.vMin == other.vMin && this.vMax == other.vMax && this.uMin <= other.uMax && this.uMax >= other.uMin) {
                this.uMin = Math.min(this.uMin, other.uMin);
                this.uMax = Math.max(this.uMax, other.uMax);
                return true;
            }
            return false;
        }

        private Vec2 translateUVToXY(float u, float v, ScreenRectangle screenArea) {
            int x1 = screenArea.left();
            int y1 = screenArea.top();
            int x2 = screenArea.right();
            int y2 = screenArea.bottom();
            Vector3f vector3f = new Vector3f(u, v, 0.0f).add((float)ModelViewScreen.this.textureX - 0.5f, (float)ModelViewScreen.this.textureY - 0.5f, 0.0f).mul((float)(ModelViewScreen.this.textureScale * screenArea.width()) / 80.0f).add((float)(x1 + x2) / 2.0f, (float)(y1 + y2) / 2.0f, 0.0f);
            return new Vec2(vector3f.x(), vector3f.y());
        }

        private Vec2 translateXYToUV(float x, float y, ScreenRectangle screenArea) {
            int x1 = screenArea.left();
            int y1 = screenArea.top();
            int x2 = screenArea.right();
            int y2 = screenArea.bottom();
            Vector3f vector3f = new Vector3f(x, y, 0.0f).add(-((float)(x1 + x2)) / 2.0f, -((float)(y1 + y2)) / 2.0f, 0.0f).mul(80.0f / (float)(ModelViewScreen.this.textureScale * screenArea.width())).add((float)(-ModelViewScreen.this.textureX) + 0.5f, (float)(-ModelViewScreen.this.textureY) + 0.5f, 0.0f);
            return new Vec2(vector3f.x(), vector3f.y());
        }

        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float deltaTick) {
            Vec2 minXY = this.translateUVToXY(this.uMin, this.vMin, ModelViewScreen.this.textureViewArea);
            Vec2 maxXY = this.translateUVToXY(this.uMax, this.vMax, ModelViewScreen.this.textureViewArea);
            float x1 = minXY.x;
            float y1 = minXY.y;
            float x2 = maxXY.x;
            float y2 = maxXY.y;
            float width = x2 - x1;
            float height = y2 - y1;
            this.setX((int)x1);
            this.setY((int)y1);
            this.setWidth((int)width);
            this.setHeight((int)height);
            GUIHelper.enableScissor(graphics, ModelViewScreen.this.textureViewArea);
            GUIHelper.fill(graphics, x1, y1, x2, y2, 1328755660);
            if (this.isHoveredOrFocused()) {
                GUIHelper.fill(graphics, x1, y1, x2, y2, 791884748);
            }
            if (this.isFocused() || this == ModelViewScreen.this.focusedRectWidget) {
                GUIHelper.renderOutline(graphics, x1, y1, width, height, -1426063361);
            }
            graphics.disableScissor();
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            if (ModelViewScreen.this.textureViewArea == null) {
                return false;
            }
            if (keyCode == 261 && ModelViewScreen.this.deleteFocusedRectWidget()) {
                return true;
            }
            if (CommonInputs.selected((int)keyCode) && this.uMin < this.uMax && this.vMin < this.vMax) {
                ModelViewScreen.this.textureX = 0.5 * (double)(1.0f - this.uMin - this.uMax);
                ModelViewScreen.this.textureY = 0.5 * (double)(1.0f - this.vMin - this.vMax);
                ModelViewScreen.this.textureScale = (int)Mth.clamp((double)(2560.0 / ((double)ModelViewScreen.this.textureViewArea.width() * Math.sqrt((this.uMax - this.uMin) * (this.vMax - this.vMin)))), (double)16.0, (double)1024.0);
                return true;
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }

        public void setFocused(boolean focused) {
            super.setFocused(focused);
            if (focused) {
                ModelViewScreen.this.focusedRectWidget = this;
                ModelViewScreen.this.focusedRectWidgetNumberField.setNumber(ModelViewScreen.this.rectWidgets.indexOf((Object)this) + 1);
                ModelViewScreen.this.uMinField.setNumber(Float.valueOf(this.uMin));
                ModelViewScreen.this.vMinField.setNumber(Float.valueOf(this.vMin));
                ModelViewScreen.this.uMaxField.setNumber(Float.valueOf(this.uMax));
                ModelViewScreen.this.vMaxField.setNumber(Float.valueOf(this.vMax));
            }
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }
    }
}

