/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.gui;

import com.xtracr.realcamera.util.LocUtil;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public abstract class NumberField<T extends Comparable<T>>
extends EditBox {
    private final T defaultValue;
    protected T maximum;
    protected T minimum;
    private Tooltip tooltip;

    NumberField(Font font, int width, int height, T defaultValue, T maximum, T minimum, @Nullable NumberField<T> copyFrom) {
        super(font, 0, 0, width, height, (Component)Component.empty());
        this.defaultValue = defaultValue;
        this.maximum = maximum;
        this.minimum = minimum;
        this.setNumber(defaultValue);
        if (copyFrom != null) {
            this.setNumber(copyFrom.getNumber());
        }
    }

    public static NumberField<Float> ofFloat(Font font, int width, int height, float defaultValue, @Nullable NumberField<Float> copyFrom) {
        return new FloatField(font, width, height, defaultValue, copyFrom);
    }

    public static NumberField<Integer> ofInt(Font font, int width, int height, int defaultValue, @Nullable NumberField<Integer> copyFrom) {
        return new IntField(font, width, height, defaultValue, copyFrom);
    }

    public T getNumber() {
        try {
            return this.getNumberInternal();
        }
        catch (Exception e) {
            return this.defaultValue;
        }
    }

    public void setNumber(T value) {
        try {
            if (value.compareTo(this.minimum) < 0) {
                value = this.minimum;
            } else if (value.compareTo(this.maximum) > 0) {
                value = this.maximum;
            }
            this.setValue(value.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public NumberField<T> setMax(T maximum) {
        this.maximum = maximum;
        return this;
    }

    public NumberField<T> setMin(T minimum) {
        this.minimum = minimum;
        return this;
    }

    public NumberField<T> setOnValueChange(Consumer<T> consumer) {
        super.setResponder(str -> consumer.accept(this.getNumber()));
        return this;
    }

    protected abstract T getNumberInternal();

    protected void checkText() {
        super.setTooltip(this.tooltip);
        this.setFormatter((string, firstCharacterIndex) -> FormattedCharSequence.forward((String)string, (Style)Style.EMPTY));
        if (this.getValue().isEmpty()) {
            return;
        }
        try {
            T value = this.getNumberInternal();
            if (value.compareTo(this.minimum) < 0) {
                throw new Exception("< " + String.valueOf(this.minimum));
            }
            if (value.compareTo(this.maximum) > 0) {
                throw new Exception("> " + String.valueOf(this.maximum));
            }
        }
        catch (Exception e) {
            super.setTooltip(Tooltip.create((Component)LocUtil.literal("Invalid number: " + e.getMessage()).withStyle(s -> s.withColor(ChatFormatting.RED))));
            this.setFormatter((string, firstCharacterIndex) -> FormattedCharSequence.forward((String)string, (Style)Style.EMPTY.withColor(ChatFormatting.RED)));
        }
    }

    public void setTooltip(Tooltip tooltip) {
        this.tooltip = tooltip;
        super.setTooltip(tooltip);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (CommonInputs.selected((int)keyCode)) {
            this.setFocused(false);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char chr, int modifiers) {
        if (chr != '-' && chr != '.' && (chr < '0' || chr > '9')) {
            return false;
        }
        return super.charTyped(chr, modifiers);
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float deltaTick) {
        this.checkText();
        super.renderWidget(graphics, mouseX, mouseY, deltaTick);
    }

    private static class FloatField
    extends NumberField<Float> {
        FloatField(Font font, int width, int height, float defaultValue, @Nullable NumberField<Float> copyFrom) {
            super(font, width, height, Float.valueOf(defaultValue), Float.valueOf(Float.MAX_VALUE), Float.valueOf(-3.4028235E38f), copyFrom);
            this.setMaxLength(16);
        }

        @Override
        protected Float getNumberInternal() {
            return Float.valueOf(Float.parseFloat(this.getValue()));
        }
    }

    private static class IntField
    extends NumberField<Integer> {
        IntField(Font font, int width, int height, int defaultValue, @Nullable NumberField<Integer> copyFrom) {
            super(font, width, height, defaultValue, Integer.MAX_VALUE, Integer.MIN_VALUE, copyFrom);
            this.setMaxLength(8);
        }

        @Override
        protected Integer getNumberInternal() {
            return Integer.parseInt(this.getValue());
        }
    }
}

