/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.gui;

import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class TexturedButton
extends AbstractButton {
    public static final ResourceLocation ICON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"realcamera", (String)"textures/gui/icon.png");
    protected final ResourceLocation texture;
    protected final int textureWidth;
    protected final int textureHeight;
    protected final int u;
    protected final int v;
    private final Consumer<TexturedButton> onPress;

    public TexturedButton(int u, int v, Consumer<TexturedButton> onPress) {
        this(0, 0, 16, 16, u, v, onPress);
    }

    public TexturedButton(int x, int y, int width, int height, int u, int v, Consumer<TexturedButton> onPress) {
        this(x, y, width, height, u, v, ICON_TEXTURE, 256, 256, onPress);
    }

    public TexturedButton(int x, int y, int width, int height, int u, int v, ResourceLocation texture, int textureWidth, int textureHeight, Consumer<TexturedButton> onPress) {
        super(x, y, width, height, (Component)Component.empty());
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.onPress = onPress;
        this.u = u;
        this.v = v;
        this.texture = texture;
    }

    public void onPress() {
        this.onPress.accept(this);
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float deltaTick) {
        graphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), -10197916);
        graphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, this.getX(), this.getY(), (float)this.u, (float)this.v, this.width, this.height, this.textureWidth, this.textureHeight);
        if (this.isHoveredOrFocused()) {
            graphics.renderOutline(this.getX(), this.getY(), this.getWidth(), this.getHeight(), -1);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
        this.defaultButtonNarrationText(builder);
    }
}

