/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.mixin;

import com.xtracr.realcamera.RealCameraCore;
import com.xtracr.realcamera.config.ConfigFile;
import com.xtracr.realcamera.config.ModConfig;
import com.xtracr.realcamera.mixin.accessor.GameRendererAccessor;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Camera.class})
public abstract class MixinCamera {
    @Shadow
    private BlockGetter level;
    @Shadow
    private Vec3 position;
    @Shadow
    private float xRot;
    @Shadow
    private float yRot;

    @Inject(method={"setup(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/entity/Entity;ZZF)V"}, at={@At(value="RETURN")})
    private void realcamera$setupCamera(BlockGetter area, Entity entity, boolean thirdPerson, boolean inverseView, float deltaTick, CallbackInfo ci) {
        if (!RealCameraCore.isActive()) {
            return;
        }
        ModConfig config = ConfigFile.config();
        Vec3 startVec = this.position;
        AABB box = entity.getBoundingBox();
        if (config.isClassic()) {
            double d;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                d = livingEntity.getScale();
            } else {
                d = 1.0;
            }
            double scale = d;
            Vec3 offset = new Vec3(config.getClassicX(), config.getClassicY(), -config.getClassicZ()).scale(scale);
            Vec3 center = new Vec3(config.getCenterX(), config.getCenterY(), -config.getCenterZ()).scale(scale);
            float newPitch = this.xRot + config.getClassicPitch();
            float newYaw = this.yRot - config.getClassicYaw();
            this.setRotation(this.yRot, 0.0f);
            this.move((float)center.x(), (float)center.y(), (float)center.z());
            this.setRotation(newYaw, newPitch);
            this.move((float)offset.x(), (float)offset.y(), (float)offset.z());
        } else {
            Vec3 entityPos = entity.position().add(entity.position().subtract(entity.xOld, entity.yOld, entity.zOld).scale(entity.tickCount == 0 ? 0.0 : (double)(deltaTick - 1.0f)));
            Vec3 rawPos = RealCameraCore.getRawPos(this.position, entityPos);
            double restrictedY = Mth.clamp((double)rawPos.y(), (double)(box.minY + 0.1), (double)(box.maxY - 0.1));
            startVec = new Vec3(this.position.x(), restrictedY, this.position.z());
            this.setPosition(rawPos);
            this.setRotation(RealCameraCore.getYaw(this.yRot), RealCameraCore.getPitch(this.xRot));
        }
        this.realcamera$clipToSpace(startVec, entity, deltaTick);
        RealCameraCore.setCameraPos(this.position);
    }

    @Unique
    private void realcamera$clipToSpace(Vec3 startVec, Entity entity, float deltaTick) {
        Vec3 offset = this.position.subtract(startVec);
        float fov = ((GameRendererAccessor)Minecraft.getInstance().gameRenderer).invokeGetFov((Camera)this, deltaTick, true);
        float depth = 0.05f + fov * (1.0E-4f + 5.0E-6f * fov);
        for (int i = 0; i < 8; ++i) {
            float f = depth * (float)((i & 1) * 2 - 1);
            float g = depth * (float)((i >> 1 & 1) * 2 - 1);
            float h = depth * (float)((i >> 2 & 1) * 2 - 1);
            Vec3 start = startVec.add((double)f, (double)g, (double)h);
            Vec3 end = startVec.add(offset).add((double)f, (double)g, (double)h);
            BlockHitResult hitResult = this.level.clip(new ClipContext(start, end, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, entity));
            double l = hitResult.getLocation().distanceTo(start);
            if (hitResult.getType() == HitResult.Type.MISS || l >= offset.length()) continue;
            offset = offset.scale(l / offset.length());
        }
        this.setPosition(startVec.add(offset));
    }

    @Shadow
    protected abstract void move(float var1, float var2, float var3);

    @Shadow
    protected abstract void setRotation(float var1, float var2);

    @Shadow
    protected abstract void setPosition(Vec3 var1);
}

