/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.xtracr.realcamera.RealCameraCore;
import com.xtracr.realcamera.compat.CompatibilityHelper;
import com.xtracr.realcamera.config.ConfigFile;
import com.xtracr.realcamera.util.CrosshairUtil;
import com.xtracr.realcamera.util.RaycastUtil;
import java.util.function.Predicate;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public abstract class MixinGameRenderer {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    @Final
    private Camera mainCamera;

    @ModifyVariable(method={"pick(Lnet/minecraft/world/entity/Entity;DDF)Lnet/minecraft/world/phys/HitResult;"}, at=@At(value="STORE"), ordinal=0)
    private EntityHitResult realcamera$modifyEntityHitResult(EntityHitResult entityHitResult) {
        CrosshairUtil.capturedEntityHitResult = entityHitResult;
        if (!ConfigFile.config().dynamicCrosshair() && RealCameraCore.isActive()) {
            Vec3 startVec = RaycastUtil.getStartVec();
            Vec3 endVec = RaycastUtil.getEndVec();
            double sqDistance = this.minecraft.hitResult != null ? this.minecraft.hitResult.getLocation().distanceToSqr(startVec) : endVec.distanceToSqr(startVec);
            Entity cameraEntity = this.minecraft.getCameraEntity();
            double interactionRange = Math.max(this.minecraft.player.blockInteractionRange(), this.minecraft.player.entityInteractionRange());
            AABB box = cameraEntity.getBoundingBox().expandTowards(cameraEntity.getViewVector(this.minecraft.getDeltaTracker().getGameTimeDeltaPartialTick(true)).scale(interactionRange)).inflate(1.0, 1.0, 1.0);
            CrosshairUtil.capturedEntityHitResult = ProjectileUtil.getEntityHitResult((Entity)cameraEntity, (Vec3)startVec, (Vec3)endVec, (AABB)box, (Predicate)EntitySelector.CAN_BE_PICKED, (double)sqDistance);
        }
        return CrosshairUtil.capturedEntityHitResult;
    }

    @Inject(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Camera;setup(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/entity/Entity;ZZF)V")})
    private void realcamera$atCameraSetup(DeltaTracker deltaTracker, CallbackInfo ci) {
        float deltaTick = deltaTracker.getGameTimeDeltaPartialTick(true);
        CompatibilityHelper.NEA_setDeltaTick(deltaTick);
        RealCameraCore.initialize(this.minecraft);
        if (RealCameraCore.isActive() && !ConfigFile.config().isClassic()) {
            EntityRenderDispatcher dispatcher = this.minecraft.getEntityRenderDispatcher();
            dispatcher.prepare((Level)this.minecraft.level, this.mainCamera, this.minecraft.crosshairPickEntity);
            RealCameraCore.computeCamera(this.minecraft, deltaTick);
        }
    }

    @Inject(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;prepareCullFrustum(Lnet/minecraft/world/phys/Vec3;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V")})
    private void realcamera$atPrepareCullFrustum(DeltaTracker deltaTracker, CallbackInfo ci, @Local(ordinal=2) Matrix4f matrix4f3) {
        if (RealCameraCore.isActive()) {
            matrix4f3.rotateLocalZ(RealCameraCore.getRoll(0.0f) * ((float)Math.PI / 180));
        }
        CompatibilityHelper.forceSetCameraPos(this.mainCamera);
    }
}

