/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.compat;

import com.mojang.blaze3d.vertex.PoseStack;
import com.xtracr.realcamera.api.BindResult;
import com.xtracr.realcamera.api.RealCameraAPI;
import com.xtracr.realcamera.config.ConfigFile;
import com.xtracr.realcamera.mixin.accessor.PlayerRendererAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class LegacyBindingMode {
    public static void register() {
        RealCameraAPI.registerFunction(100, LegacyBindingMode::computeBindResult);
    }

    private static BindResult computeBindResult(Minecraft client, float deltaTick) {
        float n;
        Direction direction;
        Entity entity;
        if (!ConfigFile.config().legacyBindingMode()) {
            return BindResult.EMPTY;
        }
        PoseStack poseStack = new PoseStack();
        LocalPlayer player = client.player;
        PlayerRenderer playerRenderer = (PlayerRenderer)client.getEntityRenderDispatcher().getRenderer((Entity)player);
        Vec3 renderOffset = playerRenderer.getRenderOffset((AbstractClientPlayer)player, deltaTick);
        poseStack.translate(renderOffset.x(), renderOffset.y(), renderOffset.z());
        ((PlayerRendererAccessor)playerRenderer).invokeSetModelProperties((AbstractClientPlayer)player);
        PlayerModel playerModel = (PlayerModel)playerRenderer.getModel();
        playerModel.attackTime = player.getAttackAnim(deltaTick);
        playerModel.riding = player.isPassenger();
        playerModel.young = player.isBaby();
        float h = Mth.rotLerp((float)deltaTick, (float)player.yBodyRotO, (float)player.yBodyRot);
        float j = Mth.rotLerp((float)deltaTick, (float)player.yHeadRotO, (float)player.yHeadRot);
        float k = j - h;
        if (player.isPassenger() && (entity = player.getVehicle()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            h = Mth.rotLerp((float)deltaTick, (float)livingEntity.yBodyRotO, (float)livingEntity.yBodyRot);
            k = j - h;
            float l = Mth.wrapDegrees((float)k);
            if (l < -85.0f) {
                l = -85.0f;
            }
            if (l >= 85.0f) {
                l = 85.0f;
            }
            h = j - l;
            if (l * l > 2500.0f) {
                h += l * 0.2f;
            }
            k = j - h;
        }
        float m = Mth.lerp((float)deltaTick, (float)player.xRotO, (float)player.getXRot());
        if (LivingEntityRenderer.isEntityUpsideDown((LivingEntity)player)) {
            m *= -1.0f;
            k *= -1.0f;
        }
        k = Mth.wrapDegrees((float)k);
        if (player.hasPose(Pose.SLEEPING) && (direction = player.getBedOrientation()) != null) {
            n = player.getEyeHeight(Pose.STANDING) - 0.1f;
            poseStack.translate((float)(-direction.getStepX()) * n, 0.0f, (float)(-direction.getStepZ()) * n);
        }
        float lx = player.getScale();
        poseStack.scale(lx, lx, lx);
        n = (float)player.tickCount + deltaTick;
        ((PlayerRendererAccessor)playerRenderer).invokeSetupRotations((AbstractClientPlayer)player, poseStack, n, h, deltaTick, lx);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        ((PlayerRendererAccessor)playerRenderer).invokeScale((AbstractClientPlayer)player, poseStack, deltaTick);
        poseStack.translate(0.0f, -1.501f, 0.0f);
        float o = 0.0f;
        float p = 0.0f;
        if (!player.isPassenger() && player.isAlive()) {
            o = player.walkAnimation.speed(deltaTick);
            p = player.walkAnimation.position(deltaTick);
            if (player.isBaby()) {
                p *= 3.0f;
            }
            if (o > 1.0f) {
                o = 1.0f;
            }
        }
        playerModel.prepareMobModel((LivingEntity)player, p, o, deltaTick);
        playerModel.setupAnim((LivingEntity)player, p, o, n, k, m);
        playerModel.head.translateAndRotate(poseStack);
        Vector4f offset = poseStack.last().pose().transform(new Vector4f(0.0f, -0.125f, -0.2f, 1.0f));
        BindResult result = BindResult.getOrCreate("LEGACY_MODE");
        result.setPosition(new Vec3((double)offset.x(), (double)offset.y(), (double)offset.z()));
        poseStack.scale(1.0f, -1.0f, -1.0f);
        result.setForward(new Vec3(poseStack.last().normal().getColumn(2, new Vector3f())));
        result.setUpward(new Vec3(poseStack.last().normal().getColumn(1, new Vector3f())));
        return result;
    }
}

