/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.gui;

import java.util.function.Function;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class DoubleSlider
extends AbstractSliderButton {
    private final Function<Double, Component> textFactory;
    private final double min;
    private final double max;

    public DoubleSlider(int width, int height, double value, double min, double max, Function<Double, Component> textFactory) {
        super(0, 0, width, height, textFactory.apply(value), Mth.clamp((double)0.0, (double)((value - min) / (max - min)), (double)1.0));
        this.textFactory = textFactory;
        this.min = min;
        this.max = max;
    }

    public double getValue() {
        return this.min + (this.max - this.min) * this.value;
    }

    public void setValue(double value) {
        this.value = Mth.clamp((double)0.0, (double)((value - this.min) / (this.max - this.min)), (double)1.0);
        this.applyValue();
    }

    protected void updateMessage() {
        this.setMessage(this.textFactory.apply(this.getValue()));
    }

    protected void applyValue() {
        this.updateMessage();
    }
}

