/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.util;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.xtracr.realcamera.util.MathUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class CrosshairUtil {
    public static EntityHitResult capturedEntityHitResult;
    public static Vec3 offset;

    public static void translateMatrices(PoseStack poseStack) {
        poseStack.translate(offset.x(), -offset.y(), 0.0);
    }

    public static void update(Minecraft client, Camera camera, Matrix4f ... projectionMatrices) {
        HitResult hitResult = client.hitResult;
        offset = Vec3.ZERO;
        if (client.crosshairPickEntity != null) {
            hitResult = capturedEntityHitResult;
        }
        if (hitResult == null) {
            return;
        }
        Window window = client.getWindow();
        offset = MathUtil.projectToVec2(hitResult.getLocation().subtract(camera.getPosition()), projectionMatrices).multiply(0.5 * (double)window.getGuiScaledWidth(), 0.5 * (double)window.getGuiScaledHeight(), 0.0);
    }

    static {
        offset = Vec3.ZERO;
    }
}

