/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.util;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.xtracr.realcamera.util.BuiltIterableBuffer;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectSortedMaps;
import java.util.Arrays;
import java.util.SequencedMap;
import java.util.function.Consumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import org.jetbrains.annotations.NotNull;

public interface MultiVertexCatcher
extends MultiBufferSource {
    public static MultiVertexCatcher defaultImpl() {
        return MeshCatcher.INSTANCE;
    }

    public void endCatching(Consumer<BuiltIterableBuffer> var1);

    public static class MeshCatcher
    extends MultiBufferSource.BufferSource
    implements MultiVertexCatcher {
        private static final MeshCatcher INSTANCE = new MeshCatcher();
        private final SequencedMap<RenderType, ByteBufferBuilderPool> bufferPools = new Object2ObjectLinkedOpenHashMap();
        private final SequencedMap<MeshData, RenderType> caughtMeshes = new Object2ObjectLinkedOpenHashMap();

        protected MeshCatcher() {
            super(new ByteBufferBuilder(0), (SequencedMap)Object2ObjectSortedMaps.emptyMap());
        }

        @NotNull
        public VertexConsumer getBuffer(RenderType renderType) {
            BufferBuilder bufferBuilder = (BufferBuilder)this.startedBuilders.get(renderType);
            if (bufferBuilder != null) {
                this.endBatch(renderType, bufferBuilder);
            }
            ByteBufferBuilderPool bufferPool = this.bufferPools.computeIfAbsent(renderType, type -> new ByteBufferBuilderPool(type.bufferSize()));
            bufferBuilder = new BufferBuilder(bufferPool.getBuffer(), renderType.mode(), renderType.format());
            this.startedBuilders.put(renderType, bufferBuilder);
            return bufferBuilder;
        }

        @Override
        public void endCatching(Consumer<BuiltIterableBuffer> consumer) {
            this.endBatch();
            this.caughtMeshes.forEach((meshData, renderType) -> {
                consumer.accept(BuiltIterableBuffer.buildFrom(renderType, meshData));
                meshData.close();
            });
            this.caughtMeshes.clear();
            this.bufferPools.values().forEach(ByteBufferBuilderPool::release);
        }

        public void endBatch() {
            for (RenderType renderType : this.bufferPools.keySet()) {
                this.endBatch(renderType);
            }
        }

        protected void endBatch(RenderType renderType, BufferBuilder bufferBuilder) {
            MeshData meshData = bufferBuilder.build();
            if (meshData != null) {
                this.caughtMeshes.put(meshData, renderType);
            }
        }

        private static class ByteBufferBuilderPool {
            private final int bufferSize;
            private ByteBufferBuilder[] pool = new ByteBufferBuilder[0];
            private int next = 0;

            public ByteBufferBuilderPool(int bufferSize) {
                this.bufferSize = bufferSize;
            }

            public ByteBufferBuilder getBuffer() {
                ByteBufferBuilder byteBufferBuilder;
                if (this.next < this.pool.length) {
                    byteBufferBuilder = this.pool[this.next++];
                } else {
                    this.pool = Arrays.copyOf(this.pool, this.pool.length + 1);
                    this.pool[this.next++] = byteBufferBuilder = new ByteBufferBuilder(this.bufferSize);
                }
                return byteBufferBuilder;
            }

            public void release() {
                this.next = 0;
            }
        }
    }
}

