/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera;

import com.xtracr.realcamera.RealCameraCore;
import com.xtracr.realcamera.config.ConfigFile;
import com.xtracr.realcamera.gui.ModelViewScreen;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public final class KeyMappings {
    private static final Map<KeyMapping, Consumer<Minecraft>> KEY_MAPPINGS = new HashMap<KeyMapping, Consumer<Minecraft>>();
    public static final KeyMapping MODEL_VIEW_SCREEN = KeyMappings.createKeyMapping("modelViewScreen", client -> client.m_91152_((Screen)new ModelViewScreen()));

    private static KeyMapping createKeyMapping(String id, Consumer<Minecraft> whenPressed) {
        return KeyMappings.createKeyMapping(id, -1, whenPressed);
    }

    private static KeyMapping createKeyMapping(String id, int code, Consumer<Minecraft> whenPressed) {
        KeyMapping keyMapping = new KeyMapping("key.xtracr_realcamera." + id, code, "general.xtracr_realcamera.modName");
        KEY_MAPPINGS.put(keyMapping, whenPressed);
        return keyMapping;
    }

    public static void register(Consumer<KeyMapping> registerer) {
        KEY_MAPPINGS.keySet().forEach(registerer);
    }

    public static void handle(Minecraft client) {
        if (client.f_91074_ == null) {
            return;
        }
        KEY_MAPPINGS.forEach((keyMapping, whenPressed) -> {
            while (keyMapping.m_90859_()) {
                whenPressed.accept(client);
                ConfigFile.save();
            }
        });
    }

    static {
        KeyMappings.createKeyMapping("togglePerspective", 295, client -> {
            boolean enabled = ConfigFile.config().enabled();
            ConfigFile.load();
            ConfigFile.config().setEnabled(!enabled);
            RealCameraCore.reset();
        });
        KeyMappings.createKeyMapping("toggleAdjustMode", client -> ConfigFile.config().cycleAdjustMode());
        KeyMappings.createKeyMapping("toggleCameraMode", client -> ConfigFile.config().setClassic(!ConfigFile.config().isClassic()));
        KeyMappings.createKeyMapping("adjustFRONT", client -> ConfigFile.config().adjustOffsetX(1));
        KeyMappings.createKeyMapping("adjustBACK", client -> ConfigFile.config().adjustOffsetX(-1));
        KeyMappings.createKeyMapping("adjustUP", client -> ConfigFile.config().adjustOffsetY(1));
        KeyMappings.createKeyMapping("adjustDOWN", client -> ConfigFile.config().adjustOffsetY(-1));
        KeyMappings.createKeyMapping("adjustLEFT", client -> ConfigFile.config().adjustOffsetZ(1));
        KeyMappings.createKeyMapping("adjustRIGHT", client -> ConfigFile.config().adjustOffsetZ(-1));
    }
}

