/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.api;

import com.xtracr.realcamera.config.BindTarget;
import com.xtracr.realcamera.config.ConfigFile;
import java.util.List;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BindResult {
    public static final BindResult EMPTY = new BindResult(BindTarget.EMPTY, false);
    public final BindTarget target;
    protected final Matrix3f rotation = new Matrix3f();
    protected final boolean mirrored;
    private Vec3 position = Vec3.f_82478_;
    private Vec3 forward = Vec3.f_82478_;
    private Vec3 upward = Vec3.f_82478_;

    public BindResult(BindTarget target, boolean mirrored) {
        this.target = target;
        this.mirrored = mirrored;
    }

    public static BindResult getOrCreate(String name) {
        List<BindTarget> fixedTargets = ConfigFile.config().getFixedTargetList();
        BindTarget target = fixedTargets.stream().filter(t -> t.name().equals(name)).findFirst().orElseGet(() -> {
            BindTarget blank = BindTarget.blank(name, "");
            fixedTargets.add(blank);
            return blank;
        });
        return new BindResult(target, false);
    }

    public boolean available() {
        return !this.target.isEmpty() && !this.forward.equals((Object)Vec3.f_82478_) && !this.upward.equals((Object)Vec3.f_82478_) && Double.isFinite(this.position.m_82556_()) && Math.abs(this.rotation.determinant() - 1.0f) < 0.01f;
    }

    public boolean weakAvailable() {
        return !this.target.isEmpty() && (this.forward != Vec3.f_82478_ || this.upward != Vec3.f_82478_ || this.position != Vec3.f_82478_) && Double.isFinite(this.position.m_82556_());
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public void setPosition(Vec3 vec) {
        this.position = vec;
    }

    public Vec3 getForward() {
        return this.forward;
    }

    public void setForward(Vec3 vec) {
        this.forward = vec.m_82541_();
    }

    public Vec3 getUpward() {
        return this.upward;
    }

    public void setUpward(Vec3 vec) {
        this.upward = vec.m_82541_();
    }

    public Matrix3f getRotation() {
        return this.rotation;
    }

    public BindResult computeCamera() {
        if (!this.available()) {
            return this;
        }
        int orientation = this.mirrored ? -1 : 1;
        this.upward = this.forward.m_82537_(this.upward.m_82537_(this.forward)).m_82541_();
        Vec3 left = this.upward.m_82537_(this.forward).m_82490_((double)orientation);
        this.rotation.set((Vector3fc)left.m_252839_(), (Vector3fc)this.upward.m_252839_(), (Vector3fc)this.forward.m_252839_());
        BindTarget.OffsetConfig offsets = this.target.offsets();
        Vector3f offset = new Vector3f(offsets.getZ(), offsets.getY(), offsets.getX()).mul(offsets.getScale()).mul((Matrix3fc)this.rotation);
        this.position = this.position.m_82520_((double)offset.x(), (double)offset.y(), (double)offset.z());
        this.rotation.rotateLocal((float)orientation * (float)Math.toRadians(offsets.getYaw()), this.rotation.m10, this.rotation.m11, this.rotation.m12);
        this.rotation.rotateLocal((float)orientation * (float)Math.toRadians(offsets.getPitch()), this.rotation.m00, this.rotation.m01, this.rotation.m02);
        this.rotation.rotateLocal((float)orientation * (float)Math.toRadians(offsets.getRoll()), this.rotation.m20, this.rotation.m21, this.rotation.m22);
        return this;
    }
}

