/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.config;

import com.mojang.blaze3d.platform.InputConstants;
import com.xtracr.realcamera.RealCameraCore;
import com.xtracr.realcamera.config.BindTarget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.util.Mth;

public class ModConfig {
    public static final double MIN_OFFSET_D = -1.0;
    public static final double MAX_OFFSET_D = 1.0;
    public static final float MIN_OFFSET_F = -1.0f;
    public static final float MAX_OFFSET_F = 1.0f;
    public boolean enabled = false;
    public boolean isClassic = false;
    public boolean dynamicCrosshair = false;
    public boolean renderModel = true;
    public double adjustStep = 0.01;
    public Classic classic = new Classic();
    public Binding binding = new Binding();

    public void set(ModConfig modConfig) {
        this.enabled = modConfig.enabled;
        this.isClassic = modConfig.isClassic;
        this.dynamicCrosshair = modConfig.dynamicCrosshair;
        this.renderModel = modConfig.renderModel;
        this.adjustStep = modConfig.adjustStep;
        this.classic = modConfig.classic;
        this.binding = modConfig.binding;
    }

    public void clamp() {
        this.adjustStep = Mth.m_14008_((double)this.adjustStep, (double)0.0, (double)1.0);
        this.classic.clamp();
        this.binding.clamp();
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public boolean isClassic() {
        return this.isClassic;
    }

    public void setClassic(boolean value) {
        this.isClassic = value;
    }

    public boolean dynamicCrosshair() {
        return this.dynamicCrosshair;
    }

    public boolean renderModel() {
        return this.renderModel;
    }

    public void cycleAdjustMode() {
        if (this.isClassic) {
            this.classic.adjustMode = this.classic.adjustMode.cycle();
        } else {
            this.binding.adjustOffset = !this.binding.adjustOffset;
        }
    }

    public void adjustOffsetX(int count) {
        if (this.isClassic) {
            switch (this.classic.adjustMode) {
                case CENTER: {
                    this.classic.centerX += (double)count * this.adjustStep;
                    break;
                }
                case ROTATION: {
                    this.classic.roll += (float)(count * 100) * (float)this.adjustStep;
                    break;
                }
                default: {
                    this.classic.cameraX += (double)count * this.adjustStep;
                }
            }
            this.classic.clamp();
        } else {
            BindTarget target = RealCameraCore.currentTarget();
            if (this.binding.adjustOffset) {
                target.offsets().setX(target.offsets().getX() + (float)count * (float)this.adjustStep);
            } else {
                target.offsets().setRoll(target.offsets().getRoll() + (float)(count * 100) * (float)this.adjustStep);
            }
        }
    }

    public void adjustOffsetY(int count) {
        if (this.isClassic) {
            switch (this.classic.adjustMode) {
                case CENTER: {
                    this.classic.centerY += (double)count * this.adjustStep;
                    break;
                }
                case ROTATION: {
                    this.classic.yaw += (float)(count * 100) * (float)this.adjustStep;
                    break;
                }
                default: {
                    this.classic.cameraY += (double)count * this.adjustStep;
                }
            }
            this.classic.clamp();
        } else {
            BindTarget target = RealCameraCore.currentTarget();
            if (this.binding.adjustOffset) {
                target.offsets().setY(target.offsets().getY() + (float)count * (float)this.adjustStep);
            } else {
                target.offsets().setYaw(target.offsets().getYaw() + (float)(count * 100) * (float)this.adjustStep);
            }
        }
    }

    public void adjustOffsetZ(int count) {
        if (this.isClassic) {
            switch (this.classic.adjustMode) {
                case CENTER: {
                    this.classic.centerZ += (double)count * this.adjustStep;
                    break;
                }
                case ROTATION: {
                    this.classic.pitch += (float)(count * 100) * (float)this.adjustStep;
                    break;
                }
                default: {
                    this.classic.cameraZ += (double)count * this.adjustStep;
                }
            }
            this.classic.clamp();
        } else {
            BindTarget target = RealCameraCore.currentTarget();
            if (this.binding.adjustOffset) {
                target.offsets().setZ(target.offsets().getZ() + (float)count * (float)this.adjustStep);
            } else {
                target.offsets().setPitch(target.offsets().getPitch() + (float)(count * 100) * (float)this.adjustStep);
            }
        }
    }

    public boolean classicDisableWhenSneaking() {
        return this.classic.disableWhenSneaking;
    }

    public boolean classicDisableWhenSwimming() {
        return this.classic.disableWhenSwimming;
    }

    public int getClassicSwimOutTick() {
        return this.classic.swimOutTick;
    }

    public double getClassicX() {
        return this.classic.cameraX * this.classic.scale;
    }

    public double getClassicY() {
        return this.classic.cameraY * this.classic.scale;
    }

    public double getClassicZ() {
        return this.classic.cameraZ * this.classic.scale;
    }

    public double getCenterX() {
        return this.classic.centerX * this.classic.scale;
    }

    public double getCenterY() {
        return this.classic.centerY * this.classic.scale;
    }

    public double getCenterZ() {
        return this.classic.centerZ * this.classic.scale;
    }

    public float getClassicPitch() {
        return this.classic.pitch;
    }

    public float getClassicYaw() {
        return this.classic.yaw;
    }

    public float getClassicRoll() {
        return this.classic.roll;
    }

    public InputConstants.Key getScreenModifierKey() {
        return InputConstants.m_84851_((String)this.binding.screenModifierKey);
    }

    public boolean legacyBindingMode() {
        return this.binding.legacyBindingMode;
    }

    public boolean renderStuckObjects() {
        return this.binding.renderStuckObjects;
    }

    public boolean hideBindingFailureMessage() {
        return this.binding.hideFailureMessage;
    }

    public boolean bindingDisableWhenSneaking() {
        return this.binding.disableWhenSneaking;
    }

    public boolean bindingDisableWhenSwimming() {
        return this.binding.disableWhenSwimming;
    }

    public int getBindingSwimOutTick() {
        return this.binding.swimOutTick;
    }

    public int getBindResultRetentionFrames() {
        return this.binding.bindResultRetentionFrames;
    }

    public double getDisplacementSmoothFactor() {
        return this.binding.displacementSmoothFactor;
    }

    public double getRotationSmoothFactor() {
        return this.binding.rotationSmoothFactor;
    }

    public List<String> getDisableMainFeatureItems() {
        return this.binding.disableMainFeatureItems;
    }

    public List<String> getDisableRenderItems() {
        return this.binding.disableRenderItems;
    }

    public List<BindTarget> getFixedTargetList() {
        return this.binding.fixedTargetList;
    }

    public List<BindTarget> getBindTargetList() {
        this.binding.clamp();
        return this.binding.targetList;
    }

    public void putBindTarget(BindTarget target) {
        if (target.isEmpty()) {
            return;
        }
        List<BindTarget> fixedList = this.binding.fixedTargetList;
        int size = fixedList.size();
        for (int i2 = 0; i2 < size; ++i2) {
            if (!fixedList.get(i2).name().equals(target.name())) continue;
            fixedList.set(i2, target);
            return;
        }
        List<BindTarget> list = this.binding.targetList;
        IntStream.range(0, list.size()).filter(i -> ((BindTarget)list.get(i)).name().equals(target.name())).findAny().ifPresentOrElse(i -> list.set(i, target), () -> list.add(target));
        list.sort(Comparator.comparingInt(t -> -t.priority()));
    }

    public static class Classic {
        public AdjustMode adjustMode = AdjustMode.CAMERA;
        public boolean disableWhenSneaking = false;
        public boolean disableWhenSwimming = false;
        public int swimOutTick = 13;
        public double scale = 8.0;
        public double cameraX = -0.5;
        public double cameraY = 0.04;
        public double cameraZ = -0.15;
        public double centerX = 0.0;
        public double centerY = 0.0;
        public double centerZ = 0.0;
        public float pitch = 0.0f;
        public float yaw = 18.0f;
        public float roll = 0.0f;

        private void clamp() {
            if (this.adjustMode == null) {
                this.adjustMode = AdjustMode.CAMERA;
            }
            this.swimOutTick = Mth.m_14045_((int)this.swimOutTick, (int)0, (int)40);
            this.scale = Mth.m_14008_((double)this.scale, (double)0.0, (double)64.0);
            this.cameraX = Mth.m_14008_((double)this.cameraX, (double)-1.0, (double)1.0);
            this.cameraY = Mth.m_14008_((double)this.cameraY, (double)-1.0, (double)1.0);
            this.cameraZ = Mth.m_14008_((double)this.cameraZ, (double)-1.0, (double)1.0);
            this.centerX = Mth.m_14008_((double)this.centerX, (double)-1.0, (double)1.0);
            this.centerY = Mth.m_14008_((double)this.centerY, (double)-1.0, (double)1.0);
            this.centerZ = Mth.m_14008_((double)this.centerZ, (double)-1.0, (double)1.0);
            this.pitch = Mth.m_14177_((float)this.pitch);
            this.yaw = Mth.m_14177_((float)this.yaw);
            this.roll = Mth.m_14177_((float)this.roll);
        }

        public static enum AdjustMode {
            CAMERA,
            CENTER,
            ROTATION;

            private static final AdjustMode[] VALUES;

            public AdjustMode cycle() {
                return VALUES[(this.ordinal() + 1) % VALUES.length];
            }

            static {
                VALUES = AdjustMode.values();
            }
        }
    }

    public static class Binding {
        protected static final List<String> defaultDisableRenderItems = List.of("minecraft:filled_map");
        public String screenModifierKey = InputConstants.Type.KEYSYM.m_84895_(342).m_84874_();
        public boolean legacyBindingMode = false;
        public boolean adjustOffset = true;
        public boolean hideFailureMessage = false;
        public boolean renderStuckObjects = true;
        public boolean disableWhenSneaking = false;
        public boolean disableWhenSwimming = false;
        public int swimOutTick = 13;
        public int bindResultRetentionFrames = 2;
        public double displacementSmoothFactor = 0.4;
        public double rotationSmoothFactor = 0.4;
        public List<String> disableMainFeatureItems = List.of();
        public List<String> disableRenderItems = defaultDisableRenderItems;
        public List<BindTarget> fixedTargetList = new ArrayList<BindTarget>();
        public List<BindTarget> targetList = new ArrayList<BindTarget>(BindTarget.defaultTargets);

        private void clamp() {
            try {
                InputConstants.m_84851_((String)this.screenModifierKey);
            }
            catch (Exception e) {
                this.screenModifierKey = InputConstants.Type.KEYSYM.m_84895_(342).m_84874_();
            }
            this.swimOutTick = Mth.m_14045_((int)this.swimOutTick, (int)0, (int)40);
            this.bindResultRetentionFrames = Math.max(this.bindResultRetentionFrames, 0);
            this.displacementSmoothFactor = Mth.m_14008_((double)this.displacementSmoothFactor, (double)0.0, (double)1.0);
            this.rotationSmoothFactor = Mth.m_14008_((double)this.rotationSmoothFactor, (double)0.0, (double)1.0);
            if (this.disableMainFeatureItems == null) {
                this.disableMainFeatureItems = List.of();
            }
            if (this.disableRenderItems == null) {
                this.disableRenderItems = List.of();
            }
            if (this.fixedTargetList == null) {
                this.fixedTargetList = new ArrayList<BindTarget>();
            } else {
                this.fixedTargetList.removeIf(BindTarget::isEmpty);
            }
            if (this.targetList == null) {
                this.targetList = new ArrayList<BindTarget>(BindTarget.defaultTargets);
            } else {
                this.targetList.removeIf(BindTarget::isEmpty);
                if (this.targetList.isEmpty()) {
                    this.targetList = new ArrayList<BindTarget>(BindTarget.defaultTargets);
                }
            }
        }
    }
}

