/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.gui;

import com.xtracr.realcamera.gui.TexturedButton;
import java.util.function.IntConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class CyclingTexturedButton
extends AbstractButton {
    protected final ResourceLocation texture;
    protected final int textureWidth;
    protected final int textureHeight;
    protected final int u;
    protected final int v;
    protected final int vOffset;
    protected final int size;
    @Nullable
    private IntConsumer onValueChange;
    private int value;

    public CyclingTexturedButton(int u, int v, int value, int size) {
        this(0, 0, 16, 16, u, v, value, size);
    }

    public CyclingTexturedButton(int x, int y, int width, int height, int u, int v, int value, int size) {
        this(x, y, width, height, u, v, height, value, size, TexturedButton.ICON_TEXTURE, 256, 256);
    }

    public CyclingTexturedButton(int x, int y, int width, int height, int u, int v, int vOffset, int value, int size, ResourceLocation texture, int textureWidth, int textureHeight) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.u = u;
        this.v = v;
        this.vOffset = vOffset;
        this.size = size;
        this.texture = texture;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.setValue(value);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = (value % this.size + this.size) % this.size;
    }

    public CyclingTexturedButton setOnValueChange(IntConsumer onValueChange) {
        this.onValueChange = onValueChange;
        return this;
    }

    public void m_5691_() {
        if (Screen.m_96638_()) {
            this.setValue(this.value - 1);
        } else {
            this.setValue(this.value + 1);
        }
        if (this.onValueChange != null) {
            this.onValueChange.accept(this.value);
        }
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float deltaTick) {
        graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), -10197916);
        graphics.m_280163_(this.texture, this.m_252754_(), this.m_252907_(), (float)this.u, (float)(this.v + this.value * this.vOffset), this.f_93618_, this.f_93619_, this.textureWidth, this.textureHeight);
        if (this.m_198029_()) {
            graphics.m_280637_(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), -1);
        }
    }

    protected void m_168797_(NarrationElementOutput builder) {
        this.m_168802_(builder);
    }
}

