/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.gui;

import com.xtracr.realcamera.util.LocUtil;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public abstract class NumberField<T extends Comparable<T>>
extends EditBox {
    private final T defaultValue;
    protected T maximum;
    protected T minimum;
    private Tooltip tooltip;

    NumberField(Font font, int width, int height, T defaultValue, T maximum, T minimum, @Nullable NumberField<T> copyFrom) {
        super(font, 0, 0, width, height, (Component)Component.m_237119_());
        this.defaultValue = defaultValue;
        this.maximum = maximum;
        this.minimum = minimum;
        this.setNumber(defaultValue);
        if (copyFrom != null) {
            this.setNumber(copyFrom.getNumber());
        }
    }

    public static NumberField<Float> ofFloat(Font font, int width, int height, float defaultValue, @Nullable NumberField<Float> copyFrom) {
        return new FloatField(font, width, height, defaultValue, copyFrom);
    }

    public static NumberField<Integer> ofInt(Font font, int width, int height, int defaultValue, @Nullable NumberField<Integer> copyFrom) {
        return new IntField(font, width, height, defaultValue, copyFrom);
    }

    public T getNumber() {
        try {
            return this.getNumberInternal();
        }
        catch (Exception e) {
            return this.defaultValue;
        }
    }

    public void setNumber(T value) {
        try {
            if (value.compareTo(this.minimum) < 0) {
                value = this.minimum;
            } else if (value.compareTo(this.maximum) > 0) {
                value = this.maximum;
            }
            this.m_94144_(value.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public NumberField<T> setMax(T maximum) {
        this.maximum = maximum;
        return this;
    }

    public NumberField<T> setMin(T minimum) {
        this.minimum = minimum;
        return this;
    }

    public NumberField<T> setOnValueChange(Consumer<T> consumer) {
        super.m_94151_(str -> consumer.accept(this.getNumber()));
        return this;
    }

    protected abstract T getNumberInternal();

    protected void checkText() {
        super.m_257544_(this.tooltip);
        this.m_94149_((string, firstCharacterIndex) -> FormattedCharSequence.m_13714_((String)string, (Style)Style.f_131099_));
        if (this.m_94155_().isEmpty()) {
            return;
        }
        try {
            T value = this.getNumberInternal();
            if (value.compareTo(this.minimum) < 0) {
                throw new Exception("< " + String.valueOf(this.minimum));
            }
            if (value.compareTo(this.maximum) > 0) {
                throw new Exception("> " + String.valueOf(this.maximum));
            }
        }
        catch (Exception e) {
            super.m_257544_(Tooltip.m_257550_((Component)LocUtil.literal("Invalid number: " + e.getMessage()).m_130938_(s -> s.m_131140_(ChatFormatting.RED))));
            this.m_94149_((string, firstCharacterIndex) -> FormattedCharSequence.m_13714_((String)string, (Style)Style.f_131099_.m_131140_(ChatFormatting.RED)));
        }
    }

    public void m_257544_(Tooltip tooltip) {
        this.tooltip = tooltip;
        super.m_257544_(tooltip);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (CommonInputs.m_278691_((int)keyCode)) {
            this.m_93692_(false);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char chr, int modifiers) {
        if (chr != '-' && chr != '.' && (chr < '0' || chr > '9')) {
            return false;
        }
        return super.m_5534_(chr, modifiers);
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float deltaTick) {
        this.checkText();
        super.m_87963_(graphics, mouseX, mouseY, deltaTick);
    }

    private static class FloatField
    extends NumberField<Float> {
        FloatField(Font font, int width, int height, float defaultValue, @Nullable NumberField<Float> copyFrom) {
            super(font, width, height, Float.valueOf(defaultValue), Float.valueOf(Float.MAX_VALUE), Float.valueOf(-3.4028235E38f), copyFrom);
            this.m_94199_(16);
        }

        @Override
        protected Float getNumberInternal() {
            return Float.valueOf(Float.parseFloat(this.m_94155_()));
        }
    }

    private static class IntField
    extends NumberField<Integer> {
        IntField(Font font, int width, int height, int defaultValue, @Nullable NumberField<Integer> copyFrom) {
            super(font, width, height, defaultValue, Integer.MAX_VALUE, Integer.MIN_VALUE, copyFrom);
            this.m_94199_(8);
        }

        @Override
        protected Integer getNumberInternal() {
            return Integer.parseInt(this.m_94155_());
        }
    }
}

