/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.mixin;

import com.xtracr.realcamera.RealCameraCore;
import com.xtracr.realcamera.config.ConfigFile;
import com.xtracr.realcamera.config.ModConfig;
import com.xtracr.realcamera.mixin.accessor.GameRendererAccessor;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Camera.class})
public abstract class MixinCamera {
    @Shadow
    private BlockGetter f_90550_;
    @Shadow
    private Vec3 f_90552_;
    @Shadow
    private float f_90557_;
    @Shadow
    private float f_90558_;

    @Inject(method={"setup"}, at={@At(value="RETURN")})
    private void realcamera$setupCamera(BlockGetter area, Entity entity, boolean thirdPerson, boolean inverseView, float deltaTick, CallbackInfo ci) {
        if (!RealCameraCore.isActive()) {
            return;
        }
        ModConfig config = ConfigFile.config();
        Vec3 startVec = this.f_90552_;
        AABB box = entity.m_20191_();
        if (config.isClassic()) {
            double d;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                d = livingEntity.m_6134_();
            } else {
                d = 1.0;
            }
            double scale = d;
            Vec3 offset = new Vec3(config.getClassicX(), config.getClassicY(), config.getClassicZ()).m_82490_(scale);
            Vec3 center = new Vec3(config.getCenterX(), config.getCenterY(), config.getCenterZ()).m_82490_(scale);
            float newPitch = this.f_90557_ + config.getClassicPitch();
            float newYaw = this.f_90558_ - config.getClassicYaw();
            this.m_90572_(this.f_90558_, 0.0f);
            this.m_90568_(center.m_7096_(), center.m_7098_(), center.m_7094_());
            this.m_90572_(newYaw, newPitch);
            this.m_90568_(offset.m_7096_(), offset.m_7098_(), offset.m_7094_());
        } else {
            Vec3 entityPos = entity.m_20182_().m_82549_(entity.m_20182_().m_82492_(entity.f_19790_, entity.f_19791_, entity.f_19792_).m_82490_(entity.f_19797_ == 0 ? 0.0 : (double)(deltaTick - 1.0f)));
            Vec3 rawPos = RealCameraCore.getRawPos(this.f_90552_, entityPos);
            double restrictedY = Mth.m_14008_((double)rawPos.m_7098_(), (double)(box.f_82289_ + 0.1), (double)(box.f_82292_ - 0.1));
            startVec = new Vec3(this.f_90552_.m_7096_(), restrictedY, this.f_90552_.m_7094_());
            this.m_90581_(rawPos);
            this.m_90572_(RealCameraCore.getYaw(this.f_90558_), RealCameraCore.getPitch(this.f_90557_));
        }
        this.realcamera$clipToSpace(startVec, entity, MixinCamera.realcamera$getFov(deltaTick));
        RealCameraCore.setCameraPos(this.f_90552_);
    }

    @Unique
    private void realcamera$clipToSpace(Vec3 startVec, Entity entity, double fov) {
        Vec3 offset = this.f_90552_.m_82546_(startVec);
        float depth = 0.05f + (float)(fov * (1.0E-4 + 5.0E-6 * fov));
        for (int i = 0; i < 8; ++i) {
            float f = depth * (float)((i & 1) * 2 - 1);
            float g = depth * (float)((i >> 1 & 1) * 2 - 1);
            float h = depth * (float)((i >> 2 & 1) * 2 - 1);
            Vec3 start = startVec.m_82520_((double)f, (double)g, (double)h);
            Vec3 end = startVec.m_82549_(offset).m_82520_((double)f, (double)g, (double)h);
            BlockHitResult hitResult = this.f_90550_.m_45547_(new ClipContext(start, end, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, entity));
            double l = hitResult.m_82450_().m_82554_(start);
            if (hitResult.m_6662_() == HitResult.Type.MISS || l >= offset.m_82553_()) continue;
            offset = offset.m_82490_(l / offset.m_82553_());
        }
        this.m_90581_(startVec.m_82549_(offset));
    }

    @Unique
    private static float realcamera$getFov(float deltaTick) {
        Minecraft client = Minecraft.m_91087_();
        float fovModifier = Mth.m_14179_((float)deltaTick, (float)((GameRendererAccessor)client.f_91063_).getOldFov(), (float)((GameRendererAccessor)client.f_91063_).getFov());
        return (float)((Integer)client.f_91066_.m_231837_().m_231551_()).intValue() * fovModifier;
    }

    @Shadow
    protected abstract void m_90568_(double var1, double var3, double var5);

    @Shadow
    protected abstract void m_90572_(float var1, float var2);

    @Shadow
    protected abstract void m_90581_(Vec3 var1);
}

