/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.util;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.xtracr.realcamera.util.VertexData;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class IterableVertexBuffer
implements Iterable<VertexData> {
    private static final boolean IS_LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    public final int vertexCount;
    public final int vertexSize;
    private final VertexData.MutableVertex reusableVertex = VertexData.mutable();
    private final Iterable<VertexData[]> primitives;
    private final ByteBuffer buffer;
    private final int positionOffset;
    private final int colorOffset;
    private final int uvOffset;
    private final int overlayOffset;
    private final int lightOffset;
    private final int normalOffset;
    private final boolean hasPosition;
    private final boolean hasColor;
    private final boolean hasUV;
    private final boolean hasOverlay;
    private final boolean hasLight;
    private final boolean hasNormal;
    private final boolean fastFormat;

    public IterableVertexBuffer(BufferBuilder.RenderedBuffer meshData) {
        this.buffer = meshData.m_231196_();
        BufferBuilder.DrawState drawState = meshData.m_231198_();
        VertexFormat format = drawState.f_85733_();
        this.vertexCount = drawState.f_85734_();
        this.vertexSize = format.m_86020_();
        int offset = 0;
        int po = -1;
        int co = -1;
        int uo = -1;
        int oo = -1;
        int lo = -1;
        int no = -1;
        for (VertexFormatElement element : format.m_86023_()) {
            switch (element.m_86048_()) {
                case POSITION: {
                    po = offset;
                    break;
                }
                case COLOR: {
                    co = offset;
                    break;
                }
                case UV: {
                    switch (element.m_86049_()) {
                        case 0: {
                            uo = offset;
                            break;
                        }
                        case 1: {
                            oo = offset;
                            break;
                        }
                        case 2: {
                            lo = offset;
                        }
                    }
                    break;
                }
                case NORMAL: {
                    no = offset;
                }
            }
            offset += element.m_86050_();
        }
        this.positionOffset = po;
        this.colorOffset = co;
        this.uvOffset = uo;
        this.overlayOffset = oo;
        this.lightOffset = lo;
        this.normalOffset = no;
        this.hasPosition = this.positionOffset != -1;
        this.hasColor = this.colorOffset != -1;
        this.hasUV = this.uvOffset != -1;
        this.hasOverlay = this.overlayOffset != -1;
        this.hasLight = this.lightOffset != -1;
        this.hasNormal = this.normalOffset != -1;
        this.fastFormat = format == DefaultVertexFormat.f_85812_;
        boolean isQuad = drawState.f_85735_() == VertexFormat.Mode.QUADS;
        this.primitives = this.fastFormat && isQuad ? new FastQuadReader() : new PrimitiveReader(drawState.f_85735_());
    }

    public Iterable<VertexData[]> primitives() {
        return this.primitives;
    }

    public Stream<VertexData> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Stream<VertexData[]> primitiveStream() {
        return StreamSupport.stream(this.primitives.spliterator(), false);
    }

    public VertexData readVertexAt(int index) {
        return this.readVertexAt(index, this.reusableVertex);
    }

    public VertexData.MutableVertex readVertexAt(int index, VertexData.MutableVertex mutable) {
        int offset;
        Objects.checkIndex(index, this.vertexCount);
        int vertexOffset = index * this.vertexSize;
        if (this.fastFormat) {
            mutable.x = this.buffer.getFloat(vertexOffset);
            mutable.y = this.buffer.getFloat(vertexOffset + 4);
            mutable.z = this.buffer.getFloat(vertexOffset + 8);
            mutable.argb = this.readColor(vertexOffset + 12);
            mutable.u = this.buffer.getFloat(vertexOffset + 16);
            mutable.v = this.buffer.getFloat(vertexOffset + 20);
            mutable.overlay = this.buffer.getInt(vertexOffset + 24);
            mutable.light = this.buffer.getInt(vertexOffset + 28);
            mutable.normalX = (float)this.buffer.get(vertexOffset + 32) / 127.0f;
            mutable.normalY = (float)this.buffer.get(vertexOffset + 33) / 127.0f;
            mutable.normalZ = (float)this.buffer.get(vertexOffset + 34) / 127.0f;
            return mutable;
        }
        if (this.hasPosition) {
            offset = vertexOffset + this.positionOffset;
            mutable.x = this.buffer.getFloat(offset);
            mutable.y = this.buffer.getFloat(offset + 4);
            mutable.z = this.buffer.getFloat(offset + 8);
        }
        if (this.hasColor) {
            mutable.argb = this.readColor(vertexOffset + this.colorOffset);
        }
        if (this.hasUV) {
            offset = vertexOffset + this.uvOffset;
            mutable.u = this.buffer.getFloat(offset);
            mutable.v = this.buffer.getFloat(offset + 4);
        }
        if (this.hasOverlay) {
            mutable.overlay = this.buffer.getInt(vertexOffset + this.overlayOffset);
        }
        if (this.hasLight) {
            mutable.light = this.buffer.getInt(vertexOffset + this.lightOffset);
        }
        if (this.hasNormal) {
            offset = vertexOffset + this.normalOffset;
            mutable.normalX = (float)this.buffer.get(offset) / 127.0f;
            mutable.normalY = (float)this.buffer.get(offset + 1) / 127.0f;
            mutable.normalZ = (float)this.buffer.get(offset + 2) / 127.0f;
        }
        return mutable;
    }

    @Override
    @NotNull
    public Iterator<VertexData> iterator() {
        return new VertexIterator();
    }

    @Override
    public Spliterator<VertexData> spliterator() {
        return new VertexSpliterator(0, this.vertexCount);
    }

    private int readColor(int offset) {
        int abgr = IS_LITTLE_ENDIAN ? this.buffer.getInt(offset) : Integer.reverseBytes(this.buffer.getInt(offset));
        return abgr & 0xFF00FF00 | (abgr & 0xFF0000) >> 16 | (abgr & 0xFF) << 16;
    }

    private class FastQuadReader
    implements Iterable<VertexData[]> {
        private final int quadCount;

        private FastQuadReader() {
            this.quadCount = IterableVertexBuffer.this.vertexCount / 4;
        }

        @Override
        @NotNull
        public Iterator<VertexData[]> iterator() {
            return new FastQuadIterator();
        }

        @Override
        public Spliterator<VertexData[]> spliterator() {
            return new FastQuadSpliterator(0, this.quadCount);
        }

        private void fastReadQuadAt(int index, VertexData.MutableVertex[] quad) {
            int vertexOffset = index * 144;
            int i = 0;
            while (i < 4) {
                VertexData.MutableVertex mutable = quad[i];
                mutable.x = IterableVertexBuffer.this.buffer.getFloat(vertexOffset);
                mutable.y = IterableVertexBuffer.this.buffer.getFloat(vertexOffset + 4);
                mutable.z = IterableVertexBuffer.this.buffer.getFloat(vertexOffset + 8);
                mutable.argb = IterableVertexBuffer.this.readColor(vertexOffset + 12);
                mutable.u = IterableVertexBuffer.this.buffer.getFloat(vertexOffset + 16);
                mutable.v = IterableVertexBuffer.this.buffer.getFloat(vertexOffset + 20);
                mutable.overlay = IterableVertexBuffer.this.buffer.getInt(vertexOffset + 24);
                mutable.light = IterableVertexBuffer.this.buffer.getInt(vertexOffset + 28);
                mutable.normalX = (float)IterableVertexBuffer.this.buffer.get(vertexOffset + 32) / 127.0f;
                mutable.normalY = (float)IterableVertexBuffer.this.buffer.get(vertexOffset + 33) / 127.0f;
                mutable.normalZ = (float)IterableVertexBuffer.this.buffer.get(vertexOffset + 34) / 127.0f;
                ++i;
                vertexOffset += 36;
            }
        }

        private class FastQuadIterator
        implements Iterator<VertexData[]> {
            private final VertexData.MutableVertex[] reusableQuad = new VertexData.MutableVertex[4];
            private int currentIndex = 0;

            public FastQuadIterator() {
                for (int i = 0; i < 4; ++i) {
                    this.reusableQuad[i] = VertexData.mutable();
                }
            }

            @Override
            public boolean hasNext() {
                return this.currentIndex < FastQuadReader.this.quadCount - 1;
            }

            @Override
            public VertexData[] next() {
                FastQuadReader.this.fastReadQuadAt(this.currentIndex, this.reusableQuad);
                ++this.currentIndex;
                return this.reusableQuad;
            }
        }

        private class FastQuadSpliterator
        implements Spliterator<VertexData[]> {
            private final VertexData.MutableVertex[] reusableQuad = new VertexData.MutableVertex[4];
            private final int endIndex;
            private int currentIndex;

            public FastQuadSpliterator(int start, int end) {
                this.currentIndex = start;
                this.endIndex = end;
                for (int i = 0; i < 4; ++i) {
                    this.reusableQuad[i] = VertexData.mutable();
                }
            }

            @Override
            public boolean tryAdvance(Consumer<? super VertexData[]> action) {
                if (this.currentIndex < this.endIndex) {
                    FastQuadReader.this.fastReadQuadAt(this.currentIndex, this.reusableQuad);
                    action.accept((VertexData[])this.reusableQuad);
                    ++this.currentIndex;
                    return true;
                }
                return false;
            }

            @Override
            public Spliterator<VertexData[]> trySplit() {
                int remaining = this.endIndex - this.currentIndex;
                if (remaining <= 1) {
                    return null;
                }
                int splitPos = this.currentIndex + remaining / 2;
                FastQuadSpliterator newSpliterator = new FastQuadSpliterator(this.currentIndex, splitPos);
                this.currentIndex = splitPos;
                return newSpliterator;
            }

            @Override
            public long estimateSize() {
                return this.endIndex - this.currentIndex;
            }

            @Override
            public int characteristics() {
                return 16720;
            }
        }
    }

    private class PrimitiveReader
    implements Iterable<VertexData[]> {
        private final int primitiveLength;
        private final int primitiveStride;
        private final int primitiveCount;
        private final boolean startWithFirst;

        public PrimitiveReader(VertexFormat.Mode drawMode) {
            this.primitiveLength = drawMode.f_166947_;
            this.primitiveStride = drawMode.f_166948_;
            this.primitiveCount = (IterableVertexBuffer.this.vertexCount - this.primitiveLength) / this.primitiveStride + 1;
            this.startWithFirst = drawMode == VertexFormat.Mode.TRIANGLE_FAN;
        }

        @Override
        @NotNull
        public Iterator<VertexData[]> iterator() {
            return new PrimitiveIterator();
        }

        @Override
        public Spliterator<VertexData[]> spliterator() {
            return new PrimitiveSpliterator(0, this.primitiveCount);
        }

        private void readPrimitiveAt(int index, VertexData.MutableVertex[] primitive) {
            int i;
            int vertexIndex = index * this.primitiveStride;
            int n = i = this.startWithFirst ? 1 : 0;
            while (i < this.primitiveLength) {
                IterableVertexBuffer.this.readVertexAt(vertexIndex + i, primitive[i]);
                ++i;
            }
        }

        private class PrimitiveIterator
        implements Iterator<VertexData[]> {
            private final VertexData.MutableVertex[] reusablePrimitive;
            private int currentIndex;

            public PrimitiveIterator() {
                this.reusablePrimitive = new VertexData.MutableVertex[PrimitiveReader.this.primitiveLength];
                this.currentIndex = 0;
                for (int i = 0; i < PrimitiveReader.this.primitiveLength; ++i) {
                    this.reusablePrimitive[i] = VertexData.mutable();
                }
                if (0 < IterableVertexBuffer.this.vertexCount) {
                    IterableVertexBuffer.this.readVertexAt(0, this.reusablePrimitive[0]);
                }
            }

            @Override
            public boolean hasNext() {
                return this.currentIndex < PrimitiveReader.this.primitiveCount - 1;
            }

            @Override
            public VertexData[] next() {
                PrimitiveReader.this.readPrimitiveAt(this.currentIndex, this.reusablePrimitive);
                ++this.currentIndex;
                return this.reusablePrimitive;
            }
        }

        private class PrimitiveSpliterator
        implements Spliterator<VertexData[]> {
            private final VertexData.MutableVertex[] reusablePrimitive;
            private final int endIndex;
            private int currentIndex;

            public PrimitiveSpliterator(int start, int end) {
                this.reusablePrimitive = new VertexData.MutableVertex[PrimitiveReader.this.primitiveLength];
                this.currentIndex = start;
                this.endIndex = end;
                for (int i = 0; i < PrimitiveReader.this.primitiveLength; ++i) {
                    this.reusablePrimitive[i] = VertexData.mutable();
                }
                if (0 < IterableVertexBuffer.this.vertexCount) {
                    IterableVertexBuffer.this.readVertexAt(0, this.reusablePrimitive[0]);
                }
            }

            @Override
            public boolean tryAdvance(Consumer<? super VertexData[]> action) {
                if (this.currentIndex < this.endIndex) {
                    PrimitiveReader.this.readPrimitiveAt(this.currentIndex, this.reusablePrimitive);
                    action.accept((VertexData[])this.reusablePrimitive);
                    ++this.currentIndex;
                    return true;
                }
                return false;
            }

            @Override
            public Spliterator<VertexData[]> trySplit() {
                int remaining = this.endIndex - this.currentIndex;
                if (remaining <= 1) {
                    return null;
                }
                int splitPos = this.currentIndex + remaining / 2;
                PrimitiveSpliterator newSpliterator = new PrimitiveSpliterator(this.currentIndex, splitPos);
                this.currentIndex = splitPos;
                return newSpliterator;
            }

            @Override
            public long estimateSize() {
                return this.endIndex - this.currentIndex;
            }

            @Override
            public int characteristics() {
                return 16720;
            }
        }
    }

    private class VertexIterator
    extends VertexPointer
    implements Iterator<VertexData> {
        private final int byteCount;

        private VertexIterator() {
            this.byteCount = IterableVertexBuffer.this.vertexCount * IterableVertexBuffer.this.vertexSize;
        }

        @Override
        public boolean hasNext() {
            return this.bytePointer < this.byteCount - IterableVertexBuffer.this.vertexSize;
        }

        @Override
        @NotNull
        public VertexData next() {
            this.bytePointer += IterableVertexBuffer.this.vertexSize;
            return this;
        }
    }

    private class VertexSpliterator
    extends VertexPointer
    implements Spliterator<VertexData> {
        private final int endIndex;
        private int currentIndex;

        public VertexSpliterator(int start, int end) {
            this.currentIndex = start;
            this.endIndex = end;
        }

        @Override
        public boolean tryAdvance(Consumer<? super VertexData> action) {
            if (this.currentIndex < this.endIndex) {
                this.bytePointer = this.currentIndex * IterableVertexBuffer.this.vertexSize;
                action.accept(this);
                ++this.currentIndex;
                return true;
            }
            return false;
        }

        @Override
        public Spliterator<VertexData> trySplit() {
            int remaining = this.endIndex - this.currentIndex;
            if (remaining <= 1) {
                return null;
            }
            int splitPos = this.currentIndex + remaining / 2;
            VertexSpliterator newSpliterator = new VertexSpliterator(this.currentIndex, splitPos);
            this.currentIndex = splitPos;
            return newSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.endIndex - this.currentIndex;
        }

        @Override
        public int characteristics() {
            return 16720;
        }
    }

    private class VertexPointer
    implements VertexData {
        protected int bytePointer = 0;

        private VertexPointer() {
        }

        @Override
        public float x() {
            if (IterableVertexBuffer.this.hasPosition) {
                return IterableVertexBuffer.this.buffer.getFloat(this.bytePointer + IterableVertexBuffer.this.positionOffset);
            }
            return 0.0f;
        }

        @Override
        public float y() {
            if (IterableVertexBuffer.this.hasPosition) {
                return IterableVertexBuffer.this.buffer.getFloat(this.bytePointer + IterableVertexBuffer.this.positionOffset + 4);
            }
            return 0.0f;
        }

        @Override
        public float z() {
            if (IterableVertexBuffer.this.hasPosition) {
                return IterableVertexBuffer.this.buffer.getFloat(this.bytePointer + IterableVertexBuffer.this.positionOffset + 8);
            }
            return 0.0f;
        }

        @Override
        public Vec3 position() {
            if (IterableVertexBuffer.this.hasPosition) {
                return new Vec3((double)IterableVertexBuffer.this.buffer.getFloat(this.bytePointer + IterableVertexBuffer.this.positionOffset), (double)IterableVertexBuffer.this.buffer.getFloat(this.bytePointer + IterableVertexBuffer.this.positionOffset + 4), (double)IterableVertexBuffer.this.buffer.getFloat(this.bytePointer + IterableVertexBuffer.this.positionOffset + 8));
            }
            return Vec3.f_82478_;
        }

        @Override
        public int argb() {
            if (IterableVertexBuffer.this.hasColor) {
                return IterableVertexBuffer.this.readColor(this.bytePointer + IterableVertexBuffer.this.colorOffset);
            }
            return 0;
        }

        @Override
        public float u() {
            if (IterableVertexBuffer.this.hasUV) {
                return IterableVertexBuffer.this.buffer.getFloat(this.bytePointer + IterableVertexBuffer.this.uvOffset);
            }
            return 0.0f;
        }

        @Override
        public float v() {
            if (IterableVertexBuffer.this.hasUV) {
                return IterableVertexBuffer.this.buffer.getFloat(this.bytePointer + IterableVertexBuffer.this.uvOffset + 4);
            }
            return 0.0f;
        }

        @Override
        public VertexData.UV uv() {
            if (IterableVertexBuffer.this.hasUV) {
                return new VertexData.UV(IterableVertexBuffer.this.buffer.getFloat(this.bytePointer + IterableVertexBuffer.this.uvOffset), IterableVertexBuffer.this.buffer.getFloat(this.bytePointer + IterableVertexBuffer.this.uvOffset + 4));
            }
            return new VertexData.UV(0.0f, 0.0f);
        }

        @Override
        public int overlay() {
            if (IterableVertexBuffer.this.hasOverlay) {
                return IterableVertexBuffer.this.buffer.getInt(this.bytePointer + IterableVertexBuffer.this.overlayOffset);
            }
            return 0;
        }

        @Override
        public int light() {
            if (IterableVertexBuffer.this.hasLight) {
                return IterableVertexBuffer.this.buffer.getInt(this.bytePointer + IterableVertexBuffer.this.lightOffset);
            }
            return 0;
        }

        @Override
        public float normalX() {
            if (IterableVertexBuffer.this.hasNormal) {
                return (float)IterableVertexBuffer.this.buffer.get(this.bytePointer + IterableVertexBuffer.this.normalOffset) / 127.0f;
            }
            return 0.0f;
        }

        @Override
        public float normalY() {
            if (IterableVertexBuffer.this.hasNormal) {
                return (float)IterableVertexBuffer.this.buffer.get(this.bytePointer + IterableVertexBuffer.this.normalOffset + 1) / 127.0f;
            }
            return 0.0f;
        }

        @Override
        public float normalZ() {
            if (IterableVertexBuffer.this.hasNormal) {
                return (float)IterableVertexBuffer.this.buffer.get(this.bytePointer + IterableVertexBuffer.this.normalOffset + 2) / 127.0f;
            }
            return 0.0f;
        }

        @Override
        public Vec3 normal() {
            if (IterableVertexBuffer.this.hasNormal) {
                return new Vec3((double)((float)IterableVertexBuffer.this.buffer.get(this.bytePointer + IterableVertexBuffer.this.normalOffset) / 127.0f), (double)((float)IterableVertexBuffer.this.buffer.get(this.bytePointer + IterableVertexBuffer.this.normalOffset + 1) / 127.0f), (double)((float)IterableVertexBuffer.this.buffer.get(this.bytePointer + IterableVertexBuffer.this.normalOffset + 2) / 127.0f));
            }
            return Vec3.f_82478_;
        }

        @Override
        public VertexData asImmutable() {
            if (IterableVertexBuffer.this.fastFormat) {
                return new VertexData.ImmutableVertex(IterableVertexBuffer.this.buffer.getFloat(this.bytePointer), IterableVertexBuffer.this.buffer.getFloat(this.bytePointer + 4), IterableVertexBuffer.this.buffer.getFloat(this.bytePointer + 8), IterableVertexBuffer.this.readColor(this.bytePointer + 12), IterableVertexBuffer.this.buffer.getFloat(this.bytePointer + 16), IterableVertexBuffer.this.buffer.getFloat(this.bytePointer + 20), IterableVertexBuffer.this.buffer.getInt(this.bytePointer + 24), IterableVertexBuffer.this.buffer.getInt(this.bytePointer + 28), (float)IterableVertexBuffer.this.buffer.get(this.bytePointer + 32) / 127.0f, (float)IterableVertexBuffer.this.buffer.get(this.bytePointer + 33) / 127.0f, (float)IterableVertexBuffer.this.buffer.get(this.bytePointer + 34) / 127.0f);
            }
            return VertexData.super.asImmutable();
        }
    }
}

