/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.util;

import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class MathUtil {
    public static double round(double d, int digits) {
        return (double)Math.round(d * Math.pow(10.0, digits)) / Math.pow(10.0, digits);
    }

    public static Vec3 getEulerAngleYXZ(Matrix3f normal) {
        if ((double)normal.m21 <= -1.0) {
            return new Vec3(1.5707963267948966, Math.atan2(normal.m10, normal.m00), 0.0);
        }
        if ((double)normal.m21 >= 1.0) {
            return new Vec3(-1.5707963267948966, -Math.atan2(normal.m10, normal.m00), 0.0);
        }
        double xRot = Math.asin(-normal.m21);
        double yRot = Math.atan2(normal.m20, normal.m22);
        double zRot = Math.atan2(normal.m01, normal.m11);
        return new Vec3(xRot, yRot, zRot);
    }

    public static Vec3 getIntersectionPoint(Vec3 planePoint, Vec3 planeNormal, Vec3 linePoint, Vec3 lineNormal) {
        double distance = planeNormal.m_82526_(planePoint.m_82546_(linePoint)) / planeNormal.m_82526_(lineNormal);
        return linePoint.m_82549_(lineNormal.m_82490_(distance));
    }

    public static Vec3 projectToVec2(Vec3 vec3, Matrix4f ... projectionMatrices) {
        Vector4f vector4f = new Vector4f((float)vec3.m_7096_(), (float)vec3.m_7098_(), (float)vec3.m_7094_(), 1.0f);
        for (Matrix4f matrix4f : projectionMatrices) {
            vector4f.mul((Matrix4fc)matrix4f);
        }
        if ((double)vector4f.w() == 0.0) {
            return Vec3.f_82478_;
        }
        return new Vec3((double)vector4f.x(), (double)vector4f.y(), 0.0).m_82490_(1.0 / (double)vector4f.w());
    }
}

