/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.util;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.xtracr.realcamera.util.BuiltIterableBuffer;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;
import java.util.function.Consumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import org.jetbrains.annotations.NotNull;

public interface MultiVertexCatcher
extends MultiBufferSource {
    public static MultiVertexCatcher defaultImpl() {
        return MeshCatcher.INSTANCE;
    }

    public void endCatching(Consumer<BuiltIterableBuffer> var1);

    public static class MeshCatcher
    extends MultiBufferSource.BufferSource
    implements MultiVertexCatcher {
        private static final MeshCatcher INSTANCE = new MeshCatcher();
        protected final SortedMap<RenderType, BufferBuilder> startedBuilders = new Object2ObjectLinkedOpenHashMap();
        private final SortedMap<RenderType, BufferBuilderPool> bufferPools = new Object2ObjectLinkedOpenHashMap();
        private final SortedMap<BufferBuilder.RenderedBuffer, RenderType> caughtMeshes = new Object2ObjectLinkedOpenHashMap();

        protected MeshCatcher() {
            super(new BufferBuilder(0), (Map)ImmutableMap.of());
        }

        @NotNull
        public VertexConsumer m_6299_(RenderType renderType) {
            BufferBuilder bufferBuilder = (BufferBuilder)this.startedBuilders.get(renderType);
            if (bufferBuilder != null) {
                this.endBatch(renderType, bufferBuilder);
            }
            bufferBuilder = this.m_109914_(renderType);
            this.startedBuilders.put(renderType, bufferBuilder);
            bufferBuilder.m_166779_(renderType.m_173186_(), renderType.m_110508_());
            return bufferBuilder;
        }

        @NotNull
        protected BufferBuilder m_109914_(RenderType renderType) {
            return this.bufferPools.computeIfAbsent(renderType, type -> new BufferBuilderPool(type.m_110507_())).getBuffer();
        }

        @Override
        public void endCatching(Consumer<BuiltIterableBuffer> consumer) {
            this.m_109911_();
            this.caughtMeshes.forEach((meshData, renderType) -> {
                consumer.accept(BuiltIterableBuffer.buildFrom(renderType, meshData));
                meshData.m_231200_();
            });
            this.caughtMeshes.clear();
            this.bufferPools.values().forEach(BufferBuilderPool::release);
        }

        public void m_109911_() {
            for (RenderType renderType : this.bufferPools.keySet()) {
                this.m_109912_(renderType);
            }
        }

        public void m_109912_(RenderType renderType) {
            BufferBuilder bufferBuilder = (BufferBuilder)this.startedBuilders.remove(renderType);
            if (bufferBuilder != null) {
                this.endBatch(renderType, bufferBuilder);
            }
        }

        protected void endBatch(RenderType renderType, BufferBuilder bufferBuilder) {
            BufferBuilder.RenderedBuffer meshData = bufferBuilder.m_231175_();
            this.caughtMeshes.put(meshData, renderType);
        }

        private static class BufferBuilderPool {
            private final int bufferSize;
            private BufferBuilder[] pool = new BufferBuilder[0];
            private int next = 0;

            public BufferBuilderPool(int bufferSize) {
                this.bufferSize = bufferSize;
            }

            public BufferBuilder getBuffer() {
                BufferBuilder bufferBuilder;
                if (this.next < this.pool.length) {
                    bufferBuilder = this.pool[this.next++];
                } else {
                    this.pool = Arrays.copyOf(this.pool, this.pool.length + 1);
                    this.pool[this.next++] = bufferBuilder = new BufferBuilder(this.bufferSize);
                }
                return bufferBuilder;
            }

            public void release() {
                this.next = 0;
            }
        }
    }
}

