/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.util;

import com.xtracr.realcamera.util.MathUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.Vec3;

public class RaycastUtil {
    private static Vec3 startVec = Vec3.f_82478_;
    private static Vec3 endVec = Vec3.f_82478_;

    public static Vec3 getStartVec() {
        return startVec;
    }

    public static Vec3 getEndVec() {
        return endVec;
    }

    public static ClipContext getClipContext(ClipContext.Block shapeType, ClipContext.Fluid fluidHandling, Entity entity) {
        return new ClipContext(startVec, endVec, shapeType, fluidHandling, entity);
    }

    public static void update(Entity entity, double sqDistance, float deltaTick) {
        Vec3 offset;
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 eyePos = entity.m_20299_(deltaTick);
        startVec = camera.m_90583_();
        Vec3 direction = Vec3.m_82498_((float)camera.m_90589_(), (float)camera.m_90590_());
        Vec3 footPoint = MathUtil.getIntersectionPoint(Vec3.f_82478_, direction, offset = startVec.m_82546_(eyePos), direction);
        if (footPoint.m_82556_() > sqDistance) {
            startVec = eyePos;
            direction = entity.m_20252_(deltaTick);
            endVec = startVec.m_82549_(direction.m_82490_(Math.sqrt(sqDistance)));
            return;
        }
        if (offset.m_82556_() > sqDistance) {
            startVec = startVec.m_82549_(direction.m_82490_(offset.m_82554_(footPoint) - Math.sqrt(sqDistance - footPoint.m_82556_())));
        }
        endVec = eyePos.m_82549_(footPoint.m_82549_(direction.m_82490_(Math.sqrt(sqDistance - footPoint.m_82556_()))));
    }
}

