/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.util;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public interface VertexData {
    public static VertexData immutable(float x, float y, float z, int argb, float u, float v, int overlay, int light, float normalX, float normalY, float normalZ) {
        return new ImmutableVertex(x, y, z, argb, u, v, overlay, light, normalX, normalY, normalZ);
    }

    public static MutableVertex mutable() {
        return new MutableVertex();
    }

    public static VertexData[] asImmutable(VertexData[] vertices) {
        VertexData[] immutable = new VertexData[vertices.length];
        for (int i = 0; i < vertices.length; ++i) {
            immutable[i] = vertices[i].asImmutable();
        }
        return immutable;
    }

    public static Vec3 position(VertexData[] vertices, float u, float v) {
        if (vertices.length < 3) {
            return vertices[0].position();
        }
        float u0 = vertices[0].u();
        float v0 = vertices[0].v();
        float u1 = vertices[1].u();
        float v1 = vertices[1].v();
        float u2 = vertices[2].u();
        float v2 = vertices[2].v();
        float alpha = ((u - u1) * (v1 - v2) - (v - v1) * (u1 - u2)) / ((u0 - u1) * (v1 - v2) - (v0 - v1) * (u1 - u2));
        float beta = ((u - u2) * (v2 - v0) - (v - v2) * (u2 - u0)) / ((u1 - u2) * (v2 - v0) - (v1 - v2) * (u2 - u0));
        return vertices[0].position().m_82490_((double)alpha).m_82549_(vertices[1].position().m_82490_((double)beta)).m_82549_(vertices[2].position().m_82490_((double)(1.0f - alpha - beta)));
    }

    public static Vec3 normal(VertexData[] vertices) {
        return switch (vertices.length) {
            case 0 -> Vec3.f_82478_;
            case 1 -> vertices[0].normal();
            case 2 -> vertices[1].position().m_82546_(vertices[0].position()).m_82541_();
            default -> {
                Vec3 a = vertices[0].position();
                Vec3 b = vertices[1].position();
                Vec3 c = vertices[2].position();
                yield b.m_82546_(a).m_82537_(c.m_82546_(a)).m_82541_();
            }
        };
    }

    public float x();

    public float y();

    public float z();

    default public Vec3 position() {
        return new Vec3((double)this.x(), (double)this.y(), (double)this.z());
    }

    public int argb();

    public float u();

    public float v();

    default public UV uv() {
        return new UV(this.u(), this.v());
    }

    public int overlay();

    public int light();

    public float normalX();

    public float normalY();

    public float normalZ();

    default public Vec3 normal() {
        return new Vec3((double)this.normalX(), (double)this.normalY(), (double)this.normalZ());
    }

    default public VertexData asImmutable() {
        return new ImmutableVertex(this.x(), this.y(), this.z(), this.argb(), this.u(), this.v(), this.overlay(), this.light(), this.normalX(), this.normalY(), this.normalZ());
    }

    default public void render(VertexConsumer buffer, Matrix4f positionMatrix, Matrix3f normalMatrix) {
        Vector3f pos = new Vector3f(this.x(), this.y(), this.z()).mulPosition((Matrix4fc)positionMatrix);
        Vector3f normal = new Vector3f(this.normalX(), this.normalY(), this.normalZ()).mul((Matrix3fc)normalMatrix);
        buffer.m_5954_(pos.x(), pos.y(), pos.z(), (float)(this.argb() >> 16 & 0xFF) / 255.0f, (float)(this.argb() >> 8 & 0xFF) / 255.0f, (float)(this.argb() & 0xFF) / 255.0f, (float)(this.argb() >> 24) / 255.0f, this.u(), this.v(), this.overlay(), this.light(), normal.x(), normal.y(), normal.z());
    }

    default public void render(VertexConsumer buffer) {
        buffer.m_5954_(this.x(), this.y(), this.z(), (float)(this.argb() >> 16 & 0xFF) / 255.0f, (float)(this.argb() >> 8 & 0xFF) / 255.0f, (float)(this.argb() & 0xFF) / 255.0f, (float)(this.argb() >> 24) / 255.0f, this.u(), this.v(), this.overlay(), this.light(), this.normalX(), this.normalY(), this.normalZ());
    }

    public record ImmutableVertex(float x, float y, float z, int argb, float u, float v, int overlay, int light, float normalX, float normalY, float normalZ) implements VertexData
    {
    }

    public static class MutableVertex
    implements VertexData {
        public float x;
        public float y;
        public float z;
        public int argb;
        public float u;
        public float v;
        public int overlay;
        public int light;
        public float normalX;
        public float normalY;
        public float normalZ;

        private MutableVertex() {
        }

        @Override
        public float x() {
            return this.x;
        }

        @Override
        public float y() {
            return this.y;
        }

        @Override
        public float z() {
            return this.z;
        }

        @Override
        public int argb() {
            return this.argb;
        }

        @Override
        public float u() {
            return this.u;
        }

        @Override
        public float v() {
            return this.v;
        }

        @Override
        public int overlay() {
            return this.overlay;
        }

        @Override
        public int light() {
            return this.light;
        }

        @Override
        public float normalX() {
            return this.normalX;
        }

        @Override
        public float normalY() {
            return this.normalY;
        }

        @Override
        public float normalZ() {
            return this.normalZ;
        }
    }

    public record UV(float u, float v) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UV)) {
                return false;
            }
            UV uv = (UV)o;
            return Float.compare(this.u, uv.u) == 0 && Float.compare(this.v, uv.v) == 0;
        }

        @Override
        public int hashCode() {
            return Float.hashCode(this.u) * 31 + Float.hashCode(this.v);
        }
    }
}

