/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.api;

import com.xtracr.realcamera.api.BindResult;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.class_310;

public class RealCameraAPI {
    private static final List<BiFunction<class_310, Float, BindResult>> FUNCTIONS = new ArrayList<BiFunction<class_310, Float, BindResult>>();
    private static final Map<BiFunction<class_310, Float, BindResult>, Integer> PRIORITIES = new Object2IntOpenHashMap();

    public static void registerFunction(BiFunction<class_310, Float, BindResult> function) {
        RealCameraAPI.registerFunction(0, function);
    }

    public static void registerFunction(int priority, BiFunction<class_310, Float, BindResult> function) {
        FUNCTIONS.add(function);
        PRIORITIES.put(function, priority);
        FUNCTIONS.sort((a, b) -> PRIORITIES.get(b) - PRIORITIES.get(a));
    }

    public static BindResult computeBindResult(class_310 client, float deltaTick) {
        for (BiFunction<class_310, Float, BindResult> function : FUNCTIONS) {
            BindResult result = function.apply(client, Float.valueOf(deltaTick));
            if (!result.available()) continue;
            return result;
        }
        return BindResult.EMPTY;
    }
}

