/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.compat;

import com.xtracr.realcamera.RealCameraCore;
import com.xtracr.realcamera.config.ConfigFile;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public class DisableHelper {
    private static final Predicate<class_1657> FALSE = player -> false;
    private static final Map<String, Entry> entries = new HashMap<String, Entry>();
    public static final Entry MAIN_FEATURE = new Entry("mainFeature", player -> player.method_6113() || player.method_7325());
    public static final Entry RENDER_MODEL = new Entry("renderModel", FALSE, class_1657::method_31550);
    public static final Entry RENDER_HANDS = new Entry("renderHands", player -> RealCameraCore.isRendering());
    public static int exitTick = 0;

    private static boolean swimmingRecently(class_1657 player, int swimOutTick) {
        if (player.method_5681()) {
            exitTick = player.field_6012;
            return true;
        }
        if (exitTick > 0 && !player.method_5681()) {
            int elapsedTicks = player.field_6012 - exitTick;
            if (elapsedTicks <= swimOutTick) {
                return true;
            }
            exitTick = 0;
        }
        return false;
    }

    @Deprecated
    public static void registerOr(String name, Predicate<class_1309> predicate) {
        entries.get(name).registerOrInBinding(predicate::test);
    }

    public static boolean matchesItemPattern(class_1792 item, String pattern) {
        if (pattern.startsWith("#")) {
            String tagId = pattern.substring(1);
            class_6862 itemTag = class_6862.method_40092((class_5321)class_7923.field_41178.method_30517(), (class_2960)class_2960.method_60654((String)tagId));
            return class_7923.field_41178.method_40266(itemTag).map(tag -> tag.method_40241(class_7923.field_41178.method_47983((Object)item))).orElse(false);
        }
        return DisableHelper.simpleWildcardMatch(class_7923.field_41178.method_10221((Object)item).toString(), pattern);
    }

    public static boolean simpleWildcardMatch(String text, String pattern) {
        if (pattern.isEmpty()) {
            return text.isEmpty();
        }
        if (pattern.equals(text)) {
            return true;
        }
        String[] parts = pattern.split("\\*+");
        if (parts.length == 0) {
            return true;
        }
        int currentIndex = 0;
        if (!pattern.startsWith("*")) {
            String firstPart = parts[0];
            if (!text.startsWith(firstPart)) {
                return false;
            }
            currentIndex = firstPart.length();
        }
        for (int i = 1; i < parts.length; ++i) {
            String part = parts[i];
            if (part.isEmpty()) continue;
            int foundIndex = text.indexOf(part, currentIndex);
            if (foundIndex == -1) {
                return false;
            }
            currentIndex = foundIndex + part.length();
        }
        if (!pattern.endsWith("*")) {
            String lastPart = parts[parts.length - 1];
            return text.endsWith(lastPart);
        }
        return true;
    }

    static {
        MAIN_FEATURE.registerOrInBinding(player -> ConfigFile.config().bindingDisableWhenSneaking() && player.method_18276());
        MAIN_FEATURE.registerOrInClassic(player -> ConfigFile.config().classicDisableWhenSneaking() && player.method_18276());
        MAIN_FEATURE.registerOrInBinding(player -> ConfigFile.config().bindingDisableWhenSwimming() && DisableHelper.swimmingRecently(player, ConfigFile.config().getBindingSwimOutTick()));
        MAIN_FEATURE.registerOrInClassic(player -> ConfigFile.config().classicDisableWhenSwimming() && DisableHelper.swimmingRecently(player, ConfigFile.config().getClassicSwimOutTick()));
        MAIN_FEATURE.registerOrInBinding(player -> {
            class_1792 mainHand = player.method_6047().method_7909();
            class_1792 offHand = player.method_6079().method_7909();
            for (String pattern : ConfigFile.config().getDisableMainFeatureItems()) {
                if (!DisableHelper.matchesItemPattern(mainHand, pattern) && !DisableHelper.matchesItemPattern(offHand, pattern)) continue;
                return true;
            }
            return false;
        });
        RENDER_MODEL.registerOrInBinding(player -> {
            class_1792 mainHand = player.method_6047().method_7909();
            class_1792 offHand = player.method_6079().method_7909();
            for (String pattern : ConfigFile.config().getDisableRenderItems()) {
                if (!DisableHelper.matchesItemPattern(mainHand, pattern) && !DisableHelper.matchesItemPattern(offHand, pattern)) continue;
                return true;
            }
            return false;
        });
    }

    public static class Entry {
        protected Predicate<class_1657> predicateInClassic;
        protected Predicate<class_1657> predicateInBinding;

        protected Entry(String name, Predicate<class_1657> predicate) {
            this(name, predicate, predicate);
        }

        protected Entry(String name, Predicate<class_1657> predicateInClassic, Predicate<class_1657> predicateInBinding) {
            this.predicateInClassic = predicateInClassic;
            this.predicateInBinding = predicateInBinding;
            entries.put(name, this);
        }

        public void registerOr(Predicate<class_1657> predicate) {
            this.registerOrInClassic(predicate);
            this.registerOrInBinding(predicate);
        }

        public void registerOrInClassic(Predicate<class_1657> predicate) {
            this.predicateInClassic = this.predicateInClassic.or(predicate);
        }

        public void registerOrInBinding(Predicate<class_1657> predicate) {
            this.predicateInBinding = this.predicateInBinding.or(predicate);
        }

        public boolean disabled(class_1297 cameraEntity) {
            if (!(cameraEntity instanceof class_1657)) {
                return false;
            }
            class_1657 player = (class_1657)cameraEntity;
            return ConfigFile.config().isClassic() ? this.predicateInClassic.test(player) : this.predicateInBinding.test(player);
        }
    }
}

