/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.compat;

import com.xtracr.realcamera.api.BindResult;
import com.xtracr.realcamera.api.RealCameraAPI;
import com.xtracr.realcamera.config.BindTarget;
import com.xtracr.realcamera.config.ConfigFile;
import com.xtracr.realcamera.util.BuiltIterableBuffer;
import com.xtracr.realcamera.util.MultiVertexCatcher;
import com.xtracr.realcamera.util.VertexData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_898;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class YSMCompat {
    private static final Map<BindTarget, BindResult> resultMap = new HashMap<BindTarget, BindResult>();
    private static final TransformedVertexRecorder[] transformedRecorders = new TransformedVertexRecorder[4];
    private static BindResult bindResult = BindResult.EMPTY;
    private static boolean allCached = false;

    public static void register() {
        RealCameraAPI.registerFunction(-100, YSMCompat::computeBindResult);
    }

    private static BindResult computeBindResult(class_310 client, float deltaTick) {
        MultiVertexCatcher catcher;
        resultMap.clear();
        bindResult = BindResult.EMPTY;
        allCached = true;
        class_1297 entity = client.method_1560();
        class_898 dispatcher = client.method_1561();
        class_4587 poseStack = new class_4587();
        for (TransformedVertexRecorder transformedRecorder : transformedRecorders) {
            poseStack.method_22903();
            poseStack.method_34425(transformedRecorder.matrix4f.invert(new Matrix4f()));
            catcher = MultiVertexCatcher.defaultImpl();
            dispatcher.method_3954(entity, 0.0, 0.0, 0.0, class_3532.method_16439((float)deltaTick, (float)entity.field_5982, (float)entity.method_36454()), deltaTick, poseStack, (class_4597)catcher, dispatcher.method_23839(entity, deltaTick));
            catcher.endCatching(transformedRecorder::computeBindResultInCache);
            poseStack.method_22909();
            if (!bindResult.available()) continue;
            return bindResult;
        }
        if (allCached) {
            return BindResult.EMPTY;
        }
        for (TransformedVertexRecorder transformedRecorder : transformedRecorders) {
            poseStack.method_22903();
            poseStack.method_34425(transformedRecorder.matrix4f.invert(new Matrix4f()));
            catcher = MultiVertexCatcher.defaultImpl();
            dispatcher.method_3954(entity, 0.0, 0.0, 0.0, class_3532.method_16439((float)deltaTick, (float)entity.field_5982, (float)entity.method_36454()), deltaTick, poseStack, (class_4597)catcher, dispatcher.method_23839(entity, deltaTick));
            catcher.endCatching(transformedRecorder::computeBindResult);
            poseStack.method_22909();
            if (!bindResult.available()) continue;
            return bindResult;
        }
        return BindResult.EMPTY;
    }

    static {
        float pitch = 1.9106332f;
        float yaw = 2.0943952f;
        YSMCompat.transformedRecorders[0] = new TransformedVertexRecorder();
        YSMCompat.transformedRecorders[1] = new TransformedVertexRecorder().setRotation(1.9106332f, 0.0f);
        YSMCompat.transformedRecorders[2] = new TransformedVertexRecorder().setRotation(1.9106332f, 2.0943952f);
        YSMCompat.transformedRecorders[3] = new TransformedVertexRecorder().setRotation(1.9106332f, 4.1887903f);
    }

    protected static class TransformedVertexRecorder {
        protected final Matrix4f matrix4f = new Matrix4f();
        protected final Matrix3f matrix3f = new Matrix3f();

        protected TransformedVertexRecorder() {
        }

        public TransformedVertexRecorder setRotation(float pitch, float yaw) {
            this.matrix4f.rotationYXZ(yaw, pitch, 0.0f).invert();
            this.matrix3f.rotationYXZ(yaw, pitch, 0.0f).invert();
            return this;
        }

        public void computeBindResultInCache(BuiltIterableBuffer builtBuffer) {
            if (bindResult.available()) {
                return;
            }
            for (BindTarget target : ConfigFile.config().getBindTargetList()) {
                VertexData[][] primitives;
                BindResult result = resultMap.computeIfAbsent(target, k -> new BindResult(target, false));
                if (!builtBuffer.textureId().contains(result.target.textureId())) continue;
                BindTarget.TargetConfig config = result.target.targetConfig();
                VertexData.UV posUV = new VertexData.UV(config.posU(), config.posV());
                VertexData.UV forwardUV = new VertexData.UV(config.forwardU(), config.forwardV());
                VertexData.UV upwardUV = new VertexData.UV(config.upwardU(), config.upwardV());
                if (builtBuffer.anyNotCached(new VertexData.UV[]{posUV, forwardUV, upwardUV})) {
                    allCached = false;
                }
                if (result.getPosition() != class_243.field_1353) {
                    posUV = null;
                }
                if (result.getForward() != class_243.field_1353) {
                    forwardUV = null;
                }
                if (result.getUpward() != class_243.field_1353) {
                    upwardUV = null;
                }
                if ((primitives = builtBuffer.findPrimitivesInCache(new VertexData.UV[]{posUV, forwardUV, upwardUV}))[0] != null) {
                    result.setPosition(new class_243(VertexData.position(primitives[0], config.posU(), config.posV()).method_46409().mulPosition((Matrix4fc)this.matrix4f)));
                }
                if (primitives[1] != null) {
                    result.setForward(new class_243(VertexData.normal(primitives[1]).method_46409().mul((Matrix3fc)this.matrix3f)));
                }
                if (primitives[2] != null) {
                    result.setUpward(new class_243(VertexData.normal(primitives[2]).method_46409().mul((Matrix3fc)this.matrix3f)));
                }
                if (!result.available()) continue;
                bindResult = result;
                return;
            }
        }

        public void computeBindResult(BuiltIterableBuffer builtBuffer) {
            if (bindResult.available()) {
                return;
            }
            for (BindTarget target : ConfigFile.config().getBindTargetList()) {
                VertexData.UV upwardUV;
                VertexData.UV forwardUV;
                BindResult result = resultMap.computeIfAbsent(target, k -> new BindResult(target, false));
                if (!builtBuffer.textureId().contains(result.target.textureId())) continue;
                BindTarget.TargetConfig config = result.target.targetConfig();
                VertexData.UV posUV = result.getPosition() == class_243.field_1353 ? new VertexData.UV(config.posU(), config.posV()) : null;
                VertexData[][] primitives = builtBuffer.findPrimitives(new VertexData.UV[]{posUV, forwardUV = result.getForward() == class_243.field_1353 ? new VertexData.UV(config.forwardU(), config.forwardV()) : null, upwardUV = result.getUpward() == class_243.field_1353 ? new VertexData.UV(config.upwardU(), config.upwardV()) : null});
                if (primitives[0] != null) {
                    result.setPosition(new class_243(VertexData.position(primitives[0], config.posU(), config.posV()).method_46409().mulPosition((Matrix4fc)this.matrix4f)));
                }
                if (primitives[1] != null) {
                    result.setForward(new class_243(VertexData.normal(primitives[1]).method_46409().mul((Matrix3fc)this.matrix3f)));
                }
                if (primitives[2] != null) {
                    result.setUpward(new class_243(VertexData.normal(primitives[2]).method_46409().mul((Matrix3fc)this.matrix3f)));
                }
                if (!result.available()) continue;
                bindResult = result;
                return;
            }
        }
    }
}

