/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.config;

import com.xtracr.realcamera.util.VertexData;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_2540;
import net.minecraft.class_3532;

public record BindTarget(String name, String textureId, int priority, float disablingDepth, TargetConfig targetConfig, BindConfig bindConfig, OffsetConfig offsets, DisableConfig[] disableConfigs) {
    private static final short serialVersion = 703;
    public static final List<BindTarget> defaultTargets;
    public static final BindTarget EMPTY;

    public static BindTarget blank(String name, String textureId) {
        TargetConfig targetConfig = new TargetConfig(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        BindConfig bindConfig = new BindConfig(false, true, false, false);
        return new BindTarget(name, textureId, 0, 0.2f, targetConfig, bindConfig, new OffsetConfig(), new DisableConfig[0]);
    }

    public static BindTarget read(class_2540 byteBuf) throws IllegalArgumentException {
        short version = byteBuf.readShort();
        if (version != 703) {
            throw new IllegalArgumentException("Invalid version: " + version + ", expected 703");
        }
        String name = byteBuf.method_19772();
        String textureId = byteBuf.method_19772();
        int priority = byteBuf.method_10816();
        float disablingDepth = byteBuf.readFloat();
        TargetConfig targetConfig = TargetConfig.read(byteBuf);
        BindConfig bindConfig = BindConfig.read(byteBuf);
        OffsetConfig offsets = OffsetConfig.read(byteBuf);
        DisableConfig[] disableConfigs = new DisableConfig[byteBuf.method_10816()];
        for (int i = 0; i < disableConfigs.length; ++i) {
            disableConfigs[i] = DisableConfig.read(byteBuf);
        }
        return new BindTarget(name, textureId, priority, disablingDepth, targetConfig, bindConfig, offsets, disableConfigs);
    }

    private static BindTarget vanillaTarget(String name, int priority, boolean shouldBind) {
        String textureId = name.contains("skin") ? "minecraft:skins/" : "minecraft:textures/entity/player/";
        TargetConfig targetConfig = new TargetConfig(0.1875f, 0.2f, 0.1875f, 0.075f, 0.1875f, 0.2f);
        BindConfig bindConfig = new BindConfig(shouldBind, true, shouldBind, shouldBind);
        OffsetConfig offsets = new OffsetConfig().setX(-0.1f);
        DisableConfig playerHead = new DisableConfig("player_head", textureId, false, new UVRectangle[]{new UVRectangle(0.0f, 0.0f, 1.0f, 0.25f)});
        DisableConfig dragonHead = new DisableConfig("dragon_head", "minecraft:textures/entity/enderdragon/dragon.png", true, new UVRectangle[0]);
        DisableConfig[] disableConfigs = new DisableConfig[]{playerHead, dragonHead};
        return new BindTarget(name, textureId, priority, 0.1f, targetConfig, bindConfig, offsets, disableConfigs);
    }

    public boolean isEmpty() {
        return this.name == null || this.textureId == null || this.targetConfig == null || this.bindConfig == null || this.offsets == null || this.disableConfigs == null;
    }

    public DisableConfig[] filteredDisableConfigs(Predicate<DisableConfig> filter) {
        return (DisableConfig[])Arrays.stream(this.disableConfigs).filter(filter).toArray(DisableConfig[]::new);
    }

    public void write(class_2540 byteBuf) {
        byteBuf.method_52998(703);
        byteBuf.method_10814(this.name);
        byteBuf.method_10814(this.textureId);
        byteBuf.method_10804(this.priority);
        byteBuf.method_52941(this.disablingDepth);
        this.targetConfig.write(byteBuf);
        this.bindConfig.write(byteBuf);
        this.offsets.write(byteBuf);
        byteBuf.method_10804(this.disableConfigs.length);
        for (DisableConfig disableConfig : this.disableConfigs) {
            disableConfig.write(byteBuf);
        }
    }

    static {
        EMPTY = BindTarget.blank(null, null);
        defaultTargets = List.of(BindTarget.vanillaTarget("minecraft_head", 5, false), BindTarget.vanillaTarget("skin_head", 5, false), BindTarget.vanillaTarget("minecraft_head_2", 1, true), BindTarget.vanillaTarget("skin_head_2", 1, true));
    }

    public record TargetConfig(float forwardU, float forwardV, float upwardU, float upwardV, float posU, float posV) {
        public static TargetConfig read(class_2540 byteBuf) {
            return new TargetConfig(byteBuf.readFloat(), byteBuf.readFloat(), byteBuf.readFloat(), byteBuf.readFloat(), byteBuf.readFloat(), byteBuf.readFloat());
        }

        public void write(class_2540 byteBuf) {
            byteBuf.method_52941(this.forwardU);
            byteBuf.method_52941(this.forwardV);
            byteBuf.method_52941(this.upwardU);
            byteBuf.method_52941(this.upwardV);
            byteBuf.method_52941(this.posU);
            byteBuf.method_52941(this.posV);
        }
    }

    public record BindConfig(boolean bindX, boolean bindY, boolean bindZ, boolean bindRotation) {
        public static BindConfig read(class_2540 byteBuf) {
            byte bindFlags = byteBuf.readByte();
            boolean bindX = (bindFlags & 1) != 0;
            boolean bindY = (bindFlags & 2) != 0;
            boolean bindZ = (bindFlags & 4) != 0;
            boolean bindRotation = (bindFlags & 8) != 0;
            return new BindConfig(bindX, bindY, bindZ, bindRotation);
        }

        public void write(class_2540 byteBuf) {
            byte bindFlags = 0;
            if (this.bindX) {
                bindFlags = (byte)(bindFlags | 1);
            }
            if (this.bindY) {
                bindFlags = (byte)(bindFlags | 2);
            }
            if (this.bindZ) {
                bindFlags = (byte)(bindFlags | 4);
            }
            if (this.bindRotation) {
                bindFlags = (byte)(bindFlags | 8);
            }
            byteBuf.method_52997((int)bindFlags);
        }
    }

    public static class OffsetConfig {
        private float scale = 1.0f;
        private float x = 0.0f;
        private float y = 0.0f;
        private float z = 0.0f;
        private float pitch = 0.0f;
        private float yaw = 0.0f;
        private float roll = 0.0f;

        public static OffsetConfig read(class_2540 byteBuf) {
            return new OffsetConfig().setScale(byteBuf.readFloat()).setX(byteBuf.readFloat()).setY(byteBuf.readFloat()).setZ(byteBuf.readFloat()).setPitch(byteBuf.readFloat()).setYaw(byteBuf.readFloat()).setRoll(byteBuf.readFloat());
        }

        public float getScale() {
            return this.scale;
        }

        public OffsetConfig setScale(float scale) {
            this.scale = scale;
            return this;
        }

        public float getX() {
            return this.x;
        }

        public OffsetConfig setX(float x) {
            this.x = class_3532.method_15363((float)x, (float)-1.0f, (float)1.0f);
            return this;
        }

        public float getY() {
            return this.y;
        }

        public OffsetConfig setY(float y) {
            this.y = class_3532.method_15363((float)y, (float)-1.0f, (float)1.0f);
            return this;
        }

        public float getZ() {
            return this.z;
        }

        public OffsetConfig setZ(float z) {
            this.z = class_3532.method_15363((float)z, (float)-1.0f, (float)1.0f);
            return this;
        }

        public float getPitch() {
            return this.pitch;
        }

        public OffsetConfig setPitch(float pitch) {
            this.pitch = class_3532.method_15393((float)pitch);
            return this;
        }

        public float getYaw() {
            return this.yaw;
        }

        public OffsetConfig setYaw(float yaw) {
            this.yaw = class_3532.method_15393((float)yaw);
            return this;
        }

        public float getRoll() {
            return this.roll;
        }

        public OffsetConfig setRoll(float roll) {
            this.roll = class_3532.method_15393((float)roll);
            return this;
        }

        public void write(class_2540 byteBuf) {
            byteBuf.method_52941(this.scale);
            byteBuf.method_52941(this.x);
            byteBuf.method_52941(this.y);
            byteBuf.method_52941(this.z);
            byteBuf.method_52941(this.pitch);
            byteBuf.method_52941(this.yaw);
            byteBuf.method_52941(this.roll);
        }
    }

    public record DisableConfig(String name, String textureId, boolean disableAll, UVRectangle[] rectangles) implements Predicate<VertexData>
    {
        public static DisableConfig read(class_2540 byteBuf) {
            String name = byteBuf.method_19772();
            String textureId = byteBuf.method_19772();
            boolean disableAll = byteBuf.readBoolean();
            UVRectangle[] rectangles = new UVRectangle[byteBuf.method_10816()];
            for (int i = 0; i < rectangles.length; ++i) {
                rectangles[i] = UVRectangle.read(byteBuf);
            }
            return new DisableConfig(name, textureId, disableAll, rectangles);
        }

        public void write(class_2540 byteBuf) {
            byteBuf.method_10814(this.name);
            byteBuf.method_10814(this.textureId);
            byteBuf.method_52964(this.disableAll);
            byteBuf.method_10804(this.rectangles.length);
            for (UVRectangle rect : this.rectangles) {
                rect.write(byteBuf);
            }
        }

        @Override
        public boolean test(VertexData vertex) {
            float u = vertex.u();
            float v = vertex.v();
            for (UVRectangle rect : this.rectangles) {
                if (!rect.contains(u, v)) continue;
                return true;
            }
            return false;
        }
    }

    public record UVRectangle(float uMin, float vMin, float uMax, float vMax) {
        public static UVRectangle read(class_2540 byteBuf) {
            return new UVRectangle(byteBuf.readFloat(), byteBuf.readFloat(), byteBuf.readFloat(), byteBuf.readFloat());
        }

        public boolean contains(float u, float v) {
            return u >= this.uMin && u <= this.uMax && v >= this.vMin && v <= this.vMax;
        }

        public void write(class_2540 byteBuf) {
            byteBuf.method_52941(this.uMin);
            byteBuf.method_52941(this.vMin);
            byteBuf.method_52941(this.uMax);
            byteBuf.method_52941(this.vMax);
        }
    }
}

