/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.gui;

import com.xtracr.realcamera.api.BindResult;
import com.xtracr.realcamera.config.BindTarget;
import com.xtracr.realcamera.gui.GUIHelper;
import com.xtracr.realcamera.util.BuiltIterableBuffer;
import com.xtracr.realcamera.util.MultiVertexCatcher;
import com.xtracr.realcamera.util.VertexData;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_293;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_898;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public class ModelAnalyser {
    private static final Set<class_1921> UNFOCUSABLE_RENDER_TYPES = Set.of(class_1921.method_27949(), class_1921.method_30676(), class_1921.method_23590(), class_1921.method_23591(), class_1921.method_29707());
    private static final int planeArgb = 1865626572;
    private static final int forwardArgb = -16724992;
    private static final int upwardArgb = -3407872;
    private static final int leftArgb = -16777012;
    private static final int focusedArgb = 0x4FFFFFFF;
    private static final int z1 = 210;
    private static final int z2 = 220;
    public final List<VertexData[]> focusedPolyhedron = new ArrayList<VertexData[]>();
    public final class_4587 modelPose = new class_4587();
    public final class_4587 texturePose = new class_4587();
    private final List<BuiltRecord> modelRecords = new ArrayList<BuiltRecord>();
    private final List<BuiltRecord> textureRecords = new ArrayList<BuiltRecord>();
    private VertexData[][] targetPrimitives = new VertexData[3][];
    private BindResult bindResult = BindResult.EMPTY;
    private BindTarget target = BindTarget.EMPTY;
    @Nullable
    private BuiltRecord focusedRecord;
    @Nullable
    private BuiltRecord currentRecord;
    private double modelScale;

    private static boolean haveCommonVertex(VertexData[] p1, List<VertexData[]> primitives) {
        float precision = 1.0E-5f;
        for (VertexData[] p2 : primitives) {
            for (VertexData v1 : p1) {
                for (VertexData v2 : p2) {
                    if (!(Math.abs(v1.x() - v2.x()) < 1.0E-5f) || !(Math.abs(v1.y() - v2.y()) < 1.0E-5f) || !(Math.abs(v1.z() - v2.z()) < 1.0E-5f)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static Polygon getPolygon(VertexData[] primitive) {
        int length = primitive.length;
        int[] xs = new int[length];
        int[] ys = new int[length];
        for (int j = 0; j < length; ++j) {
            VertexData vertex = primitive[j];
            xs[j] = (int)vertex.x();
            ys[j] = (int)vertex.y();
        }
        return new Polygon(xs, ys, length);
    }

    public void initialize(BindTarget target, int modelScale) {
        this.target = target;
        this.modelScale = modelScale;
        this.modelRecords.clear();
        this.textureRecords.clear();
        this.focusedPolyhedron.clear();
        this.modelPose.method_34426();
        this.texturePose.method_34426();
        this.targetPrimitives[2] = null;
        this.targetPrimitives[1] = null;
        this.targetPrimitives[0] = null;
        this.bindResult = BindResult.EMPTY;
        this.currentRecord = null;
        this.focusedRecord = null;
        target.offsets().setScale(target.offsets().getScale() * (float)modelScale);
    }

    public String getFocusedTextureId() {
        return this.focusedRecord == null ? null : this.focusedRecord.textureId();
    }

    public void applyDisableConfigs(String textureId, Set<String> hiddenNames) {
        for (BuiltRecord record : this.modelRecords) {
            if (!record.textureId().contains(textureId)) continue;
            this.textureRecords.add(record);
        }
        for (int i = 0; i < this.modelRecords.size(); ++i) {
            BuiltRecord record;
            record = this.modelRecords.get(i);
            ArrayList<BindTarget.DisableConfig> primitives = new ArrayList<BindTarget.DisableConfig>();
            BindTarget.DisableConfig[] disableConfigs = this.target.filteredDisableConfigs(config -> record.textureId().contains(config.textureId()) && hiddenNames.contains(config.name()));
            boolean disableAll = !record.textureId().contains(textureId);
            for (BindTarget.DisableConfig config2 : disableConfigs) {
                if (!config2.disableAll()) continue;
                disableAll = true;
                break;
            }
            if (!disableAll) {
                BindTarget.DisableConfig[] disableConfigArray = record.primitives();
                int n = disableConfigArray.length;
                block3: for (int j = 0; j < n; ++j) {
                    BindTarget.DisableConfig primitive;
                    block4: for (BindTarget.DisableConfig vertex : primitive = disableConfigArray[j]) {
                        for (BindTarget.DisableConfig config3 : disableConfigs) {
                            if (config3.test((VertexData)((Object)vertex))) continue block4;
                        }
                        primitives.add(primitive);
                        continue block3;
                    }
                }
            }
            this.modelRecords.set(i, new BuiltRecord(record.renderType(), record.textureId(), record.vertices(), (VertexData[][])primitives.toArray((T[])new VertexData[0][])));
        }
    }

    public void computeFocusedOnTexture(int mouseX, int mouseY) {
        if (this.focusedRecord != null && !this.focusedPolyhedron.isEmpty()) {
            return;
        }
        Matrix4f positionMatrix = this.texturePose.method_23760().method_23761();
        Vector3f position = new Vector3f();
        block0: for (BuiltRecord record : this.textureRecords) {
            int length = record.renderType().method_23033().field_27384;
            int[] xs = new int[length];
            int[] ys = new int[length];
            for (VertexData[] primitive : record.primitives()) {
                for (int j = 0; j < length; ++j) {
                    VertexData vertex = primitive[j];
                    position.set(vertex.u(), vertex.v(), 0.0f).mulPosition((Matrix4fc)positionMatrix);
                    xs[j] = (int)position.x();
                    ys[j] = (int)position.y();
                }
                if (!new Polygon(xs, ys, length).contains(mouseX, mouseY)) continue;
                this.focusedRecord = record;
                this.focusedPolyhedron.add(primitive);
                continue block0;
            }
        }
    }

    public void computeFocusedOnModel(int mouseX, int mouseY, int layers) {
        if (this.focusedRecord != null && !this.focusedPolyhedron.isEmpty()) {
            return;
        }
        ArrayList<Object[]> sortByZ = new ArrayList<Object[]>();
        for (BuiltRecord record : this.modelRecords) {
            VertexData[][] primitives;
            if (UNFOCUSABLE_RENDER_TYPES.contains(record.renderType())) continue;
            for (VertexData[] primitive : primitives = record.primitives()) {
                if (!ModelAnalyser.getPolygon(primitive).contains(mouseX, mouseY)) continue;
                VertexData vertex = primitive[0];
                float deltaZ = vertex.normalZ() == 0.0f ? 0.0f : (vertex.normalX() * ((float)mouseX - vertex.x()) + vertex.normalY() * ((float)mouseY - vertex.y())) / vertex.normalZ();
                sortByZ.add(new Object[]{record, primitive, Float.valueOf(vertex.z() - deltaZ)});
            }
        }
        if (sortByZ.isEmpty()) {
            return;
        }
        sortByZ.sort(Comparator.comparingDouble(array -> -((Float)array[2]).floatValue()));
        Object[] result = (Object[])sortByZ.get(Math.min(sortByZ.size() - 1, layers));
        this.focusedRecord = (BuiltRecord)result[0];
        this.focusedPolyhedron.add((VertexData[])result[1]);
    }

    public void computeFocusedOnModel(int minX, int minY, int maxX, int maxY) {
        if (this.focusedRecord != null && !this.focusedPolyhedron.isEmpty()) {
            return;
        }
        ArrayList<Object[]> sortByZ = new ArrayList<Object[]>();
        for (BuiltRecord record : this.modelRecords) {
            VertexData[][] primitives;
            if (UNFOCUSABLE_RENDER_TYPES.contains(record.renderType())) continue;
            block1: for (VertexData[] primitive : primitives = record.primitives()) {
                float maxZ = primitive[0].z();
                for (VertexData vertex : primitive) {
                    int x = (int)vertex.x();
                    int y = (int)vertex.y();
                    if (x < minX || y < minY || x > maxX || y > maxY) continue block1;
                    if (!(vertex.z() > maxZ)) continue;
                    maxZ = vertex.z();
                }
                sortByZ.add(new Object[]{record, primitive, Float.valueOf(maxZ)});
            }
        }
        if (sortByZ.isEmpty()) {
            return;
        }
        sortByZ.sort(Comparator.comparingDouble(array -> -((Float)array[2]).floatValue()));
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        this.focusedRecord = (BuiltRecord)((Object[])sortByZ.getFirst())[0];
        while (!sortByZ.isEmpty()) {
            VertexData[] first = (VertexData[])((Object[])sortByZ.getFirst())[1];
            this.focusedPolyhedron.add(first);
            polygons.add(ModelAnalyser.getPolygon(first));
            sortByZ.removeFirst();
            sortByZ.removeIf(array -> {
                VertexData[] primitive;
                if (array[0] != this.focusedRecord) {
                    return true;
                }
                block0: for (VertexData vertex : primitive = (VertexData[])array[1]) {
                    for (Polygon polygon : polygons) {
                        if (!polygon.contains(vertex.x(), vertex.y())) continue;
                        continue block0;
                    }
                    return false;
                }
                return true;
            });
        }
    }

    public void computeFocusedPolyhedron() {
        int i2;
        boolean added;
        if (this.focusedRecord == null || this.focusedPolyhedron.isEmpty()) {
            return;
        }
        VertexData[][] primitives = this.focusedRecord.primitives();
        VertexData[] focused = this.focusedPolyhedron.getFirst();
        int focusedIndex = -1;
        for (int i3 = 0; i3 < primitives.length; ++i3) {
            if (focused != primitives[i3]) continue;
            focusedIndex = i3;
            break;
        }
        if (focusedIndex == -1) {
            return;
        }
        ArrayList<VertexData[]> polyhedron = new ArrayList<VertexData[]>();
        polyhedron.add(focused);
        ArrayList<Integer> indexes = new ArrayList<Integer>(List.of(Integer.valueOf(focusedIndex)));
        int primitiveCount = primitives.length;
        do {
            added = false;
            for (int i4 = 0; i4 < primitiveCount; ++i4) {
                VertexData[] primitive = primitives[i4];
                if (indexes.contains(i4) | !ModelAnalyser.haveCommonVertex(primitive, polyhedron)) continue;
                polyhedron.add(primitive);
                indexes.add(i4);
                added = true;
            }
        } while (added);
        ArrayList<Integer> resultIndexes = new ArrayList<Integer>(List.of(Integer.valueOf(focusedIndex)));
        for (i2 = focusedIndex + 1; i2 < primitiveCount && indexes.contains(i2); ++i2) {
            resultIndexes.add(i2);
        }
        for (i2 = focusedIndex - 1; i2 >= 0 && indexes.contains(i2); --i2) {
            resultIndexes.add(i2);
        }
        resultIndexes.forEach(i -> this.focusedPolyhedron.add(primitives[i]));
    }

    public void drawCameraDirections(class_332 graphics) {
        if (this.targetPrimitives[0] == null || this.targetPrimitives[1] == null || this.targetPrimitives[2] == null) {
            return;
        }
        class_243 start = this.bindResult.getPosition();
        Matrix3f normal = this.bindResult.getRotation();
        if (normal.m00() == 0.0f && normal.m11() == 0.0f && normal.m22() == 0.0f) {
            return;
        }
        GUIHelper.renderVector(graphics, start, new class_243((double)normal.m20(), (double)normal.m21(), (double)normal.m22()).method_1021(this.modelScale / 3.0), 220.0f, -16724992);
        GUIHelper.renderVector(graphics, start, new class_243((double)normal.m10(), (double)normal.m11(), (double)normal.m12()).method_1021(this.modelScale / 6.0), 220.0f, -3407872);
        GUIHelper.renderVector(graphics, start, new class_243((double)normal.m00(), (double)normal.m01(), (double)normal.m02()).method_1021(this.modelScale / 6.0), 220.0f, -16777012);
    }

    public void drawBindTarget(class_332 graphics) {
        if (this.currentRecord == null) {
            return;
        }
        BindTarget.TargetConfig config = this.target.targetConfig();
        if (this.targetPrimitives[0] != null) {
            GUIHelper.renderPolygon(graphics, this.targetPrimitives[0], 210.0f, 1865626572);
        }
        if (this.targetPrimitives[1] != null) {
            GUIHelper.renderVector(graphics, VertexData.position(this.targetPrimitives[1], config.forwardU(), config.forwardV()), VertexData.normal(this.targetPrimitives[1]).method_1021(-this.modelScale / 2.0), 220.0f, -16724992);
        }
        if (this.targetPrimitives[2] != null) {
            GUIHelper.renderVector(graphics, VertexData.position(this.targetPrimitives[2], config.upwardU(), config.upwardV()), VertexData.normal(this.targetPrimitives[2]).method_1021(-this.modelScale / 2.0), 220.0f, -3407872);
        }
    }

    public void drawFocusedInModelArea(class_332 graphics) {
        if (this.focusedPolyhedron.isEmpty() || this.focusedRecord == null) {
            return;
        }
        VertexData[] focused = this.focusedPolyhedron.getFirst();
        VertexData[] reversed = new VertexData[focused.length];
        for (int i = 0; i < focused.length; ++i) {
            reversed[i] = focused[focused.length - 1 - i];
        }
        GUIHelper.renderPolygon(graphics, reversed, 210.0f, 0x4FFFFFFF);
        this.focusedPolyhedron.forEach(primitive -> GUIHelper.renderPolygon(graphics, primitive, 210.0f, 0x4FFFFFFF));
    }

    public void drawFocusedInTextureArea(class_332 graphics) {
        Matrix4f positionMatrix = this.texturePose.method_23760().method_23761();
        int length = 0;
        VertexData[] transformed = new VertexData[]{};
        VertexData[] reversed = new VertexData[]{};
        Vector3f position = new Vector3f();
        for (VertexData[] primitive : this.focusedPolyhedron) {
            if (length != primitive.length) {
                length = primitive.length;
                transformed = new VertexData[length];
                reversed = new VertexData[length];
            }
            for (int i = 0; i < length; ++i) {
                VertexData vertex = primitive[i];
                position.set(vertex.u(), vertex.v(), 0.0f).mulPosition((Matrix4fc)positionMatrix);
                VertexData vertexData = VertexData.immutable(position.x(), position.y(), 0.0f, vertex.argb(), vertex.u(), vertex.v(), vertex.overlay(), vertex.light(), 0.0f, 0.0f, 1.0f);
                reversed[length - 1 - i] = vertexData;
                transformed[i] = vertexData;
            }
            GUIHelper.renderPolygon(graphics, transformed, 0.0f, 0x4FFFFFFF);
            GUIHelper.renderPolygon(graphics, reversed, 0.0f, 0x4FFFFFFF);
        }
    }

    public void drawModel(class_332 graphics, class_4587 poseStack) {
        poseStack.method_22903();
        poseStack.method_34425(this.modelPose.method_23760().method_23761().invert(new Matrix4f()));
        float minEntityZ = 0.0f;
        float maxEntityZ = 200.0f;
        for (BuiltRecord record2 : this.modelRecords) {
            for (VertexData vertex : record2.vertices()) {
                if (vertex.z() < minEntityZ) {
                    minEntityZ = vertex.z();
                }
                if (!(vertex.z() > maxEntityZ)) continue;
                maxEntityZ = vertex.z();
            }
        }
        Matrix4f positionMatrix = new Matrix4f().mul((Matrix4fc)poseStack.method_23760().method_23761()).scale(1.0f, 1.0f, 200.0f / (maxEntityZ - minEntityZ)).translate(0.0f, 0.0f, -minEntityZ);
        Matrix3f normalMatrix = new Matrix3f((Matrix4fc)positionMatrix);
        this.modelRecords.forEach(record -> {
            class_4588 buffer = graphics.method_51450().getBuffer(record.renderType());
            if (!record.renderType().method_43332()) {
                for (VertexData vertex : record.vertices()) {
                    vertex.render(buffer, positionMatrix, normalMatrix);
                }
                return;
            }
            VertexData[][] vertexDataArray = record.primitives();
            int n = vertexDataArray.length;
            for (int i = 0; i < n; ++i) {
                VertexData[] primitive;
                for (VertexData vertex : primitive = vertexDataArray[i]) {
                    vertex.render(buffer, positionMatrix, normalMatrix);
                }
            }
        });
        poseStack.method_22909();
        graphics.method_51452();
    }

    public void drawTexture(class_332 graphics, class_4587 poseStack) {
        Matrix4f positionMatrix = poseStack.method_23760().method_23761();
        this.textureRecords.forEach(record -> {
            class_4588 buffer = graphics.method_51450().getBuffer(record.renderType());
            Vector3f position = new Vector3f();
            for (VertexData vertex : record.vertices()) {
                position.set(vertex.u(), vertex.v(), 0.0f).mulPosition((Matrix4fc)positionMatrix);
                buffer.method_23919(position.x(), position.y(), 0.0f, vertex.argb(), vertex.u(), vertex.v(), vertex.overlay(), vertex.light(), 0.0f, 0.0f, 1.0f);
            }
        });
        graphics.method_51452();
    }

    public void updateModel(class_310 client, class_1297 entity, float deltaTick, class_4587 poseStack) {
        class_308.method_34742();
        class_898 dispatcher = client.method_1561();
        dispatcher.method_3948(false);
        MultiVertexCatcher catcher = MultiVertexCatcher.defaultImpl();
        dispatcher.method_3954(entity, 0.0, 0.0, 0.0, 0.0f, deltaTick, poseStack, (class_4597)catcher, 0xF000F0);
        catcher.endCatching(this::computeBindResult);
        dispatcher.method_3948(true);
        class_308.method_24211();
    }

    public void computeBindResult(BuiltIterableBuffer builtBuffer) {
        VertexData[] vertices = (VertexData[])builtBuffer.vertexBuffer().stream().map(VertexData::asImmutable).toArray(VertexData[]::new);
        class_293.class_5596 drawMode = builtBuffer.renderType().method_23033();
        int primitiveLength = drawMode.field_27384;
        int primitiveStride = drawMode.field_27385;
        int primitiveCount = (vertices.length - primitiveLength) / primitiveStride + 1;
        boolean startWithFirst = drawMode == class_293.class_5596.field_27381;
        VertexData[][] primitives = new VertexData[primitiveCount][primitiveLength];
        int i = 0;
        int k = 0;
        while (i < primitiveCount) {
            primitives[i][0] = vertices[startWithFirst ? 0 : k];
            System.arraycopy(vertices, k + 1, primitives[i], 1, primitiveLength - 1);
            ++i;
            k += primitiveStride;
        }
        BuiltRecord record = new BuiltRecord(builtBuffer.renderType(), builtBuffer.textureId(), vertices, primitives);
        this.modelRecords.add(record);
        if (!builtBuffer.textureId().contains(this.target.textureId()) || this.currentRecord != null) {
            return;
        }
        BindResult result = new BindResult(this.target, true);
        BindTarget.TargetConfig config = this.target.targetConfig();
        VertexData.UV[] uvs = new VertexData.UV[]{new VertexData.UV(config.posU(), config.posV()), new VertexData.UV(config.forwardU(), config.forwardV()), new VertexData.UV(config.upwardU(), config.upwardV())};
        this.targetPrimitives = builtBuffer.findPrimitivesInCache(uvs);
        if (builtBuffer.anyNotCached(uvs)) {
            for (int i2 = 0; i2 < this.targetPrimitives.length; ++i2) {
                if (this.targetPrimitives[i2] == null) continue;
                uvs[i2] = null;
            }
            VertexData[][] newPrimitives = builtBuffer.findPrimitives(uvs);
            for (int i3 = 0; i3 < this.targetPrimitives.length; ++i3) {
                if (newPrimitives[i3] == null) continue;
                this.targetPrimitives[i3] = newPrimitives[i3];
            }
        }
        if (this.targetPrimitives[0] != null) {
            result.setPosition(VertexData.position(this.targetPrimitives[0], config.posU(), config.posV()));
        }
        if (this.targetPrimitives[1] != null) {
            result.setForward(VertexData.normal(this.targetPrimitives[1]).method_1021(-1.0));
        }
        if (this.targetPrimitives[2] != null) {
            result.setUpward(VertexData.normal(this.targetPrimitives[2]).method_1021(-1.0));
        }
        if (result.weakAvailable()) {
            this.currentRecord = record;
            this.bindResult = result.computeCamera();
        }
    }

    private record BuiltRecord(class_1921 renderType, String textureId, VertexData[] vertices, VertexData[][] primitives) {
    }
}

