/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.gui;

import com.xtracr.realcamera.util.LocUtil;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_5481;
import net.minecraft.class_7919;
import net.minecraft.class_8494;
import org.jetbrains.annotations.Nullable;

public abstract class NumberField<T extends Comparable<T>>
extends class_342 {
    private final T defaultValue;
    protected T maximum;
    protected T minimum;
    private class_7919 tooltip;

    NumberField(class_327 font, int width, int height, T defaultValue, T maximum, T minimum, @Nullable NumberField<T> copyFrom) {
        super(font, 0, 0, width, height, (class_2561)class_2561.method_43473());
        this.defaultValue = defaultValue;
        this.maximum = maximum;
        this.minimum = minimum;
        this.setNumber(defaultValue);
        if (copyFrom != null) {
            this.setNumber(copyFrom.getNumber());
        }
    }

    public static NumberField<Float> ofFloat(class_327 font, int width, int height, float defaultValue, @Nullable NumberField<Float> copyFrom) {
        return new FloatField(font, width, height, defaultValue, copyFrom);
    }

    public static NumberField<Integer> ofInt(class_327 font, int width, int height, int defaultValue, @Nullable NumberField<Integer> copyFrom) {
        return new IntField(font, width, height, defaultValue, copyFrom);
    }

    public T getNumber() {
        try {
            return this.getNumberInternal();
        }
        catch (Exception e) {
            return this.defaultValue;
        }
    }

    public void setNumber(T value) {
        try {
            if (value.compareTo(this.minimum) < 0) {
                value = this.minimum;
            } else if (value.compareTo(this.maximum) > 0) {
                value = this.maximum;
            }
            this.method_1852(value.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public NumberField<T> setMax(T maximum) {
        this.maximum = maximum;
        return this;
    }

    public NumberField<T> setMin(T minimum) {
        this.minimum = minimum;
        return this;
    }

    public NumberField<T> setOnValueChange(Consumer<T> consumer) {
        super.method_1863(str -> consumer.accept(this.getNumber()));
        return this;
    }

    protected abstract T getNumberInternal();

    protected void checkText() {
        super.method_47400(this.tooltip);
        this.method_1854((string, firstCharacterIndex) -> class_5481.method_30747((String)string, (class_2583)class_2583.field_24360));
        if (this.method_1882().isEmpty()) {
            return;
        }
        try {
            T value = this.getNumberInternal();
            if (value.compareTo(this.minimum) < 0) {
                throw new Exception("< " + String.valueOf(this.minimum));
            }
            if (value.compareTo(this.maximum) > 0) {
                throw new Exception("> " + String.valueOf(this.maximum));
            }
        }
        catch (Exception e) {
            super.method_47400(class_7919.method_47407((class_2561)LocUtil.literal("Invalid number: " + e.getMessage()).method_27694(s -> s.method_10977(class_124.field_1061))));
            this.method_1854((string, firstCharacterIndex) -> class_5481.method_30747((String)string, (class_2583)class_2583.field_24360.method_10977(class_124.field_1061)));
        }
    }

    public void method_47400(class_7919 tooltip) {
        this.tooltip = tooltip;
        super.method_47400(tooltip);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (class_8494.method_51255((int)keyCode)) {
            this.method_25365(false);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (chr != '-' && chr != '.' && (chr < '0' || chr > '9')) {
            return false;
        }
        return super.method_25400(chr, modifiers);
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float deltaTick) {
        this.checkText();
        super.method_48579(graphics, mouseX, mouseY, deltaTick);
    }

    private static class FloatField
    extends NumberField<Float> {
        FloatField(class_327 font, int width, int height, float defaultValue, @Nullable NumberField<Float> copyFrom) {
            super(font, width, height, Float.valueOf(defaultValue), Float.valueOf(Float.MAX_VALUE), Float.valueOf(-3.4028235E38f), copyFrom);
            this.method_1880(16);
        }

        @Override
        protected Float getNumberInternal() {
            return Float.valueOf(Float.parseFloat(this.method_1882()));
        }
    }

    private static class IntField
    extends NumberField<Integer> {
        IntField(class_327 font, int width, int height, int defaultValue, @Nullable NumberField<Integer> copyFrom) {
            super(font, width, height, defaultValue, Integer.MAX_VALUE, Integer.MIN_VALUE, copyFrom);
            this.method_1880(8);
        }

        @Override
        protected Integer getNumberInternal() {
            return Integer.parseInt(this.method_1882());
        }
    }
}

