/*
 * Decompiled with CFR 0.152.
 */
package com.xtracr.realcamera.util;

import net.minecraft.class_243;
import net.minecraft.class_4588;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public interface VertexData {
    public static VertexData immutable(float x, float y, float z, int argb, float u, float v, int overlay, int light, float normalX, float normalY, float normalZ) {
        return new ImmutableVertex(x, y, z, argb, u, v, overlay, light, normalX, normalY, normalZ);
    }

    public static MutableVertex mutable() {
        return new MutableVertex();
    }

    public static VertexData[] asImmutable(VertexData[] vertices) {
        VertexData[] immutable = new VertexData[vertices.length];
        for (int i = 0; i < vertices.length; ++i) {
            immutable[i] = vertices[i].asImmutable();
        }
        return immutable;
    }

    public static class_243 position(VertexData[] vertices, float u, float v) {
        if (vertices.length < 3) {
            return vertices[0].position();
        }
        float u0 = vertices[0].u();
        float v0 = vertices[0].v();
        float u1 = vertices[1].u();
        float v1 = vertices[1].v();
        float u2 = vertices[2].u();
        float v2 = vertices[2].v();
        float alpha = ((u - u1) * (v1 - v2) - (v - v1) * (u1 - u2)) / ((u0 - u1) * (v1 - v2) - (v0 - v1) * (u1 - u2));
        float beta = ((u - u2) * (v2 - v0) - (v - v2) * (u2 - u0)) / ((u1 - u2) * (v2 - v0) - (v1 - v2) * (u2 - u0));
        return vertices[0].position().method_1021((double)alpha).method_1019(vertices[1].position().method_1021((double)beta)).method_1019(vertices[2].position().method_1021((double)(1.0f - alpha - beta)));
    }

    public static class_243 normal(VertexData[] vertices) {
        return switch (vertices.length) {
            case 0 -> class_243.field_1353;
            case 1 -> vertices[0].normal();
            case 2 -> vertices[1].position().method_1020(vertices[0].position()).method_1029();
            default -> {
                class_243 a = vertices[0].position();
                class_243 b = vertices[1].position();
                class_243 c = vertices[2].position();
                yield b.method_1020(a).method_1036(c.method_1020(a)).method_1029();
            }
        };
    }

    public float x();

    public float y();

    public float z();

    default public class_243 position() {
        return new class_243((double)this.x(), (double)this.y(), (double)this.z());
    }

    public int argb();

    public float u();

    public float v();

    default public UV uv() {
        return new UV(this.u(), this.v());
    }

    public int overlay();

    public int light();

    public float normalX();

    public float normalY();

    public float normalZ();

    default public class_243 normal() {
        return new class_243((double)this.normalX(), (double)this.normalY(), (double)this.normalZ());
    }

    default public VertexData asImmutable() {
        return new ImmutableVertex(this.x(), this.y(), this.z(), this.argb(), this.u(), this.v(), this.overlay(), this.light(), this.normalX(), this.normalY(), this.normalZ());
    }

    default public void render(class_4588 buffer, Matrix4f positionMatrix, Matrix3f normalMatrix) {
        Vector3f pos = new Vector3f(this.x(), this.y(), this.z()).mulPosition((Matrix4fc)positionMatrix);
        Vector3f normal = new Vector3f(this.normalX(), this.normalY(), this.normalZ()).mul((Matrix3fc)normalMatrix);
        buffer.method_23919(pos.x(), pos.y(), pos.z(), this.argb(), this.u(), this.v(), this.overlay(), this.light(), normal.x(), normal.y(), normal.z());
    }

    default public void render(class_4588 buffer) {
        buffer.method_23919(this.x(), this.y(), this.z(), this.argb(), this.u(), this.v(), this.overlay(), this.light(), this.normalX(), this.normalY(), this.normalZ());
    }

    public record ImmutableVertex(float x, float y, float z, int argb, float u, float v, int overlay, int light, float normalX, float normalY, float normalZ) implements VertexData
    {
    }

    public static class MutableVertex
    implements VertexData {
        public float x;
        public float y;
        public float z;
        public int argb;
        public float u;
        public float v;
        public int overlay;
        public int light;
        public float normalX;
        public float normalY;
        public float normalZ;

        private MutableVertex() {
        }

        @Override
        public float x() {
            return this.x;
        }

        @Override
        public float y() {
            return this.y;
        }

        @Override
        public float z() {
            return this.z;
        }

        @Override
        public int argb() {
            return this.argb;
        }

        @Override
        public float u() {
            return this.u;
        }

        @Override
        public float v() {
            return this.v;
        }

        @Override
        public int overlay() {
            return this.overlay;
        }

        @Override
        public int light() {
            return this.light;
        }

        @Override
        public float normalX() {
            return this.normalX;
        }

        @Override
        public float normalY() {
            return this.normalY;
        }

        @Override
        public float normalZ() {
            return this.normalZ;
        }
    }

    public record UV(float u, float v) {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            float u1;
            float f;
            if (this == o) {
                return true;
            }
            if (!(o instanceof UV)) return false;
            UV uV = (UV)o;
            try {
                u1 = f = uV.u();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            float v1 = f = uV.v();
            if (Float.compare(this.u, u1) != 0) return false;
            if (Float.compare(this.v, v1) != 0) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return Float.hashCode(this.u) * 31 + Float.hashCode(this.v);
        }
    }
}

